/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ParameterPanel;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

public class UserFunctionEditor
extends JDialog
implements PropertyChangeListener {
    static final Color LIGHT_RED = new Color(255, 127, 127);
    static final Color LIGHT_MAGENTA = new Color(255, 153, 204);
    protected ParameterPanel paramPanel;
    protected UserFunction function;
    protected DatasetCurveFitter fitter;
    protected XMLTable table;
    protected boolean deleted;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected JButton undoButton;
    protected JButton redoButton;
    protected static NumberFormat format = NumberFormat.getNumberInstance();

    public UserFunctionEditor(UserFunction userFunction) {
        this(userFunction, null);
    }

    public UserFunctionEditor(UserFunction userFunction, DatasetCurveFitter datasetCurveFitter) {
        super((Frame)(datasetCurveFitter != null && datasetCurveFitter.getTopLevelAncestor() instanceof JFrame ? (JFrame)datasetCurveFitter.getTopLevelAncestor() : (JFrame)null), true);
        this.function = userFunction;
        this.fitter = datasetCurveFitter;
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.setTitle(ToolsRes.getString("UserFunctionEditor.Title") + " \"" + userFunction.getName() + "\"");
        this.paramPanel = new ParameterPanel();
        this.paramPanel.addPropertyChangeListener("parameter", this);
        this.paramPanel.getTable().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractCellEditor abstractCellEditor = (AbstractCellEditor)((Object)UserFunctionEditor.this.table.getCellEditor());
                if (abstractCellEditor != null) {
                    abstractCellEditor.stopCellEditing();
                }
            }
        });
        for (int i = 0; i < userFunction.getParameterCount(); ++i) {
            this.paramPanel.addParameter(new Parameter(userFunction.getParameterName(i), String.valueOf(userFunction.getParameterValue(i))));
        }
        Box box = Box.createVerticalBox();
        this.getContentPane().add((Component)box, "Center");
        box.add(this.paramPanel);
        this.paramPanel.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("UserFunctionEditor.Parameter.Border.Title")));
        XMLControlElement xMLControlElement = new XMLControlElement();
        xMLControlElement.setValue(userFunction.getName(), userFunction.getExpression());
        this.table = new OSPControlTable(xMLControlElement);
        this.table.setEditable(true);
        this.table.addPropertyChangeListener("tableData", this);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractCellEditor abstractCellEditor = (AbstractCellEditor)((Object)UserFunctionEditor.this.paramPanel.getTable().getCellEditor());
                if (abstractCellEditor != null) {
                    abstractCellEditor.stopCellEditing();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.createHorizontalScrollBar();
        JPanel jPanel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                Dimension dimension = UserFunctionEditor.this.table.getPreferredSize();
                return dimension;
            }
        };
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("UserFunctionEditor.Function.Border.Title") + " (" + userFunction.getIndependentVariable() + ")"));
        box.add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.getContentPane().add((Component)jPanel2, "South");
        this.undoButton = new JButton(ToolsRes.getString("UserFunctionEditor.Button.Undo"));
        this.undoButton.setEnabled(false);
        jPanel2.add(this.undoButton);
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserFunctionEditor.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton(ToolsRes.getString("UserFunctionEditor.Button.Redo"));
        this.redoButton.setEnabled(false);
        jPanel2.add(this.redoButton);
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserFunctionEditor.this.undoManager.redo();
            }
        });
        JButton jButton = new JButton(ToolsRes.getString("UserFunctionEditor.Button.Delete") + " " + userFunction.getName());
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserFunctionEditor.this.deleted = true;
                ((Component)UserFunctionEditor.this).setVisible(false);
            }
        });
        JButton jButton2 = new JButton(ToolsRes.getString("UserFunctionEditor.Button.Close"));
        jPanel2.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserFunctionEditor.this.function.setParameters(UserFunctionEditor.this.paramPanel.getNames(), UserFunctionEditor.this.paramPanel.getValues());
                XMLControl xMLControl = UserFunctionEditor.this.table.getControl();
                String string = xMLControl.getString(UserFunctionEditor.this.function.getName());
                UserFunctionEditor.this.function.setExpression(string, UserFunctionEditor.this.function.getIndependentVariable());
                ((Component)UserFunctionEditor.this).setVisible(false);
            }
        });
        this.pack();
        ((Component)this).setSize(this.getWidth(), 280);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(n, n2);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void refresh() {
        Parameter[] parameterArray = this.paramPanel.getParameters();
        for (int i = 0; i < this.function.getParameterCount(); ++i) {
            if (parameterArray[i].getValue() == this.function.getParameterValue(i)) continue;
            this.paramPanel.replaceParameter(new Parameter(parameterArray[i].getName(), format.format(this.function.getParameterValue(i))));
            Parameter[] parameterArray2 = this.paramPanel.getParameters();
            ParameterPanel parameterPanel = this.paramPanel;
            parameterPanel.getClass();
            ParameterPanel.ParamEdit paramEdit = parameterPanel.new ParameterPanel.ParamEdit(parameterArray2, parameterArray, i, i, 1, 1);
            this.undoSupport.postEdit(paramEdit);
            parameterArray = parameterArray2;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String[] stringArray;
        String string = this.table.getControl().getString(this.function.getName());
        if ("".equals(string)) {
            string = "0";
            this.table.getControl().setValue(this.function.getName(), string);
        }
        if (propertyChangeEvent != null && propertyChangeEvent.getNewValue() instanceof UndoableEdit) {
            this.undoSupport.postEdit((UndoableEdit)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName().equals("tableData") && !this.function.getExpression().equals(string)) {
            stringArray = new FunctionEdit(string, this.function.getExpression());
            this.undoSupport.postEdit((UndoableEdit)stringArray);
        }
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
        string = string.replaceAll(this.function.getIndependentVariable(), "dummy");
        stringArray = this.paramPanel.getNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "dummy";
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        boolean bl = string.indexOf("=") > -1;
        try {
            new ParsedMultiVarFunction(string, stringArray2);
        }
        catch (ParserException parserException) {
            bl = true;
        }
        if (bl) {
            this.table.setBackgroundColor(this.function.getName(), LIGHT_RED);
            this.table.setSelectedColor(this.function.getName(), LIGHT_MAGENTA);
        } else {
            this.table.setBackgroundColor(this.function.getName(), null);
            this.table.setSelectedColor(this.function.getName(), null);
            if (this.fitter != null) {
                this.function.setParameters(this.paramPanel.getNames(), this.paramPanel.getValues());
                this.function.setExpression(string, this.function.getIndependentVariable());
                this.fitter.selectFit(this.function.getName());
                this.fitter.refreshGUI();
            }
        }
        this.table.repaint();
    }

    static {
        ((DecimalFormat)format).applyPattern("0.000E0");
    }

    class FunctionEdit
    extends AbstractUndoableEdit {
        String prev;
        String curr;

        public FunctionEdit(String string, String string2) {
            this.prev = string2;
            this.curr = string;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            UserFunctionEditor.this.table.getControl().setValue(UserFunctionEditor.this.function.getName(), this.prev);
            UserFunctionEditor.this.propertyChange(null);
        }

        public void redo() throws CannotUndoException {
            super.redo();
            UserFunctionEditor.this.table.getControl().setValue(UserFunctionEditor.this.function.getName(), this.curr);
            UserFunctionEditor.this.propertyChange(null);
        }

        public String getPresentationName() {
            return "Function";
        }
    }
}

