/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public class TristateCheckBox
extends JCheckBox {
    public static final State NOT_SELECTED = new State();
    public static final State SELECTED = new State();
    public static final State PART_SELECTED = new State();
    private final TristateDecorator model;

    public TristateCheckBox(String string, Icon icon, State state) {
        super(string, icon);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TristateCheckBox.this.grabFocus();
                TristateCheckBox.this.model.nextState();
            }
        });
        actionMapUIResource.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(state);
    }

    public TristateCheckBox(String string, State state) {
        this(string, null, state);
    }

    public TristateCheckBox(String string) {
        this(string, PART_SELECTED);
    }

    public TristateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.setState(SELECTED);
        } else {
            this.setState(NOT_SELECTED);
        }
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        private void setState(State state) {
            if (state == NOT_SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (state == SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return PART_SELECTED;
            }
            return NOT_SELECTED;
        }

        private void nextState() {
            State state = this.getState();
            if (state == NOT_SELECTED) {
                this.setState(SELECTED);
            } else if (state == SELECTED) {
                this.setState(PART_SELECTED);
            } else if (state == PART_SELECTED) {
                this.setState(NOT_SELECTED);
            }
        }

        public void setArmed(boolean bl) {
        }

        public void setEnabled(boolean bl) {
            TristateCheckBox.this.setFocusable(bl);
            this.other.setEnabled(bl);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean bl) {
            this.other.setSelected(bl);
        }

        public void setPressed(boolean bl) {
            this.other.setPressed(bl);
        }

        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static class State {
        private State() {
        }
    }
}

