/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.Resource;

public class ResourceLoader {
    protected static ArrayList searchPaths = new ArrayList();
    protected static int maxPaths = 20;
    protected static Hashtable resources = new Hashtable();
    protected static boolean cacheEnabled = false;
    protected static Map zipLoaders = new TreeMap();
    protected static URLClassLoader xsetZipLoader;
    protected static ArrayList extractExtensions;
    static /* synthetic */ Class class$org$opensourcephysics$tools$Resource;

    private ResourceLoader() {
    }

    public static Resource getResource(String string) {
        return ResourceLoader.getResource(string, true);
    }

    public static Resource getResource(String string, boolean bl) {
        return ResourceLoader.getResource(string, class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource, bl);
    }

    public static Resource getResource(String string, Class clazz) {
        return ResourceLoader.getResource(string, clazz, true);
    }

    public static Resource getResource(String string, Class clazz, boolean bl) {
        if (string == null || string.equals("")) {
            return null;
        }
        Resource resource = ResourceLoader.findResource(string, clazz, bl);
        if (resource != null) {
            return resource;
        }
        StringBuffer stringBuffer = new StringBuffer("Not found: " + string);
        stringBuffer.append(" [searched " + string);
        Iterator iterator = ((AbstractList)searchPaths).iterator();
        while (iterator.hasNext()) {
            String string2 = ResourceLoader.getPath((String)iterator.next(), string);
            resource = ResourceLoader.findResource(string2, clazz, bl);
            if (resource != null) {
                return resource;
            }
            stringBuffer.append(";" + string2);
        }
        stringBuffer.append("]");
        OSPLog.fine(stringBuffer.toString());
        return null;
    }

    public static Resource getResource(String string, String string2) {
        return ResourceLoader.getResource(string, string2, class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource);
    }

    public static Resource getResource(String string, String string2, boolean bl) {
        return ResourceLoader.getResource(string, string2, class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource, bl);
    }

    public static Resource getResource(String string, String string2, Class clazz) {
        return ResourceLoader.getResource(string, string2, clazz, true);
    }

    public static Resource getResource(String string, String string2, Class clazz, boolean bl) {
        Object object;
        if (string == null) {
            return ResourceLoader.getResource(string2, clazz);
        }
        String string3 = ResourceLoader.getPath(string, string2);
        Resource resource = ResourceLoader.findResource(string3, clazz, bl);
        if (resource != null) {
            return resource;
        }
        if (string.startsWith("/") || string.indexOf(":/") > -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("Not found: " + string3);
        stringBuffer.append(" [searched " + string3);
        if (OSPRuntime.applet != null) {
            object = OSPRuntime.applet.getDocumentBase().toExternalForm();
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)(object = XML.getDirectoryPath((String)object) + "/"), string), string2);
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            stringBuffer.append(";" + string3);
            String string4 = OSPRuntime.applet.getCodeBase().toExternalForm();
            if (!string4.equals(object)) {
                string3 = ResourceLoader.getPath(ResourceLoader.getPath(string4, string), string2);
                resource = ResourceLoader.findResource(string3, clazz, bl);
                if (resource != null) {
                    return resource;
                }
                stringBuffer.append(";" + string3);
            }
        }
        object = ((AbstractList)searchPaths).iterator();
        while (object.hasNext()) {
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)object.next(), string), string2);
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            stringBuffer.append(";" + string3);
        }
        stringBuffer.append("]");
        OSPLog.fine(stringBuffer.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String string) {
        if (string == null || string.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                ((AbstractCollection)searchPaths).remove(string);
            } else {
                OSPLog.fine("Added path: " + string);
            }
            searchPaths.add(0, string);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                string = (String)searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + string);
                ((AbstractCollection)searchPaths).remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                OSPLog.fine("Removed path: " + string);
                ((AbstractCollection)searchPaths).remove(string);
            }
        }
    }

    public static void setCacheEnabled(boolean bl) {
        cacheEnabled = bl;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtractExtension(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        OSPLog.finest("Added extension: " + string);
        ArrayList arrayList = extractExtensions;
        synchronized (arrayList) {
            extractExtensions.add(string);
        }
    }

    public static InputStream openInputStream(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openInputStream();
    }

    public static Reader openReader(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openReader();
    }

    public static String getString(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getString();
    }

    public static ImageIcon getIcon(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getIcon();
    }

    public static Image getImage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getImage();
    }

    public static BufferedImage getBufferedImage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getBufferedImage();
    }

    public static AudioClip getAudioClip(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getAudioClip();
    }

    private static Resource createFileResource(String string) {
        if (OSPRuntime.applet != null) {
            return null;
        }
        if (string.indexOf(".zip") > -1 || string.indexOf(".jar") > -1) {
            return null;
        }
        File file = new File(string);
        try {
            if (file.exists() && file.canRead()) {
                Resource resource = new Resource(file);
                if (string.endsWith("xset")) {
                    xsetZipLoader = null;
                }
                OSPLog.fine("File: " + XML.forwardSlash(resource.getAbsolutePath()));
                return resource;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return null;
    }

    private static Resource createURLResource(String string) {
        if (string.indexOf(".zip") > -1 || string.indexOf(".jar") > -1) {
            return null;
        }
        Resource resource = null;
        if (string.indexOf(":/") > -1) {
            try {
                URL uRL = new URL(string);
                resource = ResourceLoader.createResource(uRL);
            }
            catch (Exception exception) {}
        } else if (OSPRuntime.applet != null && !string.startsWith("/")) {
            URL uRL;
            URL uRL2 = OSPRuntime.applet.getDocumentBase();
            try {
                uRL = new URL(uRL2, string);
                resource = ResourceLoader.createResource(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resource == null) {
                uRL = OSPRuntime.applet.getCodeBase();
                String string2 = XML.getDirectoryPath(uRL2.toExternalForm()) + "/";
                if (!uRL.toExternalForm().equals(string2)) {
                    try {
                        URL uRL3 = new URL(uRL, string);
                        resource = ResourceLoader.createResource(uRL3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (resource != null) {
            if (string.endsWith(".xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("URL: " + XML.forwardSlash(resource.getAbsolutePath()));
        }
        return resource;
    }

    private static Resource createZipResource(String string) {
        Object object;
        Object object2;
        URL[] uRLArray;
        Object object3;
        Object object4 = null;
        String string2 = string;
        int n = string.indexOf("zip!/");
        if (n == -1) {
            n = string.indexOf("jar!/");
        }
        if (n > -1) {
            object4 = string.substring(0, n + 3);
            string2 = string.substring(n + 5);
        }
        if (object4 == null) {
            if (string.endsWith(".zip") || string.endsWith(".jar")) {
                object3 = XML.stripExtension(XML.getName(string));
                object4 = string;
                string2 = (String)object3 + ".xset";
            } else if (string.endsWith(".xset")) {
                object4 = string.substring(0, string.length() - 4) + "zip";
            }
        }
        object3 = null;
        URL uRL = null;
        if (object4 != null) {
            object3 = (URLClassLoader)zipLoaders.get(object4);
            if (object3 != null) {
                uRL = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    uRLArray = new URL[]{new URL("file", null, (String)object4)};
                    object3 = new URLClassLoader(uRLArray);
                    uRL = ((URLClassLoader)object3).findResource(string2);
                    if (uRL == null && (object2 = (class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource).getResource("/" + (String)object4)) != null) {
                        uRLArray = new URL[]{object2};
                        object3 = new URLClassLoader(uRLArray);
                        uRL = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (uRL != null) {
                        zipLoaders.put(object4, object3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (uRL == null && xsetZipLoader != null && (uRL = xsetZipLoader.findResource(string2)) != null) {
            uRLArray = zipLoaders.keySet().iterator();
            while (uRLArray.hasNext()) {
                object2 = uRLArray.next();
                if (zipLoaders.get(object2) != xsetZipLoader) continue;
                object4 = (String)object2;
                break;
            }
        }
        uRLArray = OSPRuntime.getLaunchJarPath();
        if (uRL == null && uRLArray != null) {
            object3 = (URLClassLoader)zipLoaders.get(uRLArray);
            if (object3 != null) {
                uRL = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    object2 = new URL[]{new URL("file", null, (String)uRLArray)};
                    object3 = new URLClassLoader((URL[])object2);
                    uRL = ((URLClassLoader)object3).findResource(string2);
                    if (uRL == null && (object = (class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource).getResource("/" + (String)uRLArray)) != null) {
                        object2 = new URL[]{object};
                        object3 = new URLClassLoader((URL[])object2);
                        uRL = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (uRL != null) {
                        zipLoaders.put(uRLArray, object3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (uRL != null) {
                object4 = uRLArray;
            }
        }
        if (uRL != null) {
            object2 = ((AbstractList)extractExtensions).iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!uRL.getFile().endsWith((String)object)) continue;
                File file = new File((String)object4);
                JarTool.extract(file, string, string);
                return ResourceLoader.createFileResource(string);
            }
            try {
                object = ResourceLoader.createResource(uRL);
                if (object == null || ((Resource)object).getAbsolutePath().indexOf(string) == -1) {
                    return null;
                }
                if (string2.endsWith("xset")) {
                    xsetZipLoader = object3;
                }
                OSPLog.fine("Zip: " + XML.forwardSlash(((Resource)object).getAbsolutePath()));
                return object;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Resource createClassResource(String string, Class clazz) {
        Object object;
        if (string.indexOf(":/") != -1) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf("jar!/");
        if (n != -1) {
            string = string.substring(n + 5);
        }
        Resource resource = null;
        try {
            object = clazz.getResource("/" + string);
            resource = ResourceLoader.createResource((URL)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resource == null) {
            try {
                object = clazz.getResource(string);
                resource = ResourceLoader.createResource((URL)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resource != null) {
            object = XML.forwardSlash(resource.getAbsolutePath());
            if (((String)object).indexOf("/jre") > -1 && ((String)object).indexOf("/lib") > -1) {
                return null;
            }
            if (((String)object).indexOf(string2) == -1) {
                return null;
            }
            if (string.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("Class resource: " + (String)object);
            OSPRuntime.setLaunchJarPath((String)object);
        }
        return resource;
    }

    private static Resource createResource(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream.read() == -1) {
            return null;
        }
        inputStream.close();
        return new Resource(uRL);
    }

    private static Resource findResource(String string, Class clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = class$org$opensourcephysics$tools$Resource == null ? (class$org$opensourcephysics$tools$Resource = ResourceLoader.class$("org.opensourcephysics.tools.Resource")) : class$org$opensourcephysics$tools$Resource;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = (Resource)resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        if (bl && (resource = ResourceLoader.createFileResource(string)) != null || (resource = ResourceLoader.createURLResource(string)) != null || (resource = ResourceLoader.createZipResource(string)) != null || (resource = ResourceLoader.createClassResource(string, clazz)) != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static String getPath(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            string = string + "!";
        }
        String string3 = XML.getResolvedPath(string2, string);
        if (System.getProperty("os.name").indexOf("Mac") > -1 && string3.startsWith("file:/") && !string3.startsWith("file:///")) {
            string3 = string3.substring(6);
            while (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            string3 = "file:///" + string3;
        }
        return string3;
    }

    static {
        extractExtensions = new ArrayList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

