/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class ParameterPanel
extends JPanel {
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final Color LIGHT_RED = new Color(255, 127, 127);
    static final Color LIGHT_MAGENTA = new Color(255, 153, 204);
    static final Color LIGHT_GRAY = UIManager.getColor("Panel.background");
    protected ArrayList parameters = new ArrayList();
    protected Parameter[] prevParameters;
    protected String[] paramNames = new String[0];
    protected double[] paramValues = new double[0];
    protected ParamTableModel paramModel = new ParamTableModel();
    protected ParamTable paramTable;
    protected ParamCellEditor paramEditor = new ParamCellEditor();
    protected ParamCellRenderer paramRenderer = new ParamCellRenderer();
    protected int id = 0;
    protected JButton newButton;
    protected JButton deleteButton;
    protected JScrollPane paramScroller;
    protected JPanel buttonPanel;

    public ParameterPanel() {
        super(new BorderLayout());
        this.createGUI();
        this.refreshGUI();
    }

    public JTable getTable() {
        return this.paramTable;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.paramTable.getPreferredSize();
        dimension.height += this.buttonPanel.getPreferredSize().height;
        return dimension;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters.clear();
        for (int i = 0; i < parameterArray.length; ++i) {
            this.parameters.add(parameterArray[i]);
        }
        this.evaluateAll();
        this.paramModel.fireTableStructureChanged();
        this.deleteButton.setEnabled(this.canDelete());
    }

    public Parameter[] getParameters() {
        Parameter[] parameterArray = new Parameter[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.parameters.get(i);
            parameterArray[i] = new Parameter(parameter.paramName, parameter.funcStr);
            parameterArray[i].setEditable(parameter.isEditable());
            parameterArray[i].value = parameter.value;
        }
        return parameterArray;
    }

    public void addParameter(Parameter parameter) {
        Parameter[] parameterArray = new Parameter[this.parameters.size() + 1];
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter2 = (Parameter)this.parameters.get(i);
            parameterArray[i] = new Parameter(parameter2.paramName, parameter2.funcStr);
            parameterArray[i].setEditable(parameter2.isEditable());
            parameterArray[i].value = parameter2.value;
        }
        parameterArray[i] = parameter;
        this.setParameters(parameterArray);
    }

    public Parameter replaceParameter(Parameter parameter) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter2 = (Parameter)this.parameters.get(i);
            if (!parameter2.getName().equals(parameter.getName())) continue;
            ((AbstractCollection)this.parameters).remove(parameter2);
            this.parameters.add(i, parameter);
            this.evaluateAll();
            this.paramModel.fireTableStructureChanged();
            return parameter2;
        }
        return null;
    }

    public String[] getNames() {
        return this.paramNames;
    }

    public double[] getValues() {
        return this.paramValues;
    }

    public void evaluateAll() {
        this.paramNames = new String[this.parameters.size()];
        this.paramValues = new double[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = (Parameter)this.parameters.get(i);
            parameter.evaluate(this.parameters);
            this.paramNames[i] = parameter.getName();
            this.paramValues[i] = parameter.getValue();
        }
    }

    public void refreshStrings() {
        this.refreshGUI();
    }

    protected void createGUI() {
        this.paramTable = new ParamTable(this.paramModel);
        this.paramScroller = new JScrollPane(this.paramTable);
        this.paramScroller.createHorizontalScrollBar();
        this.add((Component)this.paramScroller, "Center");
        this.buttonPanel = new JPanel(new FlowLayout());
        this.newButton = new JButton(ToolsRes.getString("ParameterPanel.Button.NewParameter"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ParameterPanel.this.paramTable.getSelectedRow();
                int n2 = ParameterPanel.this.paramTable.getSelectedColumn();
                ParameterPanel.this.prevParameters = ParameterPanel.this.getParameters();
                String string = ToolsRes.getString("ParameterPanel.NewParameter.Name.Default");
                Parameter parameter = new Parameter(string + ParameterPanel.this.id++, "0");
                ParameterPanel.this.parameters.add(parameter);
                ParameterPanel.this.evaluateAll();
                ParameterPanel.this.paramModel.fireTableStructureChanged();
                ParameterPanel.this.deleteButton.setEnabled(true);
                int n3 = ParameterPanel.this.parameters.size() - 1;
                ParamEdit paramEdit = new ParamEdit(ParameterPanel.this.getParameters(), ParameterPanel.this.prevParameters, n3, n, 0, n2);
                ParameterPanel.this.paramTable.setColumnSelectionInterval(0, 0);
                ParameterPanel.this.paramTable.setRowSelectionInterval(n3, n3);
                ParameterPanel.this.paramTable.requestFocusInWindow();
                ParameterPanel.this.firePropertyChange("parameter", null, paramEdit);
            }
        });
        this.buttonPanel.add(this.newButton);
        this.deleteButton = new JButton(ToolsRes.getString("ParameterPanel.Button.DeleteParameter"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = ParameterPanel.this.paramTable.getSelectedRow();
                if (n2 < 0) {
                    return;
                }
                Parameter parameter = (Parameter)ParameterPanel.this.parameters.get(n2);
                if (!parameter.isEditable()) {
                    return;
                }
                int n3 = ParameterPanel.this.paramTable.getSelectedColumn();
                ParameterPanel.this.prevParameters = ParameterPanel.this.getParameters();
                ParameterPanel.this.parameters.remove(n2);
                ParameterPanel.this.evaluateAll();
                ParameterPanel.this.paramModel.fireTableStructureChanged();
                ParameterPanel.this.deleteButton.setEnabled(ParameterPanel.this.canDelete());
                int n4 = n = n2 == ParameterPanel.this.parameters.size() ? n2 - 1 : n2;
                if (n >= 0) {
                    ParameterPanel.this.paramTable.setColumnSelectionInterval(0, 0);
                    ParameterPanel.this.paramTable.setRowSelectionInterval(n, n);
                }
                ParamEdit paramEdit = new ParamEdit(ParameterPanel.this.getParameters(), ParameterPanel.this.prevParameters, n, n2, 0, n3);
                ParameterPanel.this.firePropertyChange("parameter", null, paramEdit);
            }
        });
        this.buttonPanel.add(this.deleteButton);
        this.add((Component)this.buttonPanel, "South");
    }

    protected void refreshGUI() {
        this.newButton.setText(ToolsRes.getString("ParameterPanel.Button.NewParameter"));
        this.deleteButton.setText(ToolsRes.getString("ParameterPanel.Button.DeleteParameter"));
        this.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("ParameterPanel.Border.Title")));
        int n = this.paramTable.getSelectedRow();
        int n2 = this.paramTable.getSelectedColumn();
        this.paramModel.fireTableStructureChanged();
        this.paramTable.changeSelection(n, n2, false, false);
    }

    protected boolean canDelete() {
        Iterator iterator = ((AbstractList)this.parameters).iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.isEditable()) continue;
            return true;
        }
        return false;
    }

    protected class ParamCellRenderer
    extends DefaultTableCellRenderer {
        Font font = new JTextField().getFont();

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setFont(this.font);
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            Parameter parameter = (Parameter)ParameterPanel.this.parameters.get(n);
            if (n2 == 1 && Double.isNaN(parameter.value)) {
                if (bl) {
                    this.setForeground(Color.RED);
                    this.setBackground(LIGHT_MAGENTA);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(LIGHT_RED);
                }
            } else if (!parameter.isEditable()) {
                this.setForeground(Color.BLACK);
                this.setBackground(LIGHT_GRAY);
            } else if (bl) {
                this.setForeground(Color.RED);
                this.setBackground(LIGHT_BLUE);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    protected class ParamCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        int keepFocus = -2;

        ParamCellEditor() {
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 2));
            this.field.setBorder(null);
            this.field.setEditable(true);
            this.field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ParamCellEditor.this.stopCellEditing();
                    ParamCellEditor.this.keepFocus = -2;
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ParamCellEditor.this.stopCellEditing();
                        ParamCellEditor.this.keepFocus = -2;
                    } else {
                        ParamCellEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    int n;
                    if (ParamCellEditor.this.field.getBackground() != Color.WHITE) {
                        ParamCellEditor.this.stopCellEditing();
                    }
                    if (ParamCellEditor.this.keepFocus == (n = ((ParamCellEditor)ParamCellEditor.this).ParameterPanel.this.paramTable.getSelectedRow())) {
                        ParamCellEditor.this.keepFocus = -2;
                    } else {
                        ((ParamCellEditor)ParamCellEditor.this).ParameterPanel.this.paramTable.requestFocusInWindow();
                    }
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.field.setText(object.toString());
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                this.keepFocus = n = ParameterPanel.this.paramTable.rowAtPoint(mouseEvent.getPoint());
                return true;
            }
            if (eventObject == null || eventObject instanceof ActionEvent) {
                this.keepFocus = -2;
                return true;
            }
            return false;
        }

        public Object getCellEditorValue() {
            this.field.setBackground(Color.WHITE);
            return this.field.getText();
        }
    }

    protected class ParamTableModel
    extends AbstractTableModel {
        protected ParamTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ParameterPanel.this.parameters.size();
        }

        public String getColumnName(int n) {
            return n == 0 ? ToolsRes.getString("ParameterPanel.Table.Column.Name") : ToolsRes.getString("ParameterPanel.Table.Column.Value");
        }

        public Object getValueAt(int n, int n2) {
            Parameter parameter = (Parameter)ParameterPanel.this.parameters.get(n);
            return n2 == 0 ? parameter.paramName : parameter.funcStr;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                ParameterPanel.this.prevParameters = ParameterPanel.this.getParameters();
                Parameter parameter = (Parameter)ParameterPanel.this.parameters.get(n);
                if (n2 == 0) {
                    if (string.equals(parameter.paramName)) {
                        return;
                    }
                    boolean bl = false;
                    Iterator iterator = ((AbstractList)ParameterPanel.this.parameters).iterator();
                    while (iterator.hasNext() && !bl) {
                        Parameter parameter2 = (Parameter)iterator.next();
                        if (parameter2 == parameter) continue;
                        bl = parameter2.paramName.equals(string);
                    }
                    if (bl) {
                        JOptionPane.showMessageDialog(null, ToolsRes.getString("ParameterPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("ParameterPanel.Dialog.DuplicateName.Title"), 2);
                        return;
                    }
                    ((AbstractCollection)ParameterPanel.this.parameters).remove(parameter);
                    parameter = new Parameter(string, parameter.getFunctionString());
                    ParameterPanel.this.parameters.add(n, parameter);
                } else {
                    if (string.equals(parameter.funcStr)) {
                        return;
                    }
                    ((AbstractCollection)ParameterPanel.this.parameters).remove(parameter);
                    parameter = new Parameter(parameter.getName(), string);
                    ParameterPanel.this.parameters.add(n, parameter);
                }
                ParameterPanel.this.evaluateAll();
                ParameterPanel.this.paramTable.repaint();
                ParamEdit paramEdit = new ParamEdit(ParameterPanel.this.getParameters(), ParameterPanel.this.prevParameters, n, n, n2, n2);
                ParameterPanel.this.firePropertyChange("parameter", null, paramEdit);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            Parameter parameter = (Parameter)ParameterPanel.this.parameters.get(n);
            return parameter.isEditable();
        }
    }

    protected class ParamTable
    extends JTable {
        ParamTable(ParamTableModel paramTableModel) {
            this.setModel(paramTableModel);
            this.setSelectionMode(0);
            this.setColumnSelectionAllowed(true);
            this.getTableHeader().setReorderingAllowed(false);
            this.setGridColor(Color.BLACK);
            InputMap inputMap = this.getInputMap(1);
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanel jPanel;
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    jTable.editCellAt(n, n2, actionEvent);
                    Component component = jTable.getEditorComponent();
                    if (component instanceof JPanel && (component = (jPanel = (JPanel)component).getComponent(0)) instanceof JTextField) {
                        JTextField jTextField = (JTextField)component;
                        jTextField.requestFocus();
                        jTextField.selectAll();
                    }
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            if (n < 0) {
                return;
            }
            Parameter parameter = (Parameter)ParameterPanel.this.parameters.get(n);
            if (parameter.isEditable()) {
                super.changeSelection(n, n2, bl, bl2);
            }
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            return ParameterPanel.this.paramEditor;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return ParameterPanel.this.paramRenderer;
        }
    }

    protected class ParamEdit
    extends AbstractUndoableEdit {
        Parameter[] params;
        Parameter[] prev;
        int row;
        int prevRow;
        int col;
        int prevCol;

        public ParamEdit(Parameter[] parameterArray, Parameter[] parameterArray2, int n, int n2, int n3, int n4) {
            this.params = parameterArray;
            this.prev = parameterArray2;
            this.row = n;
            this.prevRow = n2;
            this.col = n3;
            this.prevCol = n4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            ParameterPanel.this.setParameters(this.prev);
            ParameterPanel.this.paramTable.changeSelection(this.prevRow, this.prevCol, false, false);
            ParameterPanel.this.paramTable.requestFocusInWindow();
            ParameterPanel.this.firePropertyChange("parameter", null, null);
        }

        public void redo() throws CannotUndoException {
            super.redo();
            ParameterPanel.this.setParameters(this.params);
            ParameterPanel.this.paramTable.changeSelection(this.row, this.col, false, false);
            ParameterPanel.this.paramTable.requestFocusInWindow();
            ParameterPanel.this.firePropertyChange("parameter", null, null);
        }

        public String getPresentationName() {
            return "User Parameter";
        }
    }
}

