/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.net.URL;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.Launcher;

public class LauncherUndo
extends UndoManager {
    private Launcher launcher;

    public LauncherUndo(Launcher launcher) {
        this.setLauncher(launcher);
    }

    public void setLauncher(Launcher launcher) {
        this.launcher = launcher;
    }

    public boolean canReload() {
        return this.editToBeUndone() instanceof LoadEdit;
    }

    public String[] getLauncherState() {
        String[] stringArray;
        if (this.launcher.tabSetName == null) {
            return null;
        }
        String string = XML.getResolvedPath(this.launcher.tabSetName, Launcher.tabSetBasePath);
        if (!string.startsWith(Launcher.defaultFileName) && Launcher.tabSetBasePath.equals("")) {
            string = OSPRuntime.getLaunchJarName() + "!/" + string;
        } else {
            stringArray = new File(string);
            if (!stringArray.exists()) {
                return null;
            }
        }
        stringArray = new String[]{string, this.launcher.getSelectedNode() != null ? this.launcher.getSelectedNode().getPathString() : (this.launcher.getSelectedTab() == null ? "" : this.launcher.getSelectedTab().getRootNode().name)};
        return stringArray;
    }

    protected class NavEdit
    extends AbstractUndoableEdit {
        String undoFile;
        String redoFile;
        String undoNode;
        String redoNode;
        Integer undoPage;
        Integer redoPage;
        URL redoURL;
        URL undoURL;

        public NavEdit(Object[] objectArray, Object[] objectArray2) {
            this.undoFile = (String)objectArray[0];
            this.redoFile = (String)objectArray2[0];
            this.undoNode = (String)objectArray[1];
            this.redoNode = (String)objectArray2[1];
            this.undoPage = (Integer)objectArray[2];
            this.redoPage = (Integer)objectArray2[2];
            this.undoURL = (URL)objectArray[3];
            this.redoURL = (URL)objectArray2[3];
        }

        public NavEdit(LaunchNode launchNode, LaunchNode launchNode2) {
            if (launchNode != null) {
                this.undoNode = launchNode.getPathString();
                this.undoURL = launchNode.htmlURL;
                this.undoPage = new Integer(launchNode.htmlTabNumber);
            }
            if (launchNode2 != null) {
                this.redoNode = launchNode2.getPathString();
                this.redoURL = launchNode2.htmlURL;
                this.redoPage = new Integer(launchNode2.htmlTabNumber);
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.undoFile == null || !this.undoFile.equals(this.redoFile)) {
                // empty if block
            }
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            int n = this.undoPage == null ? 0 : this.undoPage;
            LauncherUndo.this.launcher.setSelectedNode(this.undoNode, n, this.undoURL);
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        public void redo() throws CannotUndoException {
            super.redo();
            if (this.redoFile == null || !this.redoFile.equals(this.undoFile)) {
                // empty if block
            }
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            int n = this.redoPage == null ? 0 : this.redoPage;
            LauncherUndo.this.launcher.setSelectedNode(this.redoNode, n, this.redoURL);
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        public String getPresentationName() {
            return "Navigation";
        }
    }

    protected class LoadEdit
    extends AbstractUndoableEdit {
        String[] args = new String[2];
        String[] prev = new String[2];

        public LoadEdit(String[] stringArray, String[] stringArray2) {
            if (stringArray != null) {
                this.args[0] = stringArray[0];
                this.args[1] = stringArray.length < 2 ? "" : stringArray[1];
            }
            this.prev[0] = stringArray2[0];
            this.prev[1] = stringArray2.length < 2 ? "" : stringArray2[1];
        }

        public void undo() throws CannotUndoException {
            super.undo();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            LauncherUndo.this.launcher.open(this.prev);
            if (this.args[0] == null) {
                int n = LauncherUndo.this.edits.size() - 1;
                LauncherUndo.this.trimEdits(n, n);
            }
            LauncherUndo.this.launcher.refreshGUI();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        public void redo() throws CannotUndoException {
            super.redo();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = false;
            LauncherUndo.this.launcher.open(this.args);
            LauncherUndo.this.launcher.refreshGUI();
            ((LauncherUndo)LauncherUndo.this).launcher.postEdits = true;
        }

        public String getPresentationName() {
            return "Link";
        }
    }
}

