/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchSaver
extends JDialog {
    private String prevTabSetName;
    private String prevTabSetBasePath;
    private boolean prevTabSetSelfContained;
    private Map prevNodeNames = new HashMap();
    private Map prevNodeSelfContains = new HashMap();
    private LaunchBuilder builder;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private ArrayList treePaths = new ArrayList();
    private JTextField pathField;
    protected JCheckBox saveStateCheckBox;
    private JButton chooseButton;
    private JButton inspectButton;
    private Node root;
    private JScrollPane treeScroller;
    private boolean approved = false;
    private Editor editor = new Editor();
    private JDialog inspector;
    private boolean active;

    public LaunchSaver(LaunchBuilder launchBuilder) {
        super((Frame)launchBuilder.frame, true);
        this.createGUI();
        this.setBuilder(launchBuilder);
        if (FontSizer.getLevel() != 0) {
            FontSizer.setFonts(this.getContentPane(), FontSizer.getLevel());
        }
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(n, n2);
    }

    public void setBuilder(LaunchBuilder launchBuilder) {
        this.builder = launchBuilder;
        this.createTree();
        this.refresh();
        this.approved = false;
    }

    public void setSelectedNode(Node node) {
        if (node == null) {
            return;
        }
        this.tree.setSelectionPath(new TreePath(node.getPath()));
    }

    public Node getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (Node)treePath.getLastPathComponent();
    }

    public boolean isApproved() {
        return this.approved;
    }

    private void refresh() {
        this.inspectButton.setEnabled(this.getSelectedNode() != null);
        String string = null;
        string = !Launcher.tabSetBasePath.equals("") ? Launcher.tabSetBasePath : (this.builder.jarBasePath != null ? this.builder.jarBasePath : XML.forwardSlash(XML.getUserDirectory()));
        if (string.indexOf("javaws") > -1) {
            Launcher.tabSetBasePath = string = XML.forwardSlash(System.getProperty("user.home", "."));
        }
        this.pathField.setText(string + "/");
        this.pathField.setBackground(Color.white);
        this.treeModel.nodeChanged(this.root);
        this.tree.repaint();
    }

    private void inspectSelectedNode() {
        Object object;
        Node node = this.getSelectedNode();
        if (node == null) {
            node = this.root;
        }
        if ((object = node.node) == null) {
            LaunchBuilder launchBuilder = this.builder;
            launchBuilder.getClass();
            object = launchBuilder.new Launcher.LaunchSet(this.builder, this.builder.tabSetName);
        }
        XMLControlElement xMLControlElement = new XMLControlElement(object);
        XMLTreePanel xMLTreePanel = new XMLTreePanel(xMLControlElement, false);
        this.inspector.setContentPane(xMLTreePanel);
        String string = node != this.root ? node.node.getFileName() : this.builder.tabSetName;
        string = XML.getResolvedPath(string, Launcher.tabSetBasePath);
        this.inspector.setTitle(LaunchRes.getString("Inspector.Title.File") + " \"" + string + "\"");
        ((Component)this.inspector).setVisible(true);
    }

    private void revert() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Launcher.tabSetBasePath = this.prevTabSetBasePath;
        this.builder.tabSetName = this.prevTabSetName;
        this.builder.selfContained = this.prevTabSetSelfContained;
        for (int i = 0; i < this.builder.tabbedPane.getTabCount(); ++i) {
            defaultMutableTreeNode = this.builder.getTab(i).getRootNode();
            defaultMutableTreeNode.parentSelfContained = this.prevTabSetSelfContained;
        }
        Iterator iterator = this.prevNodeNames.keySet().iterator();
        while (iterator.hasNext()) {
            defaultMutableTreeNode = (Node)iterator.next();
            String string = (String)this.prevNodeNames.get(defaultMutableTreeNode);
            ((Node)defaultMutableTreeNode).node.setFileName(string);
            Boolean bl = (Boolean)this.prevNodeSelfContains.get(defaultMutableTreeNode);
            ((Node)defaultMutableTreeNode).node.setSelfContained(bl);
        }
    }

    private void setTabSetBasePath(String string) {
        string = XML.forwardSlash(string);
        boolean bl = false;
        while (string.startsWith("/")) {
            bl = true;
            string = string.substring(1);
        }
        if (bl) {
            string = "/" + string;
        }
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.startsWith("/") && string.indexOf(":") == -1) {
            String string2 = XML.forwardSlash(XML.getUserDirectory());
            if (this.builder.jarBasePath != null) {
                string2 = this.builder.jarBasePath;
            }
            if (!string.equals("")) {
                string2 = string2 + "/";
            }
            string = string2 + string;
        }
        Launcher.tabSetBasePath = string;
        this.refresh();
    }

    private String setTabSetName(String string) {
        String string2 = XML.getName(string);
        if (!"xset".equals(XML.getExtension(string2))) {
            while (string2.indexOf(".") > -1) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string2 = string2 + ".xset";
        }
        this.builder.tabSetName = string2;
        this.refresh();
        return string2;
    }

    private void createGUI() {
        this.inspector = new JDialog((Dialog)this, false);
        ((Component)this.inspector).setSize(new Dimension(600, 300));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.inspector.getBounds().width) / 2;
        int n2 = (dimension.height - this.inspector.getBounds().height) / 2;
        ((Component)this.inspector).setLocation(n, n2);
        this.setTitle(LaunchRes.getString("Saver.Title"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(600, 300));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4));
        jPanel.add((Component)jPanel2, "North");
        JLabel jLabel = new JLabel(LaunchRes.getString("Saver.Legend.New"), Launcher.greenFileIcon, 0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel2.add(jLabel);
        jLabel = new JLabel(LaunchRes.getString("Saver.Legend.Replace"), Launcher.yellowFileIcon, 0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel2.add(jLabel);
        jLabel = new JLabel(LaunchRes.getString("Saver.Legend.ReadOnly"), Launcher.redFileIcon, 0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel2.add(jLabel);
        jLabel = new JLabel(LaunchRes.getString("Saver.Legend.SelfContained"), Launcher.whiteFolderIcon, 0);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel2.add(jLabel);
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel3, "South");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jPanel3.add((Component)jToolBar, "North");
        jLabel = new JLabel(LaunchRes.getString("Saver.Label.Base"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        jToolBar.add(jLabel);
        this.pathField = new JTextField();
        this.pathField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LaunchSaver.this.setTabSetBasePath(LaunchSaver.this.pathField.getText());
                } else {
                    LaunchSaver.this.pathField.setBackground(Color.yellow);
                }
            }
        });
        this.pathField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                LaunchSaver.this.setTabSetBasePath(LaunchSaver.this.pathField.getText());
            }
        });
        jToolBar.add(this.pathField);
        this.chooseButton = new JButton(LaunchRes.getString("Saver.Button.Choose"));
        this.chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchSaver.this.chooseTabSet();
            }
        });
        this.inspectButton = new JButton(LaunchRes.getString("MenuItem.Inspect"));
        this.inspectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchSaver.this.inspectSelectedNode();
            }
        });
        this.saveStateCheckBox = new JCheckBox(LaunchRes.getString("Saver.Checkbox.SaveState"));
        this.saveStateCheckBox.setOpaque(false);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.add(Box.createHorizontalGlue());
        jToolBar2.add(Box.createHorizontalGlue());
        jToolBar2.add(Box.createHorizontalGlue());
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jToolBar2.add(jPanel4);
        jPanel4.add(this.saveStateCheckBox);
        jPanel4.add(this.inspectButton);
        jPanel4.add(this.chooseButton);
        jPanel3.add((Component)jToolBar2, "South");
        JButton jButton = new JButton(LaunchRes.getString("Saver.Button.Save"));
        jPanel4.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchSaver.this.approved = true;
                ((Component)LaunchSaver.this).setVisible(false);
            }
        });
        JButton jButton2 = new JButton(LaunchRes.getString("Saver.Button.Cancel"));
        jPanel4.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LaunchSaver.this.revert();
                ((Component)LaunchSaver.this).setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!LaunchSaver.this.isApproved()) {
                    LaunchSaver.this.revert();
                }
            }
        });
    }

    private void createTree() {
        TreePath treePath;
        Object object;
        int n;
        Object object2;
        Serializable serializable;
        this.active = false;
        this.treePaths.clear();
        this.prevNodeNames.clear();
        this.prevNodeSelfContains.clear();
        this.prevTabSetName = this.builder.tabSetName;
        this.prevTabSetBasePath = Launcher.tabSetBasePath;
        this.prevTabSetSelfContained = this.builder.selfContained;
        this.root = new Node();
        this.treePaths.add(new TreePath(this.root.getPath()));
        int n2 = this.builder.tabbedPane.getTabCount();
        for (int i = 0; i < n2; ++i) {
            serializable = new Node(this.builder.getTab(i).getRootNode());
            if (((Node)serializable).node.getFileName() != null) {
                this.root.add((MutableTreeNode)((Object)serializable));
                this.addChildren((Node)serializable);
                continue;
            }
            object2 = ((Node)serializable).node.getChildOwnedNodes();
            for (n = 0; n < ((LaunchNode[])object2).length; ++n) {
                object = new Node(object2[n]);
                this.root.add((MutableTreeNode)object);
                this.addChildren((Node)object);
            }
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new Renderer());
        this.tree.setCellEditor(this.editor);
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = LaunchSaver.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    LaunchSaver.this.editor.stopCellEditing();
                }
            }
        });
        this.tree.addTreeWillExpandListener(new ExpansionListener());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (LaunchSaver.this.inspector.isVisible()) {
                    LaunchSaver.this.inspectSelectedNode();
                }
            }
        });
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        serializable = this.editor.field.getFont();
        object2 = ((Font)serializable).getStringBounds("A", fontRenderContext);
        n = (int)((RectangularShape)object2).getHeight();
        this.tree.setRowHeight(n + 3);
        this.tree.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        if (this.treeScroller != null) {
            this.getContentPane().remove(this.treeScroller);
        }
        this.treeScroller = new JScrollPane(this.tree);
        this.getContentPane().add((Component)this.treeScroller, "Center");
        this.setSelectedNode(this.root);
        object = ((AbstractList)this.treePaths).listIterator();
        while (object.hasNext()) {
            treePath = (TreePath)object.next();
            this.tree.expandPath(treePath);
        }
        while (object.hasPrevious()) {
            treePath = (TreePath)object.previous();
            Node node = (Node)treePath.getLastPathComponent();
            if (!this.isFolder(node)) continue;
            this.tree.collapsePath(treePath);
        }
        this.active = true;
    }

    private void addChildren(Node node) {
        this.prevNodeNames.put(node, node.node.getFileName());
        this.prevNodeSelfContains.put(node, new Boolean(((Node)node).node.selfContained));
        this.treePaths.add(new TreePath(node.getPath()));
        LaunchNode[] launchNodeArray = node.node.getChildOwnedNodes();
        for (int i = 0; i < launchNodeArray.length; ++i) {
            Node node2 = new Node(launchNodeArray[i]);
            node.add(node2);
            this.addChildren(node2);
        }
    }

    private boolean isFolder(Node node) {
        if (node == this.root) {
            return this.builder.selfContained;
        }
        return ((Node)node).node.selfContained && !node.isLeaf();
    }

    private void chooseTabSet() {
        String string = XML.getResolvedPath(this.builder.tabSetName, Launcher.tabSetBasePath);
        JFileChooser jFileChooser = Launcher.getXMLChooser();
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setFileFilter(Launcher.xsetFileFilter);
        int n = jFileChooser.showDialog(this, LaunchRes.getString("Saver.FileChooser.Title"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            string = file.getAbsolutePath();
            this.setTabSetName(string);
            this.setTabSetBasePath(XML.getDirectoryPath(string));
        }
        this.refresh();
    }

    private Icon getIcon(Node node) {
        String string;
        Resource resource;
        File file = node == this.root ? ((resource = ResourceLoader.getResource(string = XML.getResolvedPath(this.builder.tabSetName, Launcher.tabSetBasePath))) == null ? null : resource.getFile()) : node.node.getFile();
        if (file == null) {
            if (this.isFolder(node)) {
                return Launcher.greenFolderIcon;
            }
            return Launcher.greenFileIcon;
        }
        if (file.canWrite()) {
            if (this.isFolder(node)) {
                return Launcher.yellowFolderIcon;
            }
            return Launcher.yellowFileIcon;
        }
        if (this.isFolder(node)) {
            return Launcher.redFolderIcon;
        }
        return Launcher.redFileIcon;
    }

    private class ExpansionListener
    implements TreeWillExpandListener {
        private ExpansionListener() {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            this.set(treePath, false);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            this.set(treePath, true);
        }

        private void set(TreePath treePath, boolean bl) {
            if (LaunchSaver.this.active) {
                Node node = (Node)treePath.getLastPathComponent();
                if (node == LaunchSaver.this.root) {
                    ((LaunchSaver)LaunchSaver.this).builder.selfContained = bl;
                    for (int i = 0; i < ((LaunchSaver)LaunchSaver.this).builder.tabbedPane.getTabCount(); ++i) {
                        LaunchNode launchNode = LaunchSaver.this.builder.getTab(i).getRootNode();
                        launchNode.parentSelfContained = bl;
                    }
                } else {
                    node.node.setSelfContained(bl);
                }
                if (LaunchSaver.this.inspector.isVisible()) {
                    LaunchSaver.this.inspectSelectedNode();
                }
            }
        }
    }

    private class Editor
    extends AbstractCellEditor
    implements TreeCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        JLabel label = new JLabel();

        Editor() {
            this.panel.add((Component)this.label, "West");
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
            this.field.setBorder(BorderFactory.createLineBorder(Color.black));
            this.field.setEditable(true);
            this.field.setColumns(30);
            this.field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Editor.this.stopCellEditing();
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        Editor.this.stopCellEditing();
                    } else {
                        Editor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    Editor.this.stopCellEditing();
                }
            });
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Node node = (Node)object;
            String string = node != LaunchSaver.this.root ? node.node.getFileName() : ((LaunchSaver)LaunchSaver.this).builder.tabSetName;
            this.field.setText(string);
            this.label.setIcon(LaunchSaver.this.getIcon(node));
            this.label.setText(node.toString());
            if (FontSizer.getLevel() != 0) {
                FontSizer.setFonts(this.panel, FontSizer.getLevel());
            }
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return eventObject instanceof MouseEvent;
        }

        public Object getCellEditorValue() {
            this.field.setBackground(Color.white);
            Node node = LaunchSaver.this.getSelectedNode();
            String string = this.field.getText();
            String string2 = node.node != null ? node.node.getFileName() : ((LaunchSaver)LaunchSaver.this).builder.tabSetName;
            if (LaunchSaver.this.builder.getOpenPaths().contains(string) && !string2.equals(string)) {
                JOptionPane.showMessageDialog(LaunchSaver.this, LaunchRes.getString("Dialog.DuplicateFileName.Message") + " \"" + string + "\"", LaunchRes.getString("Dialog.DuplicateFileName.Title"), 2);
                LaunchSaver.this.refresh();
                return null;
            }
            if (node.node != null) {
                node.node.setFileName(string);
            } else {
                string = LaunchSaver.this.setTabSetName(string);
            }
            return string;
        }
    }

    class Renderer
    implements TreeCellRenderer {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel();
        JTextField field = new JTextField();

        public Renderer() {
            this.panel.add((Component)this.label, "West");
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.field.setBorder(null);
            this.field.setBackground(this.field.getSelectionColor());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Node node = (Node)object;
            String string = node != LaunchSaver.this.root ? node.node.getFileName() : ((LaunchSaver)LaunchSaver.this).builder.tabSetName;
            this.field.setText(string);
            this.label.setIcon(LaunchSaver.this.getIcon(node));
            this.label.setText(node.toString());
            if (FontSizer.getLevel() != 0) {
                FontSizer.setFonts(this.panel, FontSizer.getLevel());
            }
            this.field.setOpaque(bl);
            return this.panel;
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        private LaunchNode node;

        Node() {
        }

        Node(LaunchNode launchNode) {
            this.node = launchNode;
        }

        public String toString() {
            if (this.node == null) {
                return LaunchRes.getString("Saver.Tree.TabSet") + ":";
            }
            if (this.node.isRoot()) {
                return LaunchRes.getString("Saver.Tree.Tab") + " \"" + this.node.name + "\":";
            }
            return LaunchRes.getString("Saver.Tree.Node") + " \"" + this.node.name + "\":";
        }
    }
}

