/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LauncherUndo;

public class LaunchPanel
extends JPanel {
    protected static final String TEXT_TYPE = "text";
    protected JTree tree;
    protected DefaultTreeModel treeModel;
    protected JSplitPane splitPane;
    protected JPanel dataPanel;
    protected JTabbedPane htmlTabs;
    protected JEditorPane descriptionPane;
    protected JScrollPane descriptionScroller;
    protected boolean showAllNodes;
    protected Map visibleNodeMap = new HashMap();
    protected Launcher launcher;

    public LaunchPanel(LaunchNode launchNode, Launcher launcher) {
        this.showAllNodes = launcher instanceof LaunchBuilder;
        this.launcher = launcher;
        this.createGUI();
        this.createTree(launchNode);
        this.setSelectedNode(launchNode);
    }

    public void setSelectedNode(LaunchNode launchNode) {
        if (launchNode == null) {
            return;
        }
        if (launchNode == this.getSelectedNode()) {
            this.displayHTML(launchNode);
        } else {
            this.tree.setSelectionPath(new TreePath(launchNode.getPath()));
        }
    }

    public void setSelectedNode(LaunchNode launchNode, int n) {
        this.setSelectedNode(launchNode, n, null);
    }

    public void setSelectedNode(LaunchNode launchNode, int n, URL uRL) {
        launchNode.htmlTabNumber = uRL == null && launchNode.getHTMLCount() == 0 ? -1 : n;
        launchNode.htmlURL = uRL;
        this.setSelectedNode(launchNode);
    }

    public LaunchNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (LaunchNode)treePath.getLastPathComponent();
    }

    public int getSelectedHTMLPage() {
        return this.htmlTabs.getSelectedIndex();
    }

    public LaunchNode getRootNode() {
        return (LaunchNode)this.treeModel.getRoot();
    }

    protected LaunchNode getClone(LaunchNode launchNode) {
        if (launchNode.getFileName() == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = this.getRootNode().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode2 = (LaunchNode)enumeration.nextElement();
            if (!launchNode.getFileName().equals(launchNode2.getFileName())) continue;
            return launchNode2;
        }
        return null;
    }

    protected void displayHTML(LaunchNode launchNode) {
        if (launchNode != null) {
            OSPLog.finer(LaunchRes.getString("Log.Message.NodeSelected") + " " + launchNode);
            boolean bl = this.launcher instanceof LaunchBuilder;
            String string = LaunchRes.getString("HTMLTab.Title.Untitled");
            URL uRL = launchNode.htmlURL;
            int n = launchNode.htmlTabNumber;
            if (uRL == null && launchNode.getHTMLCount() > 0) {
                n = Math.max(0, n);
                LaunchNode.HTML hTML = launchNode.getHTML(n);
                if (hTML.url != null) {
                    uRL = hTML.url;
                }
            }
            int n2 = 0;
            if (!bl) {
                this.htmlTabs.removeAll();
            }
            Iterator iterator = ((AbstractList)launchNode.htmlData).iterator();
            while (iterator.hasNext()) {
                final LaunchNode.HTML hTML = (LaunchNode.HTML)iterator.next();
                if (hTML.url == null) continue;
                try {
                    if (hTML.url.getContent() == null) continue;
                    final Launcher.HTMLPane hTMLPane = this.launcher.getHTMLTab(n2);
                    final URL uRL2 = n == n2 && uRL != null ? uRL : hTML.url;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            try {
                                hTMLPane.editorPane.setPage(uRL2);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (uRL2.getRef() != null) {
                                hTMLPane.editorPane.scrollToReference(uRL2.getRef());
                            }
                            LaunchPanel.this.launcher.setLinksEnabled(hTMLPane.editorPane, hTML.hyperlinksEnabled);
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        runnable.run();
                    } else {
                        SwingUtilities.invokeLater(runnable);
                    }
                    if (bl) continue;
                    String string2 = hTML.title == null ? string : hTML.title;
                    this.htmlTabs.addTab(string2, hTMLPane.scroller);
                    ++n2;
                }
                catch (IOException iOException) {
                    OSPLog.fine(LaunchRes.getString("Log.Message.BadURL") + " " + hTML.url);
                }
            }
            if (!bl) {
                if (uRL != null) {
                    if (this.htmlTabs.getTabCount() == 1 && this.htmlTabs.getTitleAt(0).equals(string)) {
                        this.splitPane.setRightComponent(this.htmlTabs.getComponentAt(0));
                    } else if (this.htmlTabs.getTabCount() > 0) {
                        this.splitPane.setRightComponent(this.htmlTabs);
                        if (this.htmlTabs.getTabCount() > n) {
                            this.htmlTabs.setSelectedIndex(n);
                        }
                    }
                } else {
                    this.descriptionPane.setText(launchNode.description);
                    this.splitPane.setRightComponent(this.descriptionScroller);
                }
            }
            this.launcher.refreshGUI();
        }
    }

    protected void createGUI() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.dataPanel = new JPanel(new BorderLayout());
        this.descriptionPane = new JTextPane();
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setContentType(TEXT_TYPE);
        this.descriptionScroller = new JScrollPane(this.descriptionPane);
        this.htmlTabs = new JTabbedPane(1);
        this.htmlTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LaunchNode launchNode = LaunchPanel.this.getSelectedNode();
                if (launchNode != null && launchNode == LaunchPanel.this.launcher.selectedNode) {
                    launchNode.prevTabNumber = launchNode.htmlTabNumber;
                    launchNode.prevURL = launchNode.htmlURL;
                    int n = Math.max(0, LaunchPanel.this.htmlTabs.getSelectedIndex());
                    int n2 = launchNode.htmlTabNumber = launchNode.htmlData.isEmpty() ? -1 : n;
                    if (launchNode.htmlTabNumber > -1) {
                        Launcher.HTMLPane hTMLPane = LaunchPanel.this.launcher.getHTMLTab(launchNode.htmlTabNumber);
                        launchNode.htmlURL = hTMLPane.editorPane.getPage();
                    }
                }
            }
        });
        this.htmlTabs.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                LaunchNode launchNode = LaunchPanel.this.getSelectedNode();
                if (launchNode != null && LaunchPanel.this.launcher.postEdits) {
                    String string = launchNode.getPathString();
                    Integer n = new Integer(launchNode.prevTabNumber);
                    Integer n2 = new Integer(launchNode.htmlTabNumber);
                    Object[] objectArray = new Object[]{null, string, n, launchNode.prevURL};
                    Object[] objectArray2 = new Object[]{null, string, n2, launchNode.htmlURL};
                    LauncherUndo launcherUndo = LaunchPanel.this.launcher.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.NavEdit navEdit = launcherUndo.new LauncherUndo.NavEdit(objectArray, objectArray2);
                    LaunchPanel.this.launcher.undoSupport.postEdit(navEdit);
                }
            }
        });
        this.splitPane.setRightComponent(this.dataPanel);
        this.splitPane.setDividerLocation(160);
    }

    protected void createTree(LaunchNode launchNode) {
        Serializable serializable;
        if (!this.showAllNodes) {
            serializable = new VisibleNode(launchNode);
            this.visibleNodeMap.put(launchNode, serializable);
            this.addVisibleNodes((VisibleNode)serializable);
        }
        this.treeModel = new LaunchTreeModel(launchNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setToolTipText("");
        this.tree.setRootVisible(!launchNode.hiddenWhenRoot);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath;
                LaunchNode launchNode = LaunchPanel.this.launcher.getSelectedNode();
                if (LaunchPanel.this.launcher.postEdits && (treePath = treeSelectionEvent.getOldLeadSelectionPath()) != null && launchNode != null) {
                    LaunchNode launchNode2 = (LaunchNode)treePath.getLastPathComponent();
                    if (!launchNode.htmlData.isEmpty()) {
                        int n = Math.max(0, launchNode.htmlTabNumber);
                        LaunchNode.HTML hTML = (LaunchNode.HTML)launchNode.htmlData.get(n);
                        launchNode.htmlURL = hTML.url;
                        launchNode.htmlTabNumber = n;
                    }
                    LauncherUndo launcherUndo = LaunchPanel.this.launcher.undoManager;
                    launcherUndo.getClass();
                    LauncherUndo.NavEdit navEdit = launcherUndo.new LauncherUndo.NavEdit(launchNode2, launchNode);
                    LaunchPanel.this.launcher.undoSupport.postEdit(navEdit);
                }
                LaunchPanel.this.displayHTML(launchNode);
            }
        });
        serializable = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent((Component)serializable);
    }

    protected Collection getExpandedNodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreePath treePath = new TreePath(this.getRootNode());
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
        while (enumeration != null && enumeration.hasMoreElements()) {
            TreePath treePath2 = enumeration.nextElement();
            LaunchNode launchNode = (LaunchNode)treePath2.getLastPathComponent();
            arrayList.add(launchNode.getPathString());
        }
        return arrayList;
    }

    protected void setExpandedNodes(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Enumeration<TreeNode> enumeration = this.getRootNode().breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
                if (!string.equals(launchNode.getPathString())) continue;
                TreePath treePath = new TreePath(launchNode.getPath());
                this.tree.expandPath(treePath);
            }
        }
    }

    private void addVisibleNodes(VisibleNode visibleNode) {
        int n = visibleNode.node.getChildCount();
        for (int i = 0; i < n; ++i) {
            LaunchNode launchNode = (LaunchNode)visibleNode.node.getChildAt(i);
            if (launchNode.isHiddenInLauncher()) continue;
            VisibleNode visibleNode2 = new VisibleNode(launchNode);
            this.visibleNodeMap.put(launchNode, visibleNode2);
            visibleNode.add(visibleNode2);
            this.addVisibleNodes(visibleNode2);
        }
    }

    private class VisibleNode
    extends DefaultMutableTreeNode {
        LaunchNode node;

        VisibleNode(LaunchNode launchNode) {
            this.node = launchNode;
        }
    }

    class LaunchTreeModel
    extends DefaultTreeModel {
        LaunchTreeModel(LaunchNode launchNode) {
            super(launchNode);
        }

        public Object getChild(Object object, int n) {
            VisibleNode visibleNode;
            if (LaunchPanel.this.showAllNodes) {
                return super.getChild(object, n);
            }
            VisibleNode visibleNode2 = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(object);
            if (visibleNode2 != null && (visibleNode = (VisibleNode)visibleNode2.getChildAt(n)) != null) {
                return visibleNode.node;
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getChildCount(object);
            }
            VisibleNode visibleNode = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(object);
            if (visibleNode != null) {
                return visibleNode.getChildCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (LaunchPanel.this.showAllNodes) {
                return super.getIndexOfChild(object, object2);
            }
            VisibleNode visibleNode = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(object);
            VisibleNode visibleNode2 = (VisibleNode)LaunchPanel.this.visibleNodeMap.get(object2);
            if (visibleNode != null && visibleNode2 != null) {
                return visibleNode.getIndex(visibleNode2);
            }
            return -1;
        }
    }
}

