/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchNode
extends DefaultMutableTreeNode {
    static final Level DEFAULT_LOG_LEVEL = ConsoleLevel.OUT_CONSOLE;
    Object launchObj;
    String classPath;
    String launchClassName;
    Class launchClass;
    String[] args = new String[]{""};
    boolean showLog = false;
    boolean clearLog = false;
    Level logLevel = DEFAULT_LOG_LEVEL;
    boolean singleVM = false;
    boolean singleVMOff = false;
    boolean hiddenWhenRoot = false;
    boolean buttonView = false;
    boolean singleton = false;
    boolean singleApp = false;
    boolean singleAppOff = false;
    boolean hiddenInLauncher = false;
    String name = "";
    String description = "";
    String tooltip = "";
    String xsetName = "";
    String author = "";
    String keywords = "";
    String level = "";
    String languages = "";
    String comment = "";
    ArrayList htmlData = new ArrayList();
    private String fileName;
    Collection processes = new HashSet();
    Collection frames = new HashSet();
    Collection actions = new HashSet();
    Map threads = new HashMap();
    int launchCount = 0;
    LaunchPanel launchPanel;
    boolean selfContained;
    boolean parentSelfContained;
    boolean previewing;
    boolean saveHiddenNodes;
    List jars = new ArrayList();
    int htmlTabNumber = -1;
    int prevTabNumber = -1;
    URL htmlURL;
    URL prevURL;
    static /* synthetic */ Class class$org$opensourcephysics$tools$LaunchNode;

    public LaunchNode(String string) {
        this.setUserObject(this);
        if (string != null) {
            this.name = string;
        }
    }

    public void threadRunning(boolean bl) {
        this.launchCount += bl ? 1 : -1;
        this.launchCount = Math.max(0, this.launchCount);
        if (this.launchPanel != null) {
            this.launchPanel.repaint();
        }
    }

    public void launch() {
        this.launch(null);
    }

    public void launch(LaunchPanel launchPanel) {
        Object object;
        if (!this.isLeaf()) {
            return;
        }
        this.launchPanel = launchPanel;
        OSPRuntime.launchingInSingleVM = this.isSingleVM();
        Launcher.singleAppMode = this.isSingleApp();
        Launcher.classPath = this.getClassPath();
        if (this.isShowLog() && this.isSingleVM()) {
            OSPLog.setLevel(this.getLogLevel());
            object = OSPLog.getOSPLog();
            if (this.isClearLog()) {
                ((OSPLog)object).clear();
            }
            ((OSPLog)object).setVisible(true);
        }
        this.setMinimumArgLength(1);
        object = this.args[0];
        if (this.getLaunchClass() != null) {
            if (((String)object).equals("this")) {
                Object object2 = this.getLaunchObject();
                if (object2 != null) {
                    XMLControlElement xMLControlElement = new XMLControlElement(object2);
                    this.args[0] = xMLControlElement.toXML();
                } else {
                    this.args[0] = "";
                }
            }
            if (this.args[0].equals("") && this.args.length == 1) {
                Launcher.launch(this.getLaunchClass(), null, this);
            } else {
                Launcher.launch(this.getLaunchClass(), this.args, this);
            }
        }
        this.args[0] = object;
    }

    public LaunchNode getOwner() {
        if (this.fileName != null) {
            return this;
        }
        if (this.getParent() != null) {
            return ((LaunchNode)this.getParent()).getOwner();
        }
        return null;
    }

    public LaunchNode[] getAllOwnedNodes() {
        ArrayList<LaunchNode> arrayList = new ArrayList<LaunchNode>();
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (launchNode.fileName == null || launchNode == this) continue;
            arrayList.add(launchNode);
        }
        return arrayList.toArray(new LaunchNode[0]);
    }

    public LaunchNode[] getChildOwnedNodes() {
        ArrayList<LaunchNode> arrayList = new ArrayList<LaunchNode>();
        LaunchNode[] launchNodeArray = this.getAllOwnedNodes();
        LaunchNode launchNode = this.getOwner();
        for (int i = 0; i < launchNodeArray.length; ++i) {
            LaunchNode launchNode2 = ((LaunchNode)launchNodeArray[i].getParent()).getOwner();
            if (launchNode2 != launchNode) continue;
            arrayList.add(launchNodeArray[i]);
        }
        return arrayList.toArray(new LaunchNode[0]);
    }

    public String toString() {
        if (this.name != null && !this.name.equals("")) {
            return this.name;
        }
        if (this.launchClassName != null) {
            return XML.getExtension(this.launchClassName);
        }
        if (!this.args[0].equals("")) {
            String string = this.args[0];
            string = XML.getName(string);
            return XML.stripExtension(string);
        }
        return "";
    }

    public String getID() {
        return String.valueOf(this.hashCode());
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setArgs(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            this.args = stringArray;
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        if (!this.author.equals("")) {
            return this.author;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getAuthor();
    }

    public void setKeyword(String string) {
        this.keywords = string;
    }

    public String getKeywords() {
        if (!this.keywords.equals("")) {
            return this.keywords;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getKeywords();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCourseLevel(String string) {
        this.level = string;
    }

    public String getCourseLevel() {
        if (!this.level.equals("")) {
            return this.level;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getCourseLevel();
    }

    public void setLanguages(String string) {
        this.languages = string;
    }

    public String getLanguages() {
        if (!this.languages.equals("")) {
            return this.languages;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getLanguages();
    }

    public String getClassPath() {
        String string = "";
        if (this.classPath != null) {
            string = string + this.classPath;
        }
        LaunchNode launchNode = this;
        while (!launchNode.isRoot()) {
            launchNode = (LaunchNode)launchNode.getParent();
            if (launchNode.classPath == null) continue;
            if (!string.equals("")) {
                string = string + ";";
            }
            string = string + launchNode.classPath;
        }
        if (!string.equals("")) {
            this.jars.clear();
            String string2 = string;
            int n = string.indexOf(";");
            if (n == -1) {
                n = string.indexOf(":");
            }
            if (n != -1) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string = "";
            }
            while (string2.length() > 0) {
                if (!this.jars.contains(string2)) {
                    this.jars.add(string2);
                }
                if ((n = string.indexOf(";")) == -1) {
                    n = string.indexOf(":");
                }
                if (n == -1) {
                    string2 = string.trim();
                    string = "";
                    continue;
                }
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            }
            Iterator iterator = this.jars.iterator();
            while (iterator.hasNext()) {
                if (!string.equals("")) {
                    string = string + ";";
                }
                string = string + iterator.next();
            }
        }
        if (OSPRuntime.getLaunchJarName() != null && string.indexOf(OSPRuntime.getLaunchJarName()) == -1) {
            if (!string.equals("")) {
                string = string + ";";
            }
            string = string + OSPRuntime.getLaunchJarName();
        }
        return string;
    }

    public void setClassPath(String string) {
        if (string == null || string.equals("")) {
            this.classPath = null;
            return;
        }
        while (string.startsWith(":") || string.startsWith(";")) {
            string = string.substring(1);
        }
        while (string.endsWith(":") || string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = string;
        int n = string.indexOf(";;");
        if (n == -1) {
            n = string.indexOf("::");
        }
        if (n == -1) {
            n = string.indexOf(":;");
        }
        if (n == -1) {
            n = string.indexOf(";:");
        }
        while (n > -1) {
            string2 = string = string.substring(0, n + 1) + string2.substring(n + 2);
            n = string.indexOf(";;");
            if (n == -1) {
                n = string.indexOf("::");
            }
            if (n == -1) {
                n = string.indexOf(":;");
            }
            if (n != -1) continue;
            n = string.indexOf(";:");
        }
        this.classPath = string;
    }

    public boolean setLaunchClass(String string) {
        if (string == null) {
            return false;
        }
        if (this.launchClassName == string && this.launchClass != null) {
            return false;
        }
        OSPLog.finest(LaunchRes.getString("Log.Message.SetLaunchClass") + " " + string);
        this.launchClassName = string;
        this.launchClass = LaunchClassChooser.getClass(this.getClassPath(), string);
        return this.launchClass != null;
    }

    public Class getLaunchClass() {
        if (this.launchClass == null && this.launchClassName != null && !this.launchClassName.equals("")) {
            this.setLaunchClass(this.launchClassName);
        }
        return this.launchClass;
    }

    public Object getLaunchObject() {
        if (this.launchObj != null) {
            return this.launchObj;
        }
        if (this.isRoot()) {
            return null;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getLaunchObject();
    }

    public void setLaunchObject(Object object) {
        this.launchObj = object;
    }

    public HTML addHTML(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return null;
        }
        HTML hTML = new HTML(string, string2);
        this.htmlData.add(hTML);
        OSPLog.finest("tab added: [\"" + string + "\", \"" + string2 + "\"]");
        return hTML;
    }

    public HTML insertHTML(int n, String string, String string2) {
        if (string2 == null || string2.equals("") || n >= this.htmlData.size()) {
            return null;
        }
        HTML hTML = new HTML(string, string2);
        this.htmlData.add(n, hTML);
        OSPLog.finest("tab inserted: [\"" + string + "\", \"" + string2 + "\"]");
        return hTML;
    }

    public HTML removeHTML(int n) {
        HTML hTML = this.getHTML(n);
        if (hTML != null) {
            ((AbstractCollection)this.htmlData).remove(hTML);
            OSPLog.finest("tab " + n + " removed: [\"" + hTML.title + "\", \"" + hTML.path + "\"]");
        }
        return hTML;
    }

    public HTML getHTML(int n) {
        if (n >= this.htmlData.size()) {
            return null;
        }
        return (HTML)this.htmlData.get(n);
    }

    public int getHTMLCount() {
        return this.htmlData.size();
    }

    public HTML setHTML(int n, String string, String string2) {
        if (n >= this.htmlData.size()) {
            return this.addHTML(string, string2);
        }
        if (string2 == null || string2.equals("")) {
            return this.removeHTML(n);
        }
        HTML hTML = (HTML)this.htmlData.get(n);
        hTML.title = string;
        hTML.setURL(string2);
        OSPLog.finest("tab " + n + " changed: [\"" + string + "\", \"" + string2 + "\"]");
        return hTML;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathString() {
        TreeNode[] treeNodeArray = this.getPath();
        LaunchNode launchNode = (LaunchNode)treeNodeArray[0];
        StringBuffer stringBuffer = new StringBuffer(launchNode.name);
        for (int i = 1; i < treeNodeArray.length; ++i) {
            launchNode = (LaunchNode)treeNodeArray[i];
            stringBuffer.append("/" + launchNode.name);
        }
        return stringBuffer.toString();
    }

    public String setFileName(String string) {
        this.fileName = string == null ? null : XML.getPathRelativeTo(string, Launcher.tabSetBasePath);
        return this.fileName;
    }

    public boolean isParentSelfContained() {
        if (this.parentSelfContained) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isSelfContained();
    }

    public boolean isSelfContained() {
        return this.selfContained || this.isParentSelfContained();
    }

    public boolean isPreviewing() {
        if (this.previewing) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isPreviewing();
    }

    public boolean isSavingHiddenNodes() {
        if (this.saveHiddenNodes) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isSavingHiddenNodes();
    }

    public void setSelfContained(boolean bl) {
        this.selfContained = bl;
    }

    public boolean isSingleVM() {
        if (this.singleVM || OSPRuntime.isWebStart()) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return this.singleVMOff ? false : launchNode.isSingleVM();
    }

    public void setSingleVM(boolean bl) {
        this.singleVM = bl;
    }

    public boolean isShowLog() {
        if (this.showLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isShowLog();
    }

    public void setShowLog(boolean bl) {
        this.showLog = bl;
    }

    public boolean isClearLog() {
        if (this.clearLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isClearLog();
    }

    public void setClearLog(boolean bl) {
        this.clearLog = bl;
    }

    public Level getLogLevel() {
        Level level;
        if (this.isRoot()) {
            return this.logLevel;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        if (launchNode.isShowLog() && (level = launchNode.getLogLevel()).intValue() < this.logLevel.intValue()) {
            return level;
        }
        return this.logLevel;
    }

    public void setLogLevel(Level level) {
        if (level != null) {
            this.logLevel = level;
        }
    }

    public boolean isSingleApp() {
        if (this.singleApp) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return this.singleAppOff ? false : launchNode.isSingleApp();
    }

    public void setSingleApp(boolean bl) {
        this.singleApp = bl;
    }

    public void setHiddenWhenRoot(boolean bl) {
        this.hiddenWhenRoot = bl;
    }

    public boolean isButtonView() {
        if (this.buttonView) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isButtonView();
    }

    public void setButtonView(boolean bl) {
        LaunchNode launchNode = (LaunchNode)this.getRoot();
        launchNode.buttonView = bl;
    }

    public boolean isSingleton() {
        if (this.singleton) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isSingleton();
    }

    public void setSingleton(boolean bl) {
        this.singleton = bl;
    }

    public boolean isHiddenInLauncher() {
        if (this.hiddenInLauncher) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isHiddenInLauncher();
    }

    public void setHiddenInLauncher(boolean bl) {
        this.hiddenInLauncher = bl;
    }

    public Resource getResource() {
        if (this.fileName == null) {
            return null;
        }
        String string = XML.getResolvedPath(this.fileName, Launcher.tabSetBasePath);
        return ResourceLoader.getResource(string);
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    public File getFile() {
        if (this.exists()) {
            return this.getResource().getFile();
        }
        return null;
    }

    public boolean matches(LaunchNode launchNode) {
        if (launchNode == null) {
            return false;
        }
        boolean bl = this.showLog == launchNode.showLog && this.clearLog == launchNode.clearLog && this.singleton == launchNode.singleton && this.singleVM == launchNode.singleVM && this.hiddenWhenRoot == launchNode.hiddenWhenRoot && this.name.equals(launchNode.name) && this.description.equals(launchNode.description) && this.args[0].equals(launchNode.args[0]) && (this.fileName == null && launchNode.fileName == null || this.fileName != null && this.fileName.equals(launchNode.fileName)) && (this.getLaunchClass() == null && launchNode.getLaunchClass() == null || this.getLaunchClass() != null && this.getLaunchClass().equals(launchNode.getLaunchClass())) && (this.classPath == null && launchNode.classPath == null || this.classPath != null && this.classPath.equals(launchNode.classPath));
        return bl;
    }

    public LaunchNode getChildNode(String string) {
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (!string.equals(launchNode.fileName)) continue;
            return launchNode;
        }
        return null;
    }

    public void addMenuItemsTo(JComponent jComponent) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem;
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (launchNode.isLeaf()) {
                jMenuItem = new JMenuItem(launchNode.toString());
                jComponent.add(jMenuItem);
                jMenuItem.setToolTipText(launchNode.tooltip);
                jMenuItem.setActionCommand(launchNode.getID());
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        LaunchNode launchNode = (LaunchNode)LaunchNode.this.getRoot();
                        Enumeration<TreeNode> enumeration = launchNode.postorderEnumeration();
                        while (enumeration.hasMoreElements()) {
                            LaunchNode launchNode2 = (LaunchNode)enumeration.nextElement();
                            if (!launchNode2.getID().equals(string)) continue;
                            launchNode2.launch();
                            break;
                        }
                    }
                });
                continue;
            }
            jMenuItem = new JMenu(launchNode.toString());
            jComponent.add(jMenuItem);
            launchNode.addMenuItemsTo(jMenuItem);
        }
    }

    public void addTerminateAction(Action action) {
        this.actions.add(action);
        ++this.launchCount;
    }

    public void removeTerminateAction(Action action) {
        this.actions.remove(action);
        this.launchCount = Math.max(0, --this.launchCount);
    }

    public void terminate(Action action) {
        if (this.actions.contains(action)) {
            this.removeTerminateAction(action);
            if (this.launchPanel != null) {
                this.launchPanel.repaint();
            }
        }
    }

    public void terminateAll() {
        Object object;
        Object object2;
        Object object3 = this.processes.iterator();
        while (object3.hasNext()) {
            object2 = (Process)object3.next();
            ((Process)object2).destroy();
        }
        object3 = this.frames.iterator();
        while (object3.hasNext()) {
            object2 = (Frame)object3.next();
            object = ((Window)object2).getWindowListeners();
            for (int i = 0; i < ((WindowListener[])object).length; ++i) {
                if (!(object[i] instanceof Launcher.FrameCloser)) continue;
                ((Window)object2).removeWindowListener(object[i]);
            }
            ((Window)object2).dispose();
        }
        object3 = this.threads.values().iterator();
        while (object3.hasNext()) {
            object2 = (Thread)object3.next();
            if (object2 == null) continue;
            ((Thread)object2).interrupt();
        }
        object3 = new HashSet(this.actions);
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (Action)object2.next();
            if (object == null) continue;
            object.actionPerformed(null);
        }
        this.processes.clear();
        this.frames.clear();
        this.threads.clear();
        this.actions.clear();
        this.launchCount = 0;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private String[][] getHTMLData() {
        if (this.htmlData.isEmpty()) {
            return null;
        }
        String[][] stringArray = new String[this.htmlData.size()][2];
        for (int i = 0; i < this.htmlData.size(); ++i) {
            HTML hTML = (HTML)this.htmlData.get(i);
            stringArray[i] = new String[]{hTML.title, hTML.path};
        }
        return stringArray;
    }

    private void setHTMLData(String[][] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.htmlData.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            HTML hTML = new HTML(stringArray[i][0], stringArray[i][1]);
            this.htmlData.add(hTML);
        }
    }

    protected void setMinimumArgLength(int n) {
        if ((n = Math.max(n, 1)) == this.args.length) {
            return;
        }
        if (n > this.args.length) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = i < this.args.length ? this.args[i] : "";
            }
            this.setArgs(stringArray);
        } else {
            while (this.args.length > n && this.args[this.args.length - 1].equals("")) {
                String[] stringArray = new String[this.args.length - 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.args[i];
                }
                this.setArgs(stringArray);
            }
        }
    }

    protected void removeThread(Runnable runnable) {
        this.threads.remove(runnable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class HTML {
        public String title;
        public boolean hyperlinksEnabled = true;
        String path;
        URL url;

        HTML(String string, String string2) {
            this.title = string;
            this.setURL(string2);
        }

        public URL getURL() {
            return this.url;
        }

        public String getPath() {
            return this.path;
        }

        public void setURL(String string) {
            this.path = string;
            Resource resource = ResourceLoader.getResource(string);
            if (resource != null && resource.getURL() != null) {
                this.url = resource.getURL();
                try {
                    InputStream inputStream = this.url.openStream();
                    inputStream.close();
                    OSPLog.finer(LaunchRes.getString("Log.Message.URL") + " " + this.url);
                }
                catch (Exception exception) {
                    this.url = null;
                }
            } else {
                this.url = null;
            }
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            LaunchNode launchNode = (LaunchNode)object;
            launchNode.setMinimumArgLength(1);
            if (!launchNode.name.equals("")) {
                xMLControl.setValue("name", launchNode.name);
            }
            if (!launchNode.description.equals("")) {
                xMLControl.setValue("description", launchNode.description);
            }
            if (!launchNode.tooltip.equals("")) {
                xMLControl.setValue("tooltip", launchNode.tooltip);
            }
            if (!launchNode.xsetName.equals("")) {
                xMLControl.setValue("launchset", launchNode.xsetName);
            }
            xMLControl.setValue("html", launchNode.getHTMLData());
            if (launchNode.getLaunchClass() != null) {
                xMLControl.setValue("launch_class", launchNode.getLaunchClass().getName());
            } else if (launchNode.launchClassName != null) {
                xMLControl.setValue("launch_class", launchNode.launchClassName);
            }
            if (!launchNode.args[0].equals("") || launchNode.args.length > 1) {
                xMLControl.setValue("launch_args", launchNode.args);
            }
            if (launchNode.classPath != null && !launchNode.classPath.equals("")) {
                xMLControl.setValue("classpath", launchNode.classPath);
            }
            if (launchNode.hiddenWhenRoot) {
                xMLControl.setValue("root_hidden", true);
            }
            if (launchNode.buttonView) {
                xMLControl.setValue("button_view", true);
            }
            if (launchNode.singleton) {
                xMLControl.setValue("singleton", true);
            }
            if (launchNode.singleVM) {
                xMLControl.setValue("single_vm", true);
            }
            if (launchNode.singleVMOff) {
                xMLControl.setValue("single_vm_off", true);
            }
            if (launchNode.showLog) {
                xMLControl.setValue("show_log", true);
            }
            if (launchNode.logLevel != DEFAULT_LOG_LEVEL) {
                xMLControl.setValue("log_level", launchNode.logLevel.getName());
            }
            if (launchNode.clearLog) {
                xMLControl.setValue("clear_log", true);
            }
            if (launchNode.singleApp) {
                xMLControl.setValue("single_app", true);
            }
            if (launchNode.singleAppOff) {
                xMLControl.setValue("single_app_off", true);
            }
            if (launchNode.hiddenInLauncher) {
                xMLControl.setValue("hidden_in_launcher", true);
            }
            if (!launchNode.author.equals("")) {
                xMLControl.setValue("author", launchNode.author);
            }
            if (!launchNode.keywords.equals("")) {
                xMLControl.setValue("keywords", launchNode.keywords);
            }
            if (!launchNode.level.equals("")) {
                xMLControl.setValue("level", launchNode.level);
            }
            if (!launchNode.languages.equals("")) {
                xMLControl.setValue("languages", launchNode.languages);
            }
            if (!launchNode.comment.equals("")) {
                xMLControl.setValue("comment", launchNode.comment);
            }
            if (launchNode.children != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Enumeration<TreeNode> enumeration = launchNode.children();
                boolean bl = launchNode.isSavingHiddenNodes();
                while (enumeration.hasMoreElements()) {
                    LaunchNode launchNode2 = (LaunchNode)enumeration.nextElement();
                    if (!bl && launchNode2.isHiddenInLauncher()) continue;
                    if (launchNode.isPreviewing()) {
                        arrayList.add(launchNode2);
                        continue;
                    }
                    if (launchNode2.fileName != null && !launchNode.isSelfContained()) {
                        arrayList.add(launchNode2.fileName);
                        continue;
                    }
                    launchNode2.fileName = null;
                    launchNode2.setSelfContained(false);
                    arrayList.add(launchNode2);
                }
                if (arrayList.size() > 0) {
                    xMLControl.setValue("child_nodes", arrayList);
                }
            }
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            if (string == null) {
                string = LaunchRes.getString("NewNode.Name");
            }
            return new LaunchNode(string);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ArrayList arrayList;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String[] stringArray;
            String string6;
            String string7;
            String string8;
            String string9;
            LaunchNode launchNode = (LaunchNode)object;
            String string10 = xMLControl.getString("name");
            if (string10 != null) {
                launchNode.name = string10;
            }
            if ((string9 = xMLControl.getString("description")) != null) {
                launchNode.description = string9;
            }
            if ((string8 = xMLControl.getString("tooltip")) != null) {
                launchNode.tooltip = string8;
            }
            if ((string7 = xMLControl.getString("launchset")) != null) {
                launchNode.xsetName = string7;
            }
            if ((string6 = xMLControl.getString("url")) != null) {
                launchNode.setHTMLData(new String[][]{{null, string6}});
            } else {
                launchNode.setHTMLData((String[][])xMLControl.getObject("html"));
            }
            launchNode.setClassPath(xMLControl.getString("classpath"));
            String string11 = xMLControl.getString("launch_class");
            if (string11 != null) {
                launchNode.launchClassName = string11;
            }
            if ((stringArray = (String[])xMLControl.getObject("launch_args")) != null) {
                launchNode.setArgs(stringArray);
            }
            launchNode.hiddenWhenRoot = xMLControl.getBoolean("root_hidden");
            launchNode.buttonView = xMLControl.getBoolean("button_view");
            launchNode.singleton = xMLControl.getBoolean("singleton");
            launchNode.singleVM = xMLControl.getBoolean("single_vm");
            launchNode.singleVMOff = xMLControl.getBoolean("single_vm_off");
            launchNode.showLog = xMLControl.getBoolean("show_log");
            launchNode.clearLog = xMLControl.getBoolean("clear_log");
            launchNode.singleApp = xMLControl.getBoolean("single_app");
            launchNode.singleAppOff = xMLControl.getBoolean("single_app_off");
            launchNode.hiddenInLauncher = xMLControl.getBoolean("hidden_in_launcher");
            Level level = OSPLog.parseLevel(xMLControl.getString("log_level"));
            if (level != null) {
                launchNode.logLevel = level;
            }
            if ((string5 = xMLControl.getString("author")) != null) {
                launchNode.author = string5;
            }
            if ((string4 = xMLControl.getString("keywords")) != null) {
                launchNode.keywords = string4;
            }
            if ((string3 = xMLControl.getString("level")) != null) {
                launchNode.level = string3;
            }
            if ((string2 = xMLControl.getString("languages")) != null) {
                launchNode.languages = string2;
            }
            if ((string = xMLControl.getString("comment")) != null) {
                launchNode.comment = string;
            }
            if ((string10 = xMLControl.getString("filename")) != null) {
                launchNode.setFileName(string10);
            }
            if ((arrayList = (ArrayList)xMLControl.getObject("child_nodes")) != null) {
                launchNode.removeAllChildren();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Class clazz;
                    LaunchNode launchNode2;
                    Object object2;
                    Object e = iterator.next();
                    if (e instanceof LaunchNode) {
                        object2 = (LaunchNode)e;
                        launchNode.add((MutableTreeNode)object2);
                        ((LaunchNode)object2).setLaunchClass(((LaunchNode)object2).launchClassName);
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    object2 = (String)e;
                    String string12 = XML.getResolvedPath((String)object2, Launcher.tabSetBasePath);
                    ResourceLoader.addSearchPath(Launcher.resourcesPath);
                    ResourceLoader.addSearchPath(Launcher.tabSetBasePath);
                    XMLControlElement xMLControlElement = new XMLControlElement();
                    String string13 = xMLControlElement.read(string12);
                    if (xMLControlElement.failedToRead()) {
                        JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.InvalidXML.Message") + " \"" + (String)object2 + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                    }
                    if ((launchNode2 = (LaunchNode)launchNode.getRoot()).getChildNode((String)object2) != null || ((String)object2).equals(launchNode2.fileName)) continue;
                    if (!(class$org$opensourcephysics$tools$LaunchNode == null ? LaunchNode.class$("org.opensourcephysics.tools.LaunchNode") : class$org$opensourcephysics$tools$LaunchNode).isAssignableFrom(clazz = xMLControlElement.getObjectClass())) continue;
                    LaunchNode launchNode3 = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                    launchNode3.setFileName((String)object2);
                    OSPLog.finest(LaunchRes.getString("Log.Message.Loading") + ": " + string13);
                    launchNode.add(launchNode3);
                    xMLControlElement.loadObject(launchNode3);
                }
            }
            return launchNode;
        }
    }
}

