/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class JobManager {
    Tool localTool;
    Map replies = new HashMap();
    Map objects = new HashMap();

    public JobManager(Tool tool) {
        this.localTool = tool;
    }

    public void log(Job job, Tool tool) {
        if (tool == null) {
            return;
        }
        HashSet<Tool> hashSet = (HashSet<Tool>)this.replies.get(job);
        if (hashSet == null) {
            hashSet = new HashSet<Tool>();
            this.replies.put(job, hashSet);
        }
        hashSet.add(tool);
    }

    public void associate(Job job, Object object) {
        if (object == null) {
            return;
        }
        HashSet<Object> hashSet = (HashSet<Object>)this.objects.get(job);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            this.objects.put(job, hashSet);
        }
        hashSet.add(object);
    }

    public Job[] getJobs(Object object) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Collection collection = (Collection)this.objects.get(k);
            if (collection == null) {
                return null;
            }
            if (!collection.contains(object)) continue;
            arrayList.add(k);
        }
        return arrayList.toArray(new Job[0]);
    }

    public Object[] getObjects(Job job) {
        Collection collection = (Collection)this.objects.get(job);
        if (collection == null) {
            return new Object[0];
        }
        return collection.toArray(new Object[0]);
    }

    public void sendReplies(Object object) {
        Job[] jobArray = this.getJobs(object);
        XMLControlElement xMLControlElement = new XMLControlElement(object);
        String string = xMLControlElement.toXML();
        for (int i = 0; i < jobArray.length; ++i) {
            try {
                jobArray[i].setXML(string);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.sendReplies(jobArray[i]);
        }
    }

    public void sendReplies(Job job) {
        Collection collection = (Collection)this.replies.get(job);
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                Tool tool = (Tool)iterator.next();
                tool.send(job, this.localTool);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }
}

