/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.CheckTreeManager;
import org.opensourcephysics.tools.CheckTreeSelectionModel;
import org.opensourcephysics.tools.JarTreeModel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class JarTreeDialog
extends JDialog {
    protected File rootFile;
    protected JarTreeModel jarModel;
    protected JTree jarTree;
    protected CheckTreeManager checkManager;
    protected TreePath[] selectionPaths;
    protected UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    protected JButton okButton;
    protected JButton undoButton;
    protected JButton redoButton;
    protected JButton languagesButton;
    protected boolean ignoreEvents;
    protected int prevRow;
    protected Icon jarIcon;
    protected Icon jarFileIcon;
    protected Icon jarFolderIcon;
    protected Icon fileIcon;

    public JarTreeDialog(Frame frame, File file) {
        super(frame, true);
        this.rootFile = file;
        this.createGUI();
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        CheckTreeSelectionModel checkTreeSelectionModel = this.checkManager.getSelectionModel();
        checkTreeSelectionModel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JarTreeDialog.this.ignoreEvents) {
                    return;
                }
                TreePath[] treePathArray = (TreePath[])propertyChangeEvent.getOldValue();
                TreePath[] treePathArray2 = (TreePath[])propertyChangeEvent.getNewValue();
                TreePath treePath = JarTreeDialog.this.jarTree.getSelectionPath();
                int n = JarTreeDialog.this.jarTree.getRowForPath(treePath);
                SelectionEdit selectionEdit = new SelectionEdit(treePathArray, JarTreeDialog.this.prevRow, treePathArray2, n);
                JarTreeDialog.this.undoSupport.postEdit(selectionEdit);
                JarTreeDialog.this.prevRow = n;
                JarTreeDialog.this.refresh();
            }
        });
        this.refresh();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(n, n2);
    }

    public String[] getSelectionRelativePaths() {
        if (this.selectionPaths == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.selectionPaths.length; ++i) {
            arrayList.add(this.getRelativePath(this.selectionPaths[i]));
        }
        return arrayList.toArray(new String[0]);
    }

    public void setSelectionRelativePaths(String[] stringArray) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(this.getTreePath(stringArray[i]));
        }
        TreePath[] treePathArray = arrayList.toArray(new TreePath[0]);
        this.setSelectionPaths(treePathArray);
    }

    public TreePath[] getSelectionPaths() {
        return this.selectionPaths;
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.ignoreEvents = true;
        CheckTreeSelectionModel checkTreeSelectionModel = this.checkManager.getSelectionModel();
        if (treePathArray == null) {
            checkTreeSelectionModel.setSelectionPaths(new TreePath[0]);
        } else {
            checkTreeSelectionModel.setSelectionPaths(treePathArray);
        }
        this.ignoreEvents = false;
        this.refresh();
    }

    private String getRelativePath(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.rootFile;
        for (int i = 1; i < objectArray.length; ++i) {
            if (stringBuffer.toString().endsWith(".jar")) {
                stringBuffer.append("!");
            }
            if (i > 1) {
                stringBuffer.append("/");
            }
            stringBuffer.append(objectArray[i].toString());
            object = this.jarModel.getChild(object, objectArray[i].toString());
        }
        if (object instanceof File && ((File)object).isDirectory() || object instanceof JarTreeModel.JarNode && !((JarTreeModel.JarNode)object).isLeaf()) {
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    private TreePath getTreePath(String string) {
        String string2 = XML.forwardSlash(string);
        TreePath treePath = new TreePath(this.rootFile);
        Object object = this.rootFile;
        while (object != null) {
            Object object2 = null;
            int n = string2.indexOf("/");
            if (n > -1) {
                String string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
                if (string3.endsWith("!")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                object2 = this.jarModel.getChild(object, string3);
            } else {
                object2 = this.jarModel.getChild(object, string2);
            }
            if (object2 != null) {
                treePath = treePath.pathByAddingChild(object2);
            }
            object = object2;
        }
        return treePath;
    }

    protected void refresh() {
        CheckTreeSelectionModel checkTreeSelectionModel = this.checkManager.getSelectionModel();
        this.selectionPaths = checkTreeSelectionModel.getSelectionPaths();
        this.okButton.setEnabled(!checkTreeSelectionModel.isSelectionEmpty());
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    protected void createGUI() {
        this.setTitle(ToolsRes.getString("JarTreeDialog.Title"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(480, 320));
        this.setContentPane(jPanel);
        String string = "/org/opensourcephysics/resources/tools/images/jarfile.gif";
        this.jarIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/jarcontent.gif";
        this.jarFileIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/jarfolder.gif";
        this.jarFolderIcon = ResourceLoader.getIcon(string);
        string = "/org/opensourcephysics/resources/tools/images/whitefile.gif";
        this.fileIcon = ResourceLoader.getIcon(string);
        this.jarModel = new JarTreeModel(this.rootFile);
        this.jarTree = new JTree(this.jarModel);
        this.jarTree.setSelectionRow(0);
        this.jarTree.setCellRenderer(new JarRenderer());
        this.checkManager = new CheckTreeManager(this.jarTree);
        JScrollPane jScrollPane = new JScrollPane(this.jarTree);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, ToolsRes.getString("JarTreeDialog.Border.Title"));
        jScrollPane.setBorder(titledBorder);
        jPanel.add((Component)jScrollPane, "Center");
        this.okButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)JarTreeDialog.this).setVisible(false);
            }
        });
        JButton jButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Cancel"));
        jButton.setForeground(new Color(0, 0, 102));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarTreeDialog.this.selectionPaths = null;
                ((Component)JarTreeDialog.this).setVisible(false);
            }
        });
        this.undoButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Undo"));
        this.undoButton.setForeground(new Color(0, 0, 102));
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarTreeDialog.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Redo"));
        this.redoButton.setForeground(new Color(0, 0, 102));
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarTreeDialog.this.undoManager.redo();
            }
        });
        this.languagesButton = new JButton(ToolsRes.getString("JarTreeDialog.Button.Languages"));
        this.languagesButton.setForeground(new Color(0, 0, 102));
        this.languagesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                String string;
                Object[] objectArray;
                TreePath[] treePathArray;
                Object object2;
                ListChooser listChooser = new ListChooser(ToolsRes.getString("JarTreeDialog.Chooser.Languages.Title"), ToolsRes.getString("JarTreeDialog.Chooser.Languages.Message"), JarTreeDialog.this);
                ArrayList<Locale> arrayList = new ArrayList<Locale>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<Locale> arrayList3 = new ArrayList<Locale>();
                Locale[] localeArray = OSPRuntime.getInstalledLocales();
                boolean[] blArray = new boolean[localeArray.length];
                boolean[] blArray2 = new boolean[localeArray.length];
                Object[] objectArray2 = new Object[]{JarTreeDialog.this.jarModel.getRoot()};
                Collection collection = JarTreeDialog.this.jarModel.getDescendantPaths(objectArray2);
                CheckTreeSelectionModel checkTreeSelectionModel = JarTreeDialog.this.checkManager.getSelectionModel();
                block0: for (int i = 0; i < localeArray.length; ++i) {
                    arrayList.add(localeArray[i]);
                    arrayList3.add(localeArray[i]);
                    arrayList2.add(localeArray[i].getDisplayLanguage(ToolsRes.locale));
                    object2 = localeArray[i].getLanguage();
                    if (localeArray[i] == Locale.ENGLISH) {
                        blArray[i] = true;
                        blArray2[i] = true;
                        continue;
                    }
                    treePathArray = collection.iterator();
                    while (treePathArray.hasNext()) {
                        objectArray = (Object[])treePathArray.next();
                        string = objectArray[objectArray.length - 1].toString();
                        if (string.indexOf(".properties") <= -1 || string.indexOf("display_res_" + (String)object2) <= -1 || ((TreePath)(object = new TreePath(objectArray))).toString().indexOf(OSPRuntime.getLaunchJarName()) <= -1) continue;
                        blArray[i] = checkTreeSelectionModel.isPathOrAncestorSelected((TreePath)object);
                        continue block0;
                    }
                }
                if (listChooser.choose(arrayList, arrayList2, blArray, blArray2)) {
                    ArrayList<TreePath> arrayList4 = new ArrayList<TreePath>();
                    object2 = new ArrayList();
                    treePathArray = ((AbstractList)arrayList3).iterator();
                    while (treePathArray.hasNext()) {
                        objectArray = (Object[])treePathArray.next();
                        string = objectArray.getLanguage();
                        object = collection.iterator();
                        while (object.hasNext()) {
                            TreePath treePath;
                            Object[] objectArray3 = (Object[])object.next();
                            String string2 = objectArray3[objectArray3.length - 1].toString();
                            if (string2.indexOf(".properties") <= -1 || string2.indexOf("_" + string) <= -1 || (treePath = new TreePath(objectArray3)).toString().indexOf(OSPRuntime.getLaunchJarName()) <= -1) continue;
                            if (!arrayList.contains(objectArray)) {
                                arrayList4.add(treePath);
                                continue;
                            }
                            object2.add(treePath);
                        }
                    }
                    treePathArray = arrayList4.toArray(new TreePath[0]);
                    JarTreeDialog.this.checkManager.getSelectionModel().removeSelectionPaths(treePathArray);
                    treePathArray = object2.toArray(new TreePath[0]);
                    JarTreeDialog.this.checkManager.getSelectionModel().addSelectionPaths(treePathArray);
                    JarTreeDialog.this.refresh();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add(this.languagesButton);
        jPanel2.add(this.undoButton);
        jPanel2.add(this.redoButton);
        jPanel2.add(jButton);
        jPanel2.add(this.okButton);
        this.pack();
    }

    protected class JarRenderer
    extends DefaultTreeCellRenderer {
        protected JarRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof File) {
                File file = (File)object;
                if (file.getName().endsWith(".jar")) {
                    this.setIcon(JarTreeDialog.this.jarIcon);
                } else if (bl3) {
                    this.setIcon(JarTreeDialog.this.fileIcon);
                }
            } else if (object instanceof JarTreeModel.JarNode) {
                this.setIcon(bl3 ? JarTreeDialog.this.jarFileIcon : JarTreeDialog.this.jarFolderIcon);
            }
            return this;
        }
    }

    protected class SelectionEdit
    extends AbstractUndoableEdit {
        TreePath[] undo;
        TreePath[] redo;
        int undoRow;
        int redoRow;

        public SelectionEdit(TreePath[] treePathArray, TreePath[] treePathArray2) {
            this.undo = treePathArray;
            this.redo = treePathArray2;
        }

        public SelectionEdit(TreePath[] treePathArray, int n, TreePath[] treePathArray2, int n2) {
            this.undo = treePathArray;
            this.redo = treePathArray2;
            this.undoRow = n;
            this.redoRow = n2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            JarTreeDialog.this.ignoreEvents = true;
            CheckTreeSelectionModel checkTreeSelectionModel = JarTreeDialog.this.checkManager.getSelectionModel();
            checkTreeSelectionModel.setSelectionPaths(this.undo);
            JarTreeDialog.this.jarTree.setSelectionRow(this.undoRow);
            JarTreeDialog.this.ignoreEvents = false;
            JarTreeDialog.this.refresh();
            JarTreeDialog.this.prevRow = this.undoRow;
        }

        public void redo() throws CannotUndoException {
            super.redo();
            JarTreeDialog.this.ignoreEvents = true;
            CheckTreeSelectionModel checkTreeSelectionModel = JarTreeDialog.this.checkManager.getSelectionModel();
            checkTreeSelectionModel.setSelectionPaths(this.redo);
            JarTreeDialog.this.jarTree.setSelectionRow(this.redoRow);
            JarTreeDialog.this.ignoreEvents = false;
            JarTreeDialog.this.refresh();
            JarTreeDialog.this.prevRow = this.redoRow;
        }

        public String getPresentationName() {
            return "Change Selection";
        }
    }
}

