/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

public class JarTool
implements Tool,
Runnable {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int YES_TO_ALL = 2;
    public static final int NO_TO_ALL = 3;
    private static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    private static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools");
    private static JarTool TOOL = new JarTool();
    private static JFileChooser chooser;
    private static int overwritePolicy;
    private static Frame ownerFrame;
    private static Map jarContents;
    private ArrayList instanceSources;
    private File instanceParent;
    private File instanceTarget;
    private Manifest instanceManifest;
    private OverwriteValue instancePolicy;
    private Frame instanceOwnerFrame;

    public static void setLocale(Locale locale) {
        res = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String string) {
        try {
            return res.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
    }

    public static JarTool getTool() {
        if (TOOL == null) {
            TOOL = new JarTool();
        }
        return TOOL;
    }

    private JarTool() {
        String string = "JarTool";
        chooser = OSPRuntime.createChooser("JAR, ZIP", new String[]{"zip", "jar"});
        Toolbox.addTool(string, this);
    }

    public void run() {
        JarTool.compressList(this.instanceSources, this.instanceParent, this.instanceTarget, this.instanceManifest, this.instancePolicy, this.instanceOwnerFrame);
    }

    private JarTool(ArrayList arrayList, File file, File file2, Manifest manifest, OverwriteValue overwriteValue, Frame frame) {
        this();
        this.instanceSources = arrayList;
        this.instanceParent = file;
        this.instanceTarget = file2;
        this.instanceManifest = manifest;
        this.instancePolicy = overwriteValue;
        this.instanceOwnerFrame = frame;
    }

    public void send(Job job, Tool tool) throws RemoteException {
    }

    public static void disableWarning() {
        JarTool.alwaysOverwrite();
    }

    public static void neverOverwrite() {
        overwritePolicy = 3;
    }

    public static void alwaysOverwrite() {
        overwritePolicy = 2;
    }

    public static void setOwnerFrame(Frame frame) {
        ownerFrame = frame;
    }

    public File create(ArrayList arrayList, File file, File file2, Manifest manifest) {
        OverwriteValue overwriteValue = new OverwriteValue(overwritePolicy);
        overwritePolicy = 1;
        if (arrayList.size() <= 0) {
            return null;
        }
        try {
            int n;
            boolean bl = true;
            if (file2 != null) {
                chooser.setCurrentDirectory(file2.getParentFile());
                chooser.setSelectedFile(file2);
            } else {
                chooser.setSelectedFile(new File("default.jar"));
            }
            String string = OSPRuntime.chooseFilename(chooser);
            if (string == null) {
                return null;
            }
            if (!string.toLowerCase().endsWith(".jar") && !string.toLowerCase().endsWith(".zip")) {
                string = string + ".jar";
            } else {
                bl = false;
            }
            file2 = new File(string);
            if (XML.forwardSlash(file2.getAbsolutePath()).equals(OSPRuntime.getLaunchJarPath())) {
                String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), res.getString("JarTool.FileIsForbidden") + " " + file2};
                JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
                return this.create(arrayList, file, file2, manifest);
            }
            if (bl && file2.exists() && (n = JOptionPane.showConfirmDialog(null, DisplayRes.getString("DrawingFrame.ReplaceExisting_message") + " " + file2.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                return null;
            }
            JarTool jarTool = new JarTool(arrayList, file, file2, manifest, overwriteValue, ownerFrame);
            Thread thread = new Thread(jarTool);
            thread.setPriority(5);
            thread.start();
            return file2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public File append(ArrayList arrayList, File file, String string) {
        OverwriteValue overwriteValue = new OverwriteValue(overwritePolicy);
        overwritePolicy = 1;
        if (arrayList.size() <= 0) {
            return null;
        }
        try {
            File file2 = new File(file, string);
            if (!file2.exists()) {
                String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), res.getString("JarTool.FileDoesntExist") + " " + string};
                JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
                return null;
            }
            if (!arrayList.contains(string)) {
                arrayList.add(0, string);
            }
            return JarTool.compressList(arrayList, file, file2, JarTool.getManifest(file2), overwriteValue, ownerFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Manifest createManifest(String string, String string2) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Manifest-Version: 1.0\n");
            stringBuffer.append("Built-By: Open Source Physics JarTool\n");
            if (string != null) {
                stringBuffer.append("Class-Path: " + string + "\n");
            }
            if (string2 != null) {
                stringBuffer.append("Main-Class: " + string2 + "\n");
            }
            stringBuffer.append("\n");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8"));
            return new Manifest(byteArrayInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Manifest getManifest(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            return jarFile.getManifest();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static File extract(File file, String string, String string2) {
        return JarTool.extract(file, string, new File(string2));
    }

    public static File extract(File file, String string, File file2) {
        if (!file.exists() || string == null || string.trim().length() < 1 || file2 == null) {
            return null;
        }
        boolean bl = string.lastIndexOf("/") == string.length() - 1;
        try {
            int n;
            Object object;
            Object object2;
            HashMap<String, Object> hashMap = (HashMap<String, Object>)jarContents.get(file.getPath());
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                jarContents.put(file.getPath(), hashMap);
                object2 = new ZipInputStream(new FileInputStream(file));
                object = null;
                while ((object = ((ZipInputStream)object2).getNextEntry()) != null) {
                    if (((ZipEntry)object).isDirectory()) continue;
                    hashMap.put(((ZipEntry)object).getName(), object);
                }
                ((ZipInputStream)object2).close();
            }
            if (bl) {
                object2 = hashMap.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (!((String)object).startsWith(string)) continue;
                    ZipEntry zipEntry = (ZipEntry)hashMap.get(object);
                    int n2 = string.length();
                    File file3 = new File(file2, zipEntry.getName().substring(n2));
                    JarTool.extract(file, (String)object, file3);
                }
                return file2;
            }
            object2 = (ZipEntry)hashMap.get(string);
            object = new ZipFile(file);
            InputStream inputStream = ((ZipFile)object).getInputStream((ZipEntry)object2);
            file2.getParentFile().mkdirs();
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            ((ZipFile)object).close();
            return file2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File extract(ClassLoader classLoader, String string, File file) {
        if (string == null || string.trim().length() <= 0 || file == null) {
            return null;
        }
        try {
            int n;
            URL uRL = classLoader.getResource(string);
            if (uRL == null) {
                return null;
            }
            file.getParentFile().mkdirs();
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File extract(String string, File file) {
        if (string == null || string.trim().length() <= 0 || file == null) {
            return null;
        }
        try {
            int n;
            InputStream inputStream = ResourceLoader.getResource(string, false).openInputStream();
            if (inputStream == null) {
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            file.getParentFile().mkdirs();
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean extract(Object object, AbstractList abstractList, File file) {
        if (abstractList.size() <= 0) {
            return true;
        }
        if (object != null && !(object instanceof File) && !(object instanceof ClassLoader)) {
            String[] stringArray = new String[]{res.getString("JarTool.FileNotExtracted"), res.getString("JarTool.SourceRequirement") + " null, java.io.File, java.lang.ClassLoader."};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            return false;
        }
        if (!file.exists() || !file.isDirectory()) {
            String[] stringArray = new String[]{res.getString("JarTool.FileNotExtracted"), res.getString("JarTool.FileDoesntExist") + " " + file.getName()};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            return false;
        }
        int n = 1;
        Iterator iterator = abstractList.iterator();
        block7: while (iterator.hasNext()) {
            String string = iterator.next().toString();
            File file2 = new File(file, string);
            if (file2.exists()) {
                switch (n) {
                    case 3: {
                        continue block7;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        n = JarTool.confirmOverwrite(string);
                        switch (n) {
                            case 1: 
                            case 3: {
                                continue block7;
                            }
                        }
                    }
                }
            }
            File file3 = null;
            if (object == null) {
                file3 = JarTool.extract(string, file2);
            } else if (object instanceof File) {
                file3 = JarTool.extract((File)object, string, file2);
            } else if (object instanceof ClassLoader) {
                file3 = JarTool.extract((ClassLoader)object, string, file2);
            }
            if (file3 != null) continue;
            String[] stringArray = new String[]{res.getString("JarTool.FileNotExtracted"), string + " " + res.getString("JarTool.FileNotExtractedFrom") + " " + object};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            return false;
        }
        return true;
    }

    public static boolean copy(File file, File file2) {
        try {
            int n;
            if (!file.exists()) {
                return false;
            }
            file2.getParentFile().mkdirs();
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean compress(File file, File file2, Manifest manifest) {
        try {
            Serializable serializable;
            if (!(file.exists() & file.isDirectory())) {
                return false;
            }
            if (file2.exists()) {
                file2.delete();
            }
            ZipOutputStream zipOutputStream = null;
            boolean bl = file2.getName().toLowerCase().endsWith(".jar");
            if (bl) {
                serializable = new File(file, "META-INF");
                JarTool.remove((File)serializable);
                zipOutputStream = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(file2), manifest) : new JarOutputStream(new FileOutputStream(file2));
            } else {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            }
            serializable = JarTool.getContents(file);
            String string = file.getAbsolutePath().replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            int n = string.length();
            byte[] byArray = new byte[1024];
            int n2 = ((ArrayList)serializable).size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                File file3 = (File)((ArrayList)serializable).get(i);
                FileInputStream fileInputStream = new FileInputStream(file3);
                String string2 = file3.getAbsolutePath().replace('\\', '/');
                if (string2.startsWith(string)) {
                    string2 = string2.substring(n);
                }
                if (bl) {
                    zipOutputStream.putNextEntry(new JarEntry(string2));
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                }
                while ((n3 = fileInputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n3);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean compress(ArrayList arrayList, File file, Manifest manifest) {
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return false;
            }
            if (file.exists()) {
                file.delete();
            }
            ZipOutputStream zipOutputStream = null;
            boolean bl = file.getName().toLowerCase().endsWith(".jar");
            zipOutputStream = bl ? (manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(file), manifest) : new JarOutputStream(new FileOutputStream(file))) : new ZipOutputStream(new FileOutputStream(file));
            String string = ((File)arrayList.get(0)).getParentFile().getAbsolutePath().replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            int n = string.length();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            Object object = ((AbstractList)arrayList).iterator();
            while (object.hasNext()) {
                File file2 = (File)object.next();
                if (bl && manifest != null && file2.getName().equals("META-INF")) continue;
                if (file2.isDirectory()) {
                    arrayList2.addAll(JarTool.getContents(file2));
                    continue;
                }
                arrayList2.add(file2);
            }
            object = new byte[1024];
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                File file3 = (File)arrayList2.get(i);
                FileInputStream fileInputStream = new FileInputStream(file3);
                String string2 = file3.getAbsolutePath().replace('\\', '/');
                if (string2.startsWith(string)) {
                    string2 = string2.substring(n);
                }
                if (bl) {
                    zipOutputStream.putNextEntry(new JarEntry(string2));
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                }
                while ((n3 = fileInputStream.read((byte[])object)) != -1) {
                    zipOutputStream.write((byte[])object, 0, n3);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean remove(File file) {
        if (file.exists() && file.isDirectory()) {
            return JarTool.recursiveClearDirectory(file, FileSystemView.getFileSystemView());
        }
        return false;
    }

    public static ArrayList getContents(File file) {
        if (file.exists() && file.isDirectory()) {
            return JarTool.recursiveGetDirectory(file, FileSystemView.getFileSystemView());
        }
        return new ArrayList();
    }

    public static boolean unzip(File file, File file2) {
        return JarTool.unzipWithWarning(file, file2, new OverwriteValue(2));
    }

    public static boolean unzipNoOverwrite(File file, File file2) {
        return JarTool.unzipWithWarning(file, file2, new OverwriteValue(3));
    }

    public static boolean unzipWithAWarning(File file, File file2) {
        return JarTool.unzipWithWarning(file, file2, new OverwriteValue(1));
    }

    private static int confirmOverwrite(String string) {
        final JDialog jDialog = new JDialog();
        final OverwriteValue overwriteValue = new OverwriteValue(1);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                String string = abstractButton.getActionCommand();
                if (string.equals("yes")) {
                    overwriteValue.value = 0;
                } else if (string.equals("no")) {
                    overwriteValue.value = 1;
                } else if (string.equals("yesToAll")) {
                    overwriteValue.value = 2;
                } else if (string.equals("noToAll")) {
                    overwriteValue.value = 3;
                }
                ((Component)jDialog).setVisible(false);
            }
        };
        JButton jButton = new JButton(res.getString("JarTool.Yes"));
        jButton.setActionCommand("yes");
        jButton.addMouseListener(mouseAdapter);
        JButton jButton2 = new JButton(res.getString("JarTool.No"));
        jButton2.setActionCommand("no");
        jButton2.addMouseListener(mouseAdapter);
        JButton jButton3 = new JButton(res.getString("JarTool.YesToAll"));
        jButton3.setActionCommand("yesToAll");
        jButton3.addMouseListener(mouseAdapter);
        JButton jButton4 = new JButton(res.getString("JarTool.NoToAll"));
        jButton4.setActionCommand("noToAll");
        jButton4.addMouseListener(mouseAdapter);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton3);
        jPanel.add(jButton2);
        jPanel.add(jButton4);
        JLabel jLabel = new JLabel(DisplayRes.getString("DrawingFrame.ReplaceExisting_message") + " " + string + DisplayRes.getString("DrawingFrame.QuestionMark"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jDialog.setTitle(DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"));
        jDialog.getContentPane().setLayout(new BorderLayout(5, 0));
        jDialog.getContentPane().add((Component)jLabel, "Center");
        jDialog.getContentPane().add((Component)jPanel, "South");
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                overwriteValue.value = 1;
            }
        });
        jDialog.validate();
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setModal(true);
        ((Component)jDialog).setVisible(true);
        return overwriteValue.value;
    }

    private static boolean unzipWithWarning(File file, File file2, OverwriteValue overwriteValue) {
        try {
            if (!file.exists()) {
                return false;
            }
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = null;
            byte[] byArray = new byte[1024];
            block9: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                File file3 = new File(file2, zipEntry.getName());
                if (file3.exists()) {
                    switch (overwriteValue.value) {
                        case 3: {
                            continue block9;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            overwriteValue.value = JarTool.confirmOverwrite(zipEntry.getName());
                            switch (overwriteValue.value) {
                                case 1: 
                                case 3: {
                                    continue block9;
                                }
                            }
                        }
                    }
                }
                file3.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                while ((n = zipInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private static File compressList(ArrayList arrayList, File file, File file2, Manifest manifest, OverwriteValue overwriteValue, Frame frame) {
        String string;
        File file3 = null;
        try {
            file3 = File.createTempFile("JarTool", ".tmp", file2.getParentFile());
            file3.delete();
        }
        catch (Exception exception) {
            file3 = null;
        }
        if (file3 == null || !file3.mkdirs()) {
            String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), res.getString("JarTool.CantCreateTemp")};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = arrayList.size();
        int n2 = 1;
        int n3 = 0;
        if (n > 10) {
            n2 = Math.round((float)n / 10.0f);
            n = 10;
        }
        ProgressDialog progressDialog = new ProgressDialog(frame, n + 2, "JarTool", new Dimension(350, 150));
        String string2 = res.getString("JarTool.ProcessingFile");
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            if (n3 % n2 == 0) {
                progressDialog.reportProgress(string2);
            }
            ++n3;
            string = iterator.next().toString();
            if (string == null) continue;
            stringBuffer.append(JarTool.processFile(string, new File(file, string), file3, overwriteValue));
        }
        boolean bl = false;
        string = stringBuffer.toString().trim();
        if (string.length() > 0) {
            String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), string};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
        } else {
            progressDialog.reportProgress(res.getString("JarTool.CompressingFile"));
            if (JarTool.compress(file3, file2, manifest)) {
                bl = true;
            } else {
                String[] stringArray = new String[]{res.getString("JarTool.JarNotCreated"), res.getString("JarTool.CantCompress") + " " + file2.getAbsolutePath()};
                JOptionPane.showMessageDialog(null, stringArray, res.getString("JarTool.Error"), 2);
            }
        }
        progressDialog.reportProgress(res.getString("JarTool.CleaningTempFile"));
        JarTool.remove(file3);
        progressDialog.dispose();
        if (bl) {
            return file2;
        }
        return null;
    }

    private static StringBuffer processFile(String string, File file, File file2, OverwriteValue overwriteValue) {
        if (!file.exists() && string.indexOf("!") == -1) {
            return new StringBuffer(res.getString("JarTool.FileDoesntExist") + " " + file.getAbsolutePath() + ".\n");
        }
        if (file.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer();
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(file, false);
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(JarTool.processFile(string + "/" + fileArray[i].getName(), fileArray[i], file2, overwriteValue));
            }
            return stringBuffer;
        }
        String string2 = file.getName().toLowerCase();
        if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
            if (JarTool.unzipWithWarning(file, file2, overwriteValue)) {
                return new StringBuffer();
            }
            return new StringBuffer(res.getString("JarTool.CantUncompress") + " " + file.getAbsolutePath() + ".\n");
        }
        int n = string.indexOf("!");
        if (n > -1) {
            File file3;
            String string3 = string.substring(n + 2);
            String string4 = file.getAbsolutePath();
            File file4 = new File(string4.substring(0, string4.indexOf("!")));
            if (JarTool.extract(file4, string3, file3 = new File(file2, string3)) != null) {
                return new StringBuffer();
            }
            return new StringBuffer(res.getString("JarTool.CantCopy") + " " + string + " --> " + file2.getName() + ".\n");
        }
        while (string.startsWith("../")) {
            string = string.substring(3);
        }
        File file5 = new File(file2, string);
        if (file5.exists()) {
            switch (overwriteValue.value) {
                case 3: {
                    return new StringBuffer();
                }
                case 2: {
                    break;
                }
                default: {
                    overwriteValue.value = JarTool.confirmOverwrite(string);
                    switch (overwriteValue.value) {
                        case 1: 
                        case 3: {
                            return new StringBuffer();
                        }
                    }
                }
            }
        }
        if (JarTool.copy(file, file5)) {
            return new StringBuffer();
        }
        return new StringBuffer(res.getString("JarTool.CantCopy") + " " + string + " --> " + file2.getName() + ".\n");
    }

    private static boolean recursiveClearDirectory(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!(fileArray[i].isDirectory() ? !JarTool.recursiveClearDirectory(fileArray[i], fileSystemView) : !fileArray[i].delete())) continue;
            return false;
        }
        return file.delete();
    }

    private static ArrayList recursiveGetDirectory(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList.addAll(JarTool.recursiveGetDirectory(fileArray[i], fileSystemView));
                continue;
            }
            arrayList.add(fileArray[i]);
        }
        return arrayList;
    }

    static {
        overwritePolicy = 1;
        ownerFrame = null;
        jarContents = new HashMap();
    }

    private static class ProgressDialog
    extends JDialog {
        private int totalSteps;
        private int currentStep = 0;
        private JLabel progressLabel = null;
        private JProgressBar progressBar = null;

        public ProgressDialog(Frame frame, int n, String string, Dimension dimension) {
            super(frame);
            this.totalSteps = n;
            this.setTitle(string);
            ((Component)this).setSize(dimension);
            this.setModal(false);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(){

                public Insets getInsets() {
                    return new Insets(15, 10, 5, 10);
                }
            };
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.getContentPane().add((Component)jPanel, "Center");
            Dimension dimension2 = new Dimension(dimension.width, 20);
            this.progressLabel = new JLabel(string);
            this.progressLabel.setAlignmentX(0.5f);
            this.progressLabel.setMaximumSize(dimension2);
            this.progressLabel.setPreferredSize(dimension2);
            jPanel.add(this.progressLabel);
            jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
            this.progressBar = new JProgressBar(0, this.totalSteps);
            this.progressBar.setStringPainted(true);
            this.progressLabel.setLabelFor(this.progressBar);
            this.progressBar.setAlignmentX(0.5f);
            jPanel.add(this.progressBar);
            Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((dimension3.width - dimension.width) / 2, (dimension3.height - dimension.width) / 2);
            this.getContentPane().add((Component)jPanel, "Center");
            this.setCursor(new Cursor(3));
            ((Component)this).setVisible(true);
        }

        public void reportProgress(String string) {
            ++this.currentStep;
            this.progressBar.setValue(this.currentStep);
            this.progressLabel.setText(string);
        }
    }

    private static class OverwriteValue {
        int value = 1;

        OverwriteValue(int n) {
            this.value = n;
        }
    }
}

