/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.opensourcephysics.analysis.FourierSinCosAnalysis;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DatasetTab;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class FourierTool
extends OSPFrame
implements Tool {
    protected static JFileChooser chooser;
    protected static OSPLog log;
    protected static Dimension dim;
    protected FourierSinCosAnalysis fft = new FourierSinCosAnalysis();
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControl control = new XMLControlElement();
    protected JobManager jobManager = new JobManager(this);
    protected JMenu addMenu;
    protected JMenu subtractMenu;
    protected JMenu multiplyMenu;
    protected JMenu divideMenu;
    JMenu fileMenu;
    JMenuItem openItem;
    JMenuItem closeItem;
    JMenuItem closeAllItem;
    JMenuItem printItem;
    JMenuItem exitItem;
    JMenu editMenu;
    JMenu copyMenu;
    JMenuItem copyImageItem;
    JMenuItem copyXMLItem;
    JMenuItem pasteItem;
    JMenu helpMenu;
    JMenuItem logItem;
    JMenuItem aboutItem;
    static final FourierTool FOURIER_TOOL;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;

    public static FourierTool getTool() {
        return FOURIER_TOOL;
    }

    public FourierTool() {
        super(ToolsRes.getString("Frame.Title"));
        String string = "FourierTool";
        this.setName(string);
        this.createGUI();
        Toolbox.addTool(string, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FourierTool.this.refreshGUI();
            }
        });
    }

    public FourierTool(String string) {
        this();
        this.open(string);
    }

    public FourierTool(Dataset dataset) {
        this();
        this.addTab(dataset);
    }

    public FourierTool(XMLControl xMLControl) {
        this();
        this.loadDatasets(xMLControl);
    }

    public String open(String string) {
        OSPLog.fine("opening " + string);
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        if (!this.loadDatasets(xMLControlElement).isEmpty()) {
            return string;
        }
        OSPLog.finest("no datasets found");
        return null;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == (class$java$lang$Object == null ? (class$java$lang$Object = FourierTool.class$("java.lang.Object")) : class$java$lang$Object)) {
            return;
        }
        this.jobManager.log(job, tool);
        Collection collection = this.loadDatasets(xMLControlElement);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.jobManager.associate(job, iterator.next());
        }
    }

    public void setUseChooser(boolean bl) {
        this.useChooser = bl;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    public Collection loadDatasets(XMLControl xMLControl) {
        return this.loadDatasets(xMLControl, this.useChooser);
    }

    public Collection loadDatasets(XMLControl xMLControl, boolean bl) {
        List list;
        Iterator iterator;
        HashSet<Dataset> hashSet = new HashSet<Dataset>();
        if (bl) {
            iterator = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), this);
            list = ((XMLTreeChooser)((Object)iterator)).choose(xMLControl, class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = FourierTool.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
        } else {
            iterator = new XMLTree(xMLControl);
            ((XMLTree)((Object)iterator)).setHighlightedClass(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = FourierTool.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
            ((XMLTree)((Object)iterator)).selectHighlightedProperties();
            list = ((XMLTree)((Object)iterator)).getSelectedProperties();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        if (!list.isEmpty()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                XMLControl xMLControl2 = (XMLControl)iterator.next();
                Dataset dataset = null;
                if (xMLControl2 instanceof XMLControlElement) {
                    XMLControlElement xMLControlElement = (XMLControlElement)xMLControl2;
                    dataset = (Dataset)xMLControlElement.loadObject(null, true, true);
                } else {
                    dataset = (Dataset)xMLControl2.loadObject(null);
                }
                this.addTab(dataset);
                hashSet.add(dataset);
            }
        }
        return hashSet;
    }

    public Collection getDatasets() {
        HashSet<Dataset> hashSet = new HashSet<Dataset>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            hashSet.add(datasetTab.getDataset());
        }
        return hashSet;
    }

    public Dataset getSelectedDataset() {
        DatasetTab datasetTab = this.getSelectedTab();
        if (datasetTab != null) {
            return datasetTab.getDataset();
        }
        return null;
    }

    Dataset createFourierDataset(Dataset dataset) {
        double[] dArray = dataset.getXPoints();
        double[] dArray2 = dataset.getYPoints();
        this.fft.doAnalysis(dArray, dArray2, 0);
        return this.fft.getDatasets()[0];
    }

    protected boolean addTab(Dataset dataset) {
        double[] dArray = dataset.getXPoints();
        double[] dArray2 = dataset.getYPoints();
        this.fft.doAnalysis(dArray, dArray2, 0);
        this.addFourierTab(this.fft.getDatasets()[0]);
        this.addFourierTab(this.fft.getDatasets()[1]);
        this.addFourierTab(this.fft.getDatasets()[2]);
        return true;
    }

    protected boolean addFourierTab(Dataset dataset) {
        int n = this.getTabIndex(dataset);
        if (n >= 0) {
            this.tabbedPane.setSelectedIndex(n);
            double[] dArray = dataset.getXPoints();
            double[] dArray2 = dataset.getYPoints();
            DatasetTab datasetTab = this.getSelectedTab();
            datasetTab.original.setName(dataset.getName());
            datasetTab.dataset.clear();
            datasetTab.dataset.append(dArray, dArray2);
            datasetTab.dataset.setName(dataset.getName());
            datasetTab.dataTable.tableChanged(null);
            datasetTab.refresh();
            this.refreshTabTitles();
            return false;
        }
        final DatasetTab datasetTab = new DatasetTab(dataset);
        datasetTab.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (!datasetTab.fitCheckBox.isSelected()) {
                    datasetTab.splitPanes[1].setDividerLocation(1.0);
                }
                if (!datasetTab.statsCheckBox.isSelected()) {
                    datasetTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        String string = dataset.getName() + " (" + dataset.getColumnName(0) + ", " + dataset.getColumnName(1) + ")";
        OSPLog.finer("adding tab " + string);
        this.tabbedPane.addTab(string, datasetTab);
        this.tabbedPane.setSelectedComponent(datasetTab);
        datasetTab.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                FourierTool.this.refreshTabTitles();
            }
        });
        this.validate();
        datasetTab.init();
        datasetTab.refresh();
        this.refreshTabTitles();
        return true;
    }

    protected DatasetTab getSelectedTab() {
        return (DatasetTab)this.tabbedPane.getSelectedComponent();
    }

    protected String open() {
        int n = OSPRuntime.getChooser().showOpenDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.open(string);
        }
        return null;
    }

    protected int getTabIndex(Dataset dataset) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            Dataset dataset2 = datasetTab.getDataset();
            if (dataset2 != dataset && dataset2.getID() != dataset.getID()) continue;
            return i;
        }
        return -1;
    }

    protected Dataset getDataset(int n) {
        if (n < 0 || n >= this.tabbedPane.getTabCount()) {
            return null;
        }
        DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(n);
        return datasetTab.getDataset();
    }

    public void updateData(Dataset dataset) {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Dataset dataset2 = ((DatasetTab)this.tabbedPane.getComponentAt(i)).getDataset();
            if (dataset2 != dataset) continue;
            ((DatasetTab)this.tabbedPane.getComponentAt(i)).updateData();
        }
    }

    protected void removeTab(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            this.refreshTabTitles();
        }
    }

    protected void removeAllButTab(int n) {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (i == n) continue;
            String string = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(i);
        }
        this.refreshTabTitles();
    }

    protected void removeAllTabs() {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            String string = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(i);
        }
    }

    protected void refreshTabTitles() {
        int n;
        String[] stringArray = new String[this.tabbedPane.getTabCount()];
        String[] stringArray2 = new String[this.tabbedPane.getTabCount()];
        boolean bl = true;
        for (n = 0; n < stringArray.length; ++n) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(n);
            HighlightableDataset highlightableDataset = datasetTab.displayData;
            stringArray[n] = "(" + highlightableDataset.getColumnName(0) + ", " + highlightableDataset.getColumnName(1) + ")";
            stringArray2[n] = highlightableDataset.getName();
            if (stringArray2[n] == null || stringArray2[n].equals("")) {
                stringArray2[n] = ToolsRes.getString("Dataset.Name.Default");
            }
            bl = bl && stringArray2[n].equals(stringArray2[0]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (bl && stringArray2[n] == ToolsRes.getString("Dataset.Name.Default")) continue;
            stringArray[n] = stringArray2[n] + " " + stringArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.tabbedPane.setTitleAt(n, stringArray[n]);
        }
    }

    protected void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DatasetTab datasetTab = FourierTool.this.getSelectedTab();
                if (datasetTab == null) {
                    return;
                }
                if (!datasetTab.fitCheckBox.isSelected()) {
                    datasetTab.splitPanes[1].setDividerLocation(1.0);
                }
                if (!datasetTab.statsCheckBox.isSelected()) {
                    datasetTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    Object object;
                    final int n = FourierTool.this.tabbedPane.getSelectedIndex();
                    DatasetTab datasetTab = (DatasetTab)FourierTool.this.tabbedPane.getComponentAt(n);
                    final HighlightableDataset highlightableDataset = datasetTab.displayData;
                    final String string = highlightableDataset.getColumnName(0) + ", " + highlightableDataset.getColumnName(1);
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            FourierTool.this.removeTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            FourierTool.this.removeAllButTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            FourierTool.this.removeAllTabs();
                        }
                    });
                    ArrayList<String> arrayList = new ArrayList<String>();
                    final String string2 = ToolsRes.getString("Dataset.Name.Default");
                    for (int i = 0; i < FourierTool.this.tabbedPane.getTabCount(); ++i) {
                        if (i == n) continue;
                        datasetTab = (DatasetTab)FourierTool.this.tabbedPane.getComponentAt(i);
                        object = datasetTab.displayData;
                        if (!((Dataset)object).getColumnName(0).equals(highlightableDataset.getColumnName(0))) continue;
                        arrayList.add(String.valueOf(i));
                    }
                    if (!arrayList.isEmpty()) {
                        AbstractAction abstractAction = new AbstractAction(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                int n = Integer.parseInt(actionEvent.getActionCommand());
                                DatasetTab datasetTab = (DatasetTab)(this).FourierTool.this.tabbedPane.getComponentAt(n);
                                HighlightableDataset highlightableDataset2 = datasetTab.displayData;
                                String string9 = highlightableDataset.getName();
                                String string22 = highlightableDataset2.getName();
                                String string3 = highlightableDataset.getColumnName(1);
                                String string4 = highlightableDataset2.getColumnName(1);
                                if (string9 == null || string9.equals("")) {
                                    string9 = string2;
                                }
                                if (string22 == null || string22.equals("")) {
                                    string22 = string2;
                                }
                                if (string9.indexOf(" - ") > -1 || string9.indexOf(" + ") > -1 || string9.indexOf(" * ") > -1 || string9.indexOf(" / ") > -1) {
                                    string9 = "(" + string9 + ")";
                                }
                                if (string3.indexOf("-") > -1 || string3.indexOf("+") > -1 || string3.indexOf("*") > -1 || string3.indexOf("/") > -1) {
                                    string3 = "(" + string3 + ")";
                                }
                                if (string22.indexOf(" - ") > -1 || string22.indexOf(" + ") > -1 || string22.indexOf(" * ") > -1 || string22.indexOf(" / ") > -1) {
                                    string22 = "(" + string22 + ")";
                                }
                                if (string4.indexOf("-") > -1 || string4.indexOf("+") > -1 || string4.indexOf("*") > -1 || string4.indexOf("/") > -1) {
                                    string4 = "(" + string4 + ")";
                                }
                                String string5 = "";
                                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                                if (jMenuItem.getParent() == (this).FourierTool.this.addMenu.getPopupMenu()) {
                                    string5 = "+";
                                }
                                if (jMenuItem.getParent() == (this).FourierTool.this.subtractMenu.getPopupMenu()) {
                                    string5 = "-";
                                } else if (jMenuItem.getParent() == (this).FourierTool.this.multiplyMenu.getPopupMenu()) {
                                    string5 = "*";
                                } else if (jMenuItem.getParent() == (this).FourierTool.this.divideMenu.getPopupMenu()) {
                                    string5 = "/";
                                }
                                String string6 = string9;
                                if (!string9.equals(string22)) {
                                    string6 = string6 + " " + string5 + " " + string22;
                                }
                                String string7 = string3 + string5 + string4;
                                for (int i = 0; i < (this).FourierTool.this.tabbedPane.getTabCount(); ++i) {
                                    datasetTab = (DatasetTab)(this).FourierTool.this.tabbedPane.getComponentAt(i);
                                    if (!string6.equals(datasetTab.dataset.getName()) || !string.equals(datasetTab.dataset.getColumnName(0) + ", " + string7)) continue;
                                    (this).FourierTool.this.tabbedPane.setSelectedIndex(i);
                                    (this).FourierTool.this.getSelectedTab().dataTable.tableChanged(null);
                                    FourierTool.this.getSelectedTab().refresh();
                                    FourierTool.this.refreshTabTitles();
                                    return;
                                }
                                double[] dArray = highlightableDataset.getXPoints();
                                double[] dArray2 = highlightableDataset.getYPoints();
                                double[] dArray3 = highlightableDataset2.getXPoints();
                                double[] dArray4 = highlightableDataset2.getYPoints();
                                int n2 = Math.min(dArray2.length, dArray4.length);
                                Dataset dataset = new Dataset();
                                for (int i = 0; i < n2; ++i) {
                                    if (dArray[i] != dArray3[i]) continue;
                                    if (string5.equals("+")) {
                                        dataset.append(dArray[i], dArray2[i] + dArray4[i]);
                                        continue;
                                    }
                                    if (string5.equals("-")) {
                                        dataset.append(dArray[i], dArray2[i] - dArray4[i]);
                                        continue;
                                    }
                                    if (string5.equals("*")) {
                                        dataset.append(dArray[i], dArray2[i] * dArray4[i]);
                                        continue;
                                    }
                                    if (!string5.equals("/")) continue;
                                    dataset.append(dArray[i], dArray2[i] / dArray4[i]);
                                }
                                if (dataset.getRowCount() > 0) {
                                    if (!string6.equals(string2)) {
                                        dataset.setName(string6);
                                    }
                                    dataset.setXYColumnNames(highlightableDataset.getColumnName(0), string3 + string5 + string4);
                                    dataset.setMarkerShape(highlightableDataset.getMarkerShape());
                                    dataset.setMarkerSize(highlightableDataset.getMarkerSize());
                                    dataset.setConnected(highlightableDataset.isConnected());
                                    dataset.setLineColor(highlightableDataset.getLineColor());
                                    dataset.setMarkerColor(highlightableDataset.getFillColor(), highlightableDataset.getEdgeColor());
                                    FourierTool.this.addTab(dataset);
                                } else {
                                    String string8 = ToolsRes.getString("Dialog.AddFailed.Title");
                                    if (jMenuItem.getParent() == (this).FourierTool.this.subtractMenu.getPopupMenu()) {
                                        string8 = ToolsRes.getString("Dialog.SubtractFailed.Title");
                                    } else if (jMenuItem.getParent() == (this).FourierTool.this.divideMenu.getPopupMenu()) {
                                        string8 = ToolsRes.getString("Dialog.DivideFailed.Title");
                                    }
                                    JOptionPane.showMessageDialog((this).FourierTool.this.tabbedPane, ToolsRes.getString("Dialog.OperationFailed.Message"), string8, 2);
                                }
                            }
                        };
                        FourierTool.this.addMenu = new JMenu(ToolsRes.getString("Menu.Add"));
                        FourierTool.this.subtractMenu = new JMenu(ToolsRes.getString("Menu.Subtract"));
                        FourierTool.this.multiplyMenu = new JMenu(ToolsRes.getString("Menu.MultiplyBy"));
                        FourierTool.this.divideMenu = new JMenu(ToolsRes.getString("Menu.DivideBy"));
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(FourierTool.this.addMenu);
                        jPopupMenu.add(FourierTool.this.subtractMenu);
                        jPopupMenu.add(FourierTool.this.multiplyMenu);
                        jPopupMenu.add(FourierTool.this.divideMenu);
                        object = ((AbstractList)arrayList).iterator();
                        while (object.hasNext()) {
                            String string3 = (String)object.next();
                            int n2 = Integer.parseInt(string3);
                            jMenuItem = new JMenuItem(FourierTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string3);
                            jMenuItem.addActionListener(abstractAction);
                            FourierTool.this.addMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem(FourierTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string3);
                            jMenuItem.addActionListener(abstractAction);
                            FourierTool.this.subtractMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem(FourierTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string3);
                            jMenuItem.addActionListener(abstractAction);
                            FourierTool.this.multiplyMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem(FourierTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string3);
                            jMenuItem.addActionListener(abstractAction);
                            FourierTool.this.divideMenu.add(jMenuItem);
                        }
                    }
                    jPopupMenu.show(FourierTool.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        jMenuBar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FourierTool.this.open();
            }
        });
        this.fileMenu.add(this.openItem);
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FourierTool.this.tabbedPane.getSelectedIndex();
                FourierTool.this.removeTab(n);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FourierTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().printImage(FourierTool.this);
            }
        });
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FourierTool.this.removeAllTabs();
                System.exit(0);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        this.editMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!FourierTool.this.editMenu.isPopupMenuVisible()) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        FourierTool.this.control.readXML((String)transferable.getTransferData(DataFlavor.stringFlavor));
                        FourierTool.this.pasteItem.setEnabled(!FourierTool.this.control.failedToRead());
                    }
                    catch (Exception exception) {
                        FourierTool.this.pasteItem.setEnabled(false);
                    }
                } else {
                    FourierTool.this.pasteItem.setEnabled(false);
                }
            }
        });
        jMenuBar.add(this.editMenu);
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().copyImage(FourierTool.this);
            }
        });
        this.copyImageItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        this.copyMenu.add(this.copyImageItem);
        this.copyXMLItem = new JMenuItem();
        this.copyXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dataset dataset = FourierTool.this.getSelectedDataset();
                if (dataset == null) {
                    return;
                }
                int n = FourierTool.this.tabbedPane.getSelectedIndex();
                String string = FourierTool.this.tabbedPane.getTitleAt(n);
                OSPLog.finest("copying " + string);
                XMLControlElement xMLControlElement = new XMLControlElement(dataset);
                StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        this.copyMenu.add(this.copyXMLItem);
        this.pasteItem = new JMenuItem();
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string != null) {
                        XMLControlElement xMLControlElement = new XMLControlElement();
                        xMLControlElement.readXML(string);
                        if (!xMLControlElement.failedToRead()) {
                            OSPLog.finest("pasting");
                        }
                        if (FourierTool.this.loadDatasets(xMLControlElement).isEmpty()) {
                            OSPLog.finest("no datasets found");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, n));
        this.editMenu.add(this.pasteItem);
        this.helpMenu = new JMenu();
        jMenuBar.add(this.helpMenu);
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FourierTool.log.getLocation().x == 0 && FourierTool.log.getLocation().y == 0) {
                    Point point = FourierTool.this.getLocation();
                    ((Component)log).setLocation(point.x + 28, point.y + 28);
                }
                log.setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FourierTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(jMenuBar);
        this.refreshGUI();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension.width - this.getBounds().width) / 2;
        int n3 = (dimension.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(n2, n3);
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("Frame.Title"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.printItem.setText(ToolsRes.getString("DatasetTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.copyMenu.setText(ToolsRes.getString("DatasetTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DatasetTool.MenuItem.CopyImage"));
        this.copyXMLItem.setText(ToolsRes.getString("DatasetTool.MenuItem.CopyXML"));
        this.pasteItem.setText(ToolsRes.getString("MenuItem.Paste"));
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            datasetTab.refreshGUI();
        }
    }

    protected void showAboutDialog() {
        String string = this.getName() + " 1.0  Jan 2006\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, string, ToolsRes.getString("Dialog.About.Title") + " " + this.getName(), 1);
    }

    public static void main(String[] stringArray) {
        FourierTool fourierTool = FourierTool.getTool();
        fourierTool.setVisible(true);
    }

    static {
        log = OSPLog.getOSPLog();
        dim = new Dimension(720, 500);
        FOURIER_TOOL = new FourierTool();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

