/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;

public class ExportGnuplotFormat
implements ExportFormat {
    public String description() {
        return "Text";
    }

    public String extension() {
        return "txt";
    }

    void exportDataset(PrintWriter printWriter, Dataset dataset, int n) throws IOException {
        double[] dArray = dataset.getXPoints();
        double[] dArray2 = dataset.getYPoints();
        printWriter.print("\n# name: data" + n + "\n" + "# type: matrix\n" + "# rows: " + dArray.length + "\n" + "# columns: " + 2 + "\n");
        for (int i = 0; i < dArray.length; ++i) {
            printWriter.println(dArray[i] + " " + dArray2[i]);
        }
    }

    void exportGridData(PrintWriter printWriter, GridData gridData, int n) throws IOException {
        int n2;
        int n3 = gridData.getNx();
        int n4 = gridData.getNy();
        double d = gridData.getLeft();
        double d2 = gridData.getDx();
        printWriter.println("\n# name: col_range" + n + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + n3);
        for (int i = 0; i < n3; ++i) {
            printWriter.print(d + (double)i * d2 + " ");
        }
        printWriter.println("\n");
        double d3 = gridData.getTop();
        double d4 = gridData.getDy();
        printWriter.println("# name: row_range" + n + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + n4);
        for (n2 = 0; n2 < n4; ++n2) {
            printWriter.print(d3 + (double)n2 * d4 + " ");
        }
        printWriter.println("\n");
        n2 = gridData.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            String string = gridData.getComponentName(i);
            printWriter.println("# name: grid_" + n + '_' + string + '\n' + "# type: matrix\n" + "# rows: " + n4 + '\n' + "# columns: " + n3);
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n3; ++k) {
                    printWriter.print(gridData.getValue(k, j, i) + " ");
                }
                printWriter.println();
            }
        }
    }

    public void export(File file, List list) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("# Created by the Open Source Physics library");
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Dataset) {
                    this.exportDataset(printWriter, (Dataset)e, n);
                } else if (e instanceof GridData) {
                    this.exportGridData(printWriter, (GridData)e, n);
                }
                ++n;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "An error occurred while saving your file. Please try again.", "Error", 0);
        }
    }
}

