/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.DatasetDataTable;
import org.opensourcephysics.tools.DatasetStatisticsTable;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetTab
extends JPanel {
    protected final Dataset original;
    protected HighlightableDataset dataset = new HighlightableDataset();
    protected HighlightableDataset displayData = new HighlightableDataset();
    protected JSplitPane[] splitPanes;
    protected Plot plot;
    protected DatasetDataTable dataTable;
    protected DatasetStatisticsTable statsTable;
    protected DatasetCurveFitter curveFitter;
    protected String[] shapeNames;
    protected int[] shapeNumbers;
    protected JSpinner shapeSpinner;
    protected JSpinner sizeSpinner;
    protected JCheckBox markerCheckBox;
    protected JCheckBox lineCheckBox;
    protected JCheckBox fitCheckBox;
    protected JCheckBox statsCheckBox;
    protected JButton markerColorButton;
    protected JButton lineColorButton;
    protected JButton fitColorButton;
    protected int buttonHeight = 28;
    protected SelectionBox selectionBox = new SelectionBox();
    protected Point zoomPoint;
    static /* synthetic */ Class class$org$opensourcephysics$display$Dataset;
    static /* synthetic */ Class class$org$opensourcephysics$display$FunctionDrawer;

    public DatasetTab(Dataset dataset) {
        this.original = dataset;
        XMLControlElement xMLControlElement = new XMLControlElement(this.original);
        xMLControlElement.loadObject(this.dataset, true, true);
        this.createGUI();
    }

    protected Dataset getDataset() {
        this.original.setMarkerShape(this.dataset.getMarkerShape());
        this.original.setMarkerSize(this.dataset.getMarkerSize());
        this.original.setConnected(this.dataset.isConnected());
        this.original.setLineColor(this.dataset.getLineColor());
        this.original.setMarkerColor(this.dataset.getFillColor(), this.dataset.getEdgeColor());
        return this.original;
    }

    protected void updateData() {
        XMLControlElement xMLControlElement = new XMLControlElement(this.original);
        xMLControlElement.loadObject(this.dataset, true, true);
        this.refresh();
        this.dataTable.refreshTable();
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        int n = 3;
        this.splitPanes = new JSplitPane[n];
        this.splitPanes[0] = new JSplitPane(1);
        this.splitPanes[0].setResizeWeight(1.0);
        this.splitPanes[1] = new JSplitPane(0);
        this.splitPanes[1].setResizeWeight(1.0);
        this.splitPanes[2] = new JSplitPane(0);
        this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post"), ToolsRes.getString("Shape.Area")};
        this.shapeNumbers = new int[]{1, 2, 6, 7, 8, 5};
        SpinnerListModel spinnerListModel = new SpinnerListModel(this.shapeNames);
        this.shapeSpinner = new JSpinner(spinnerListModel){

            public Dimension getMaximumSize() {
                Dimension dimension = DatasetTab.this.shapeSpinner.getPreferredSize();
                return new Dimension(dimension.width + 10, 100);
            }
        };
        this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
        int n2 = this.dataset.getMarkerShape();
        for (int i = 0; i < this.shapeNumbers.length; ++i) {
            if (this.shapeNumbers[i] != n2) continue;
            this.shapeSpinner.setValue(this.shapeNames[i]);
        }
        this.shapeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = DatasetTab.this.shapeSpinner.getValue().toString();
                for (int i = 0; i < DatasetTab.this.shapeNames.length; ++i) {
                    if (!DatasetTab.this.shapeNames[i].equals(string)) continue;
                    DatasetTab.this.dataset.setMarkerShape(DatasetTab.this.shapeNumbers[i]);
                    DatasetTab.this.refresh();
                }
            }
        });
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(2, 1, 6, 1);
        this.sizeSpinner = new JSpinner(spinnerNumberModel);
        this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
        Dimension dimension = this.sizeSpinner.getPreferredSize();
        this.sizeSpinner.setMaximumSize(new Dimension(dimension.width, 100));
        this.sizeSpinner.setValue(new Integer(this.dataset.getMarkerSize()));
        this.sizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)DatasetTab.this.sizeSpinner.getValue();
                DatasetTab.this.dataset.setMarkerSize(n);
                DatasetTab.this.refresh();
            }
        });
        this.markerCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Markers.Label"));
        boolean bl = this.dataset.getMarkerShape() != 0;
        this.markerCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Markers.ToolTip"));
        this.markerCheckBox.setSelected(bl);
        this.markerCheckBox.setOpaque(false);
        this.markerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DatasetTab.this.markerCheckBox.isSelected()) {
                    String string = DatasetTab.this.shapeSpinner.getValue().toString();
                    for (int i = 0; i < DatasetTab.this.shapeNames.length; ++i) {
                        if (!DatasetTab.this.shapeNames[i].equals(string)) continue;
                        DatasetTab.this.dataset.setMarkerShape(DatasetTab.this.shapeNumbers[i]);
                        break;
                    }
                } else {
                    DatasetTab.this.dataset.setMarkerShape(0);
                }
                DatasetTab.this.refresh();
            }
        });
        this.lineCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Lines.Label"));
        this.lineCheckBox.setSelected(this.dataset.isConnected());
        this.lineCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Lines.ToolTip"));
        this.lineCheckBox.setOpaque(false);
        this.lineCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTab.this.dataset.setConnected(DatasetTab.this.lineCheckBox.isSelected());
                DatasetTab.this.refresh();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color;
                JButton jButton = (JButton)actionEvent.getSource();
                String string = ToolsRes.getString("ColorChooser.Marker.Title");
                if (jButton == DatasetTab.this.lineColorButton) {
                    string = ToolsRes.getString("ColorChooser.Line.Title");
                }
                if (jButton == DatasetTab.this.fitColorButton) {
                    string = ToolsRes.getString("ColorChooser.Fit.Title");
                }
                if ((color = JColorChooser.showDialog(null, string, jButton.getBackground())) != null) {
                    if (jButton == DatasetTab.this.markerColorButton) {
                        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
                        Color color3 = color;
                        DatasetTab.this.dataset.setMarkerColor(color2, color3);
                    } else if (jButton == DatasetTab.this.lineColorButton) {
                        DatasetTab.this.dataset.setLineColor(color);
                    } else if (jButton == DatasetTab.this.fitColorButton) {
                        DatasetTab.this.curveFitter.setColor(color);
                    }
                    DatasetTab.this.refresh();
                }
            }
        };
        this.markerColorButton = this.createButton(ToolsRes.getString("Button.MarkerColor.Label"), this.buttonHeight);
        this.markerColorButton.setToolTipText(ToolsRes.getString("Button.MarkerColor.ToolTip"));
        this.markerColorButton.addActionListener(abstractAction);
        this.lineColorButton = this.createButton(ToolsRes.getString("Button.LineColor.Label"), this.buttonHeight);
        this.lineColorButton.setToolTipText(ToolsRes.getString("Button.LineColor.ToolTip"));
        this.lineColorButton.addActionListener(abstractAction);
        this.fitColorButton = this.createButton(ToolsRes.getString("Button.FitColor.Label"), this.buttonHeight);
        this.fitColorButton.setToolTipText(ToolsRes.getString("Button.FitColor.ToolTip"));
        this.fitColorButton.addActionListener(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DatasetTab.this.statsCheckBox.isSelected();
                DatasetTab.this.splitPanes[2].setDividerLocation(bl ? DatasetTab.this.statsTable.getHeight() + 4 : 0);
            }
        };
        this.statsCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Statistics.Label"), false);
        this.statsCheckBox.setOpaque(false);
        this.statsCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.statsCheckBox.addActionListener(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTab.this.splitPanes[1].setDividerSize(DatasetTab.this.splitPanes[2].getDividerSize());
                DatasetTab.this.splitPanes[1].setDividerLocation(1.0);
                DatasetTab.this.plot.removeDrawables(class$org$opensourcephysics$display$FunctionDrawer == null ? (class$org$opensourcephysics$display$FunctionDrawer = DatasetTab.class$("org.opensourcephysics.display.FunctionDrawer")) : class$org$opensourcephysics$display$FunctionDrawer);
                boolean bl = DatasetTab.this.fitCheckBox.isSelected();
                DatasetTab.this.splitPanes[1].setEnabled(bl);
                if (bl) {
                    int n = DatasetTab.this.splitPanes[1].getDividerLocation();
                    int n2 = DatasetTab.this.curveFitter.getPreferredSize().height;
                    DatasetTab.this.splitPanes[1].setDividerSize(DatasetTab.this.splitPanes[0].getDividerSize());
                    DatasetTab.this.splitPanes[1].setDividerLocation(n - n2);
                    DatasetTab.this.plot.addDrawable(DatasetTab.this.curveFitter.getDrawer());
                }
                DatasetTab.this.refresh();
            }
        };
        this.fitCheckBox = new JCheckBox(ToolsRes.getString("Checkbox.Fits.Label"), false);
        this.fitCheckBox.setOpaque(false);
        this.fitCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
        this.fitCheckBox.addActionListener(abstractAction3);
        this.plot = new Plot(this.dataset);
        this.plot.addDrawable(this.dataset);
        this.plot.setTitle(this.dataset.getName());
        this.plot.addDrawable(this.selectionBox);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            ArrayList rowsInside = new ArrayList();

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = 4096;
                boolean bl = mouseEvent.isPopupTrigger() || (((InputEvent)mouseEvent).getModifiersEx() & n) == n || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                DatasetTab.this.selectionBox.xstart = point.x;
                DatasetTab.this.selectionBox.ystart = point.y;
                this.rowsInside.clear();
                if (bl) {
                    if (DatasetTab.this.selectionBox.isZoomable()) {
                        DatasetTab.this.plot.getZoomInItem().setText(ToolsRes.getString("MenuItem.ZoomToBox"));
                    } else {
                        DatasetTab.this.zoomPoint = mouseEvent.getPoint();
                        DatasetTab.this.plot.getZoomInItem().setText(ToolsRes.getString("MenuItem.ZoomIn"));
                    }
                } else {
                    DatasetTab.this.selectionBox.setSize(0, 0);
                }
                if (!(mouseEvent.isControlDown() || mouseEvent.isShiftDown() || bl)) {
                    DatasetTab.this.dataTable.clearSelection();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                boolean bl;
                int n = 4096;
                boolean bl2 = bl = (((InputEvent)mouseEvent).getModifiersEx() & n) == n || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1;
                if (bl) {
                    return;
                }
                HighlightableDataset highlightableDataset = DatasetTab.this.dataTable.getData();
                Point point = mouseEvent.getPoint();
                DatasetTab.this.selectionBox.visible = true;
                DatasetTab.this.selectionBox.setSize(point.x - DatasetTab.this.selectionBox.xstart, point.y - DatasetTab.this.selectionBox.ystart);
                double[] dArray = highlightableDataset.getXPoints();
                double[] dArray2 = highlightableDataset.getYPoints();
                for (int i = 0; i < dArray.length; ++i) {
                    double d = DatasetTab.this.plot.xToPix(dArray[i]);
                    double d2 = DatasetTab.this.plot.yToPix(dArray2[i]);
                    Integer n2 = new Integer(i);
                    if (DatasetTab.this.selectionBox.contains(d, d2)) {
                        if (this.rowsInside.contains(n2)) continue;
                        this.rowsInside.add(n2);
                        DatasetTab.this.dataTable.getSelectionModel().addSelectionInterval(i, i);
                        continue;
                    }
                    if (!this.rowsInside.contains(n2)) continue;
                    DatasetTab.this.dataTable.getSelectionModel().removeSelectionInterval(i, i);
                    ((AbstractCollection)this.rowsInside).remove(n2);
                }
                DatasetTab.this.plot.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DatasetTab.this.plot.repaint();
            }
        };
        this.plot.addMouseListener(mouseInputAdapter);
        this.plot.addMouseMotionListener(mouseInputAdapter);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorder(BorderFactory.createEtchedBorder());
        jToolBar.addSeparator(new Dimension(4, 4));
        jToolBar.add(this.markerCheckBox);
        jToolBar.add(this.markerColorButton);
        jToolBar.add(this.shapeSpinner);
        jToolBar.add(this.sizeSpinner);
        jToolBar.addSeparator();
        jToolBar.add(this.lineCheckBox);
        jToolBar.add(this.lineColorButton);
        jToolBar.addSeparator();
        jToolBar.add(this.fitCheckBox);
        jToolBar.add(this.fitColorButton);
        jToolBar.addSeparator();
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.statsCheckBox);
        this.curveFitter = new DatasetCurveFitter(this.dataset);
        this.curveFitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("drawer")) {
                    DatasetTab.this.plot.removeDrawables(class$org$opensourcephysics$display$FunctionDrawer == null ? (class$org$opensourcephysics$display$FunctionDrawer = DatasetTab.class$("org.opensourcephysics.display.FunctionDrawer")) : class$org$opensourcephysics$display$FunctionDrawer);
                    DatasetTab.this.plot.addDrawable((FunctionDrawer)propertyChangeEvent.getNewValue());
                }
                DatasetTab.this.plot.repaint();
            }
        });
        this.dataTable = new DatasetDataTable(this.dataset);
        this.dataTable.setRowNumberVisible(true);
        this.dataTable.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        this.dataTable.refreshTable();
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DatasetTab.this.selectionBox.setSize(0, 0);
                DatasetTab.this.refresh();
                String string = GUIUtils.removeSubscripting(DatasetTab.this.displayData.getColumnName(1));
                String string2 = GUIUtils.removeSubscripting(DatasetTab.this.displayData.getColumnName(0));
                DatasetTab.this.curveFitter.equation.setText(string + " = " + DatasetTab.this.curveFitter.fit.getExpression(string2));
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DatasetTab.this.dataTable.getSelectedColumn() == 0) {
                    DatasetTab.this.dataTable.removeRowSelectionInterval(0, DatasetTab.this.dataTable.getRowCount() - 1);
                    DatasetTab.this.dataTable.data.clearHighlights();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                try {
                    DatasetTab.this.curveFitter.setData(DatasetTab.this.dataTable.getWorkingData());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.statsTable = new DatasetStatisticsTable(this.dataTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.statsTable);
        this.add((Component)jToolBar, "North");
        this.add((Component)this.splitPanes[0], "Center");
        this.splitPanes[0].setLeftComponent(this.splitPanes[1]);
        this.splitPanes[0].setRightComponent(this.splitPanes[2]);
        this.splitPanes[1].setTopComponent(this.plot);
        this.splitPanes[1].setBottomComponent(this.curveFitter);
        this.splitPanes[2].setTopComponent(jScrollPane2);
        this.splitPanes[2].setBottomComponent(jScrollPane);
        this.splitPanes[0].setOneTouchExpandable(true);
        this.splitPanes[2].setDividerSize(2);
        this.splitPanes[2].setEnabled(false);
        this.splitPanes[1].setDividerSize(this.splitPanes[2].getDividerSize());
    }

    protected void refreshGUI() {
        this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
        this.fitCheckBox.setText(ToolsRes.getString("Checkbox.Fits.Label"));
        this.fitCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Fits.ToolTip"));
        this.statsCheckBox.setText(ToolsRes.getString("Checkbox.Statistics.Label"));
        this.statsCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Statistics.ToolTip"));
        this.markerColorButton.setText(ToolsRes.getString("Button.MarkerColor.Label"));
        this.markerColorButton.setToolTipText(ToolsRes.getString("Button.MarkerColor.ToolTip"));
        this.lineColorButton.setText(ToolsRes.getString("Button.LineColor.Label"));
        this.lineColorButton.setToolTipText(ToolsRes.getString("Button.LineColor.ToolTip"));
        this.fitColorButton.setText(ToolsRes.getString("Button.FitColor.Label"));
        this.fitColorButton.setToolTipText(ToolsRes.getString("Button.FitColor.ToolTip"));
        this.lineCheckBox.setText(ToolsRes.getString("Checkbox.Lines.Label"));
        this.lineCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Lines.ToolTip"));
        this.markerCheckBox.setText(ToolsRes.getString("Checkbox.Markers.Label"));
        this.markerCheckBox.setToolTipText(ToolsRes.getString("Checkbox.Markers.ToolTip"));
        this.sizeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerSize.ToolTip"));
        this.shapeSpinner.setToolTipText(ToolsRes.getString("Spinner.MarkerShape.ToolTip"));
        this.shapeNames = new String[]{ToolsRes.getString("Shape.Circle"), ToolsRes.getString("Shape.Square"), ToolsRes.getString("Shape.Pixel"), ToolsRes.getString("Shape.Bar"), ToolsRes.getString("Shape.Post"), ToolsRes.getString("Shape.Area")};
        SpinnerListModel spinnerListModel = new SpinnerListModel(this.shapeNames);
        this.shapeSpinner.setModel(spinnerListModel);
        int n = this.dataset.getMarkerShape();
        for (int i = 0; i < this.shapeNumbers.length; ++i) {
            if (this.shapeNumbers[i] != n) continue;
            this.shapeSpinner.setValue(this.shapeNames[i]);
        }
        this.curveFitter.refreshGUI();
        this.statsTable.refreshGUI();
    }

    protected void init() {
        this.splitPanes[0].setDividerLocation(0.7);
        this.splitPanes[1].setDividerLocation(1.0);
        this.splitPanes[2].setDividerLocation(0);
    }

    protected JButton createButton(String string, final int n) {
        JButton jButton = new JButton(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = n;
                return dimension;
            }
        };
        return jButton;
    }

    protected void refresh() {
        this.markerColorButton.setForeground(this.dataset.getEdgeColor());
        this.markerColorButton.setEnabled(this.markerCheckBox.isSelected());
        this.shapeSpinner.setEnabled(this.markerCheckBox.isSelected());
        this.sizeSpinner.setEnabled(this.markerCheckBox.isSelected());
        this.lineColorButton.setForeground(this.dataset.getLineColor());
        this.lineColorButton.setEnabled(this.lineCheckBox.isSelected());
        this.fitColorButton.setForeground(this.curveFitter.color);
        this.fitColorButton.setEnabled(this.fitCheckBox.isSelected());
        this.dataTable.dataset.setName(this.dataset.getName());
        this.curveFitter.setData(this.dataTable.getWorkingData());
        this.plot.removeDrawables(class$org$opensourcephysics$display$Dataset == null ? (class$org$opensourcephysics$display$Dataset = DatasetTab.class$("org.opensourcephysics.display.Dataset")) : class$org$opensourcephysics$display$Dataset);
        this.displayData = this.dataTable.getData();
        this.plot.addDrawable(this.displayData);
        if (this.fitCheckBox.isSelected()) {
            this.plot.removeDrawable(this.curveFitter.getDrawer());
            this.plot.addDrawable(this.curveFitter.getDrawer());
        }
        this.plot.setTitle(this.displayData.getName());
        this.plot.setXLabel(this.displayData.getColumnName(0));
        this.plot.setYLabel(this.displayData.getColumnName(1));
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Plot
    extends PlottingPanel {
        Plot(Dataset dataset) {
            super(dataset.getColumnName(0), dataset.getColumnName(1), "");
        }

        protected JMenuItem getZoomInItem() {
            return this.zoomInItem;
        }

        protected void zoomOut() {
            double d = this.xmax - this.xmin;
            double d2 = this.ymax - this.ymin;
            this.setPreferredMinMax(this.xmin - d / 2.0, this.xmax + d / 2.0, this.ymin - d2 / 2.0, this.ymax + d2 / 2.0);
            this.validImage = false;
            DatasetTab.this.selectionBox.setSize(0, 0);
            this.repaint();
        }

        protected void zoomIn() {
            int n = DatasetTab.this.selectionBox.getBounds().width;
            int n2 = DatasetTab.this.selectionBox.getBounds().height;
            if (DatasetTab.this.selectionBox.isZoomable()) {
                int n3 = DatasetTab.this.selectionBox.getBounds().x;
                int n4 = DatasetTab.this.selectionBox.getBounds().y;
                double d = this.pixToX(n3);
                double d2 = this.pixToX(n3 + n);
                double d3 = this.pixToY(n4);
                double d4 = this.pixToY(n4 + n2);
                this.setPreferredMinMax(d, d2, d4, d3);
                this.validImage = false;
                DatasetTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            } else if (DatasetTab.this.zoomPoint != null) {
                double d = this.xmax - this.xmin;
                double d5 = this.ymax - this.ymin;
                double d6 = this.pixToX(DatasetTab.this.zoomPoint.x);
                double d7 = this.pixToY(DatasetTab.this.zoomPoint.y);
                this.setPreferredMinMax(d6 - d / 4.0, d6 + d / 4.0, d7 - d5 / 4.0, d7 + d5 / 4.0);
                this.validImage = false;
                DatasetTab.this.selectionBox.setSize(0, 0);
                this.repaint();
            }
        }

        protected void buildPopupmenu() {
            this.popupmenu.setEnabled(true);
            this.zoomInItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomIn"));
            this.zoomInItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Plot)Plot.this).DatasetTab.this.plot.zoomIn();
                }
            });
            this.popupmenu.add(this.zoomInItem);
            this.zoomOutItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomOut"));
            this.zoomOutItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Plot)Plot.this).DatasetTab.this.plot.zoomOut();
                }
            });
            this.popupmenu.add(this.zoomOutItem);
            JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.ZoomToFit"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Plot)Plot.this).DatasetTab.this.plot.setAutoscaleX(true);
                    ((Plot)Plot.this).DatasetTab.this.plot.setAutoscaleY(true);
                    ((Plot)Plot.this).DatasetTab.this.selectionBox.setSize(0, 0);
                    DatasetTab.this.refresh();
                }
            });
            this.popupmenu.add(jMenuItem);
            this.scaleItem = new JMenuItem(ToolsRes.getString("MenuItem.Scale"));
            this.scaleItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScaleInspector scaleInspector = new ScaleInspector(Plot.this);
                    scaleInspector.setLocationRelativeTo(Plot.this);
                    scaleInspector.updateDisplay();
                    ((Component)scaleInspector).setVisible(true);
                }
            });
            this.popupmenu.add(this.scaleItem);
            this.popupmenu.addSeparator();
            this.snapshotItem = new JMenuItem(ToolsRes.getString("MenuItem.Snapshot"));
            this.snapshotItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Plot.this.snapshot();
                }
            });
            this.popupmenu.add(this.snapshotItem);
            this.popupmenu.addSeparator();
            this.propertiesItem = new JMenuItem(ToolsRes.getString("MenuItem.Inspect"));
            this.propertiesItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Plot.this.showInspector();
                }
            });
            this.popupmenu.add(this.propertiesItem);
        }
    }

    class SelectionBox
    extends Rectangle
    implements Drawable {
        boolean visible = true;
        int xstart;
        int ystart;
        int zoomSize = 10;
        Color color = new Color(0, 255, 0, 127);

        SelectionBox() {
        }

        public void setSize(int n, int n2) {
            int n3 = Math.min(0, n);
            int n4 = Math.min(0, n2);
            n = Math.abs(n);
            n2 = Math.abs(n2);
            super.setLocation(this.xstart + n3, this.ystart + n4);
            super.setSize(n, n2);
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            if (this.visible) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(this.color);
                graphics2D.draw(this);
            }
        }

        public boolean isZoomable() {
            return this.getBounds().width > this.zoomSize && this.getBounds().height > this.zoomSize;
        }
    }
}

