/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.tools.DatasetDataTable;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetStatisticsTable
extends JTable {
    DatasetDataTable dataTable;
    StatisticsTableModel tableModel;
    LabelRenderer labelRenderer;
    protected Object[][] statsData;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public DatasetStatisticsTable(DatasetDataTable datasetDataTable) {
        this.dataTable = datasetDataTable;
        this.tableModel = new StatisticsTableModel();
        this.init();
    }

    protected void init() {
        this.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
                DatasetStatisticsTable.this.refreshTable();
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DatasetStatisticsTable.this.refreshTable();
            }
        });
        HighlightableDataset highlightableDataset = this.dataTable.getWorkingData();
        double[] dArray = this.getStatistics(highlightableDataset.getXPoints());
        double[] dArray2 = this.getStatistics(highlightableDataset.getValidYPoints());
        if (this.statsData == null) {
            this.statsData = new Object[dArray.length][0];
        }
        for (int i = 0; i < dArray.length; ++i) {
            String string = ToolsRes.getString("Table.Entry.Count");
            if (i == 5) {
                this.statsData[i] = new Object[]{string, new Integer((int)dArray[i]), new Integer((int)dArray2[i])};
                continue;
            }
            switch (i) {
                case 0: {
                    string = ToolsRes.getString("Table.Entry.Max");
                    break;
                }
                case 1: {
                    string = ToolsRes.getString("Table.Entry.Min");
                    break;
                }
                case 2: {
                    string = ToolsRes.getString("Table.Entry.Mean");
                    break;
                }
                case 3: {
                    string = ToolsRes.getString("Table.Entry.StandardDev");
                    break;
                }
                case 4: {
                    string = ToolsRes.getString("Table.Entry.StandardError");
                }
            }
            this.statsData[i] = new Object[]{string, new Double(dArray[i]), new Double(dArray2[i])};
        }
        this.setModel(this.tableModel);
        this.setGridColor(Color.blue);
        this.setEnabled(false);
        this.setTableHeader(null);
        this.labelRenderer = new LabelRenderer();
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = DatasetStatisticsTable.class$("java.lang.Double")) : class$java$lang$Double, new ScientificRenderer(3));
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                HighlightableDataset highlightableDataset = DatasetStatisticsTable.this.dataTable.getWorkingData();
                double[] dArray = DatasetStatisticsTable.this.getStatistics(highlightableDataset.getXPoints());
                double[] dArray2 = DatasetStatisticsTable.this.getStatistics(highlightableDataset.getValidYPoints());
                for (n = 0; n < dArray.length - 1; ++n) {
                    DatasetStatisticsTable.this.statsData[n][1] = new Double(dArray[n]);
                    DatasetStatisticsTable.this.statsData[n][2] = new Double(dArray2[n]);
                }
                DatasetStatisticsTable.this.statsData[n][1] = new Integer((int)dArray[n]);
                DatasetStatisticsTable.this.statsData[n][2] = new Integer((int)dArray2[n]);
                DatasetStatisticsTable.this.refreshTable();
            }
        });
        this.refreshCellWidths();
    }

    private double[] getStatistics(double[] dArray) {
        double d;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            ++n;
            d2 = Math.max(d2, dArray[i]);
            d3 = Math.min(d3, dArray[i]);
            d4 += dArray[i];
            d5 += dArray[i] * dArray[i];
        }
        double d6 = d4 / (double)n;
        double d7 = d = n < 2 ? Double.NaN : Math.sqrt((d5 - (double)n * d6 * d6) / (double)(n - 1));
        if (d2 == -1.7976931348623157E308) {
            d2 = Double.NaN;
        }
        if (d3 == Double.MAX_VALUE) {
            d3 = Double.NaN;
        }
        return new double[]{d2, d3, d6, d, d / Math.sqrt(n), n};
    }

    public void refreshTable() {
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                DatasetStatisticsTable.this.tableChanged(new TableModelEvent(DatasetStatisticsTable.this.tableModel, -1));
                DatasetStatisticsTable.this.refreshCellWidths();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void refreshCellWidths() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string = this.getColumnName(i);
            TableColumn tableColumn = this.getColumn(string);
            string = this.dataTable.getColumnName(i);
            TableColumn tableColumn2 = this.dataTable.getColumn(string);
            tableColumn.setMaxWidth(tableColumn2.getWidth());
            tableColumn.setMinWidth(tableColumn2.getWidth());
            tableColumn.setWidth(tableColumn2.getWidth());
        }
    }

    public void refreshGUI() {
        for (int i = 0; i < this.statsData.length; ++i) {
            String string = ToolsRes.getString("Table.Entry.Count");
            switch (i) {
                case 0: {
                    string = ToolsRes.getString("Table.Entry.Max");
                    break;
                }
                case 1: {
                    string = ToolsRes.getString("Table.Entry.Min");
                    break;
                }
                case 2: {
                    string = ToolsRes.getString("Table.Entry.Mean");
                    break;
                }
                case 3: {
                    string = ToolsRes.getString("Table.Entry.StandardDev");
                    break;
                }
                case 4: {
                    string = ToolsRes.getString("Table.Entry.StandardError");
                }
            }
            this.statsData[i][0] = string;
        }
        this.tableChanged(null);
        this.refreshTable();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.dataTable.convertColumnIndexToModel(n2);
        if (n3 == 0) {
            return this.labelRenderer;
        }
        return this.getDefaultRenderer(this.tableModel.getValueAt(n, n2).getClass());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ScientificRenderer
    extends JLabel
    implements TableCellRenderer {
        NumberFormat format = NumberFormat.getInstance();

        public ScientificRenderer(int n) {
            n = Math.min(n, 6);
            if (this.format instanceof DecimalFormat) {
                String string = "0.0";
                for (int i = 0; i < n - 1; ++i) {
                    string = string + "0";
                }
                string = string + "E0";
                ((DecimalFormat)this.format).applyPattern(string);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(DatasetStatisticsTable.this.getDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = DatasetStatisticsTable.class$("java.lang.String")) : class$java$lang$String).getTableCellRendererComponent(DatasetStatisticsTable.this, "a", false, false, 0, 0).getFont());
            this.setText(this.format.format(object));
            this.setHorizontalAlignment(11);
            return this;
        }
    }

    static class LabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public LabelRenderer() {
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            return this;
        }
    }

    class StatisticsTableModel
    extends AbstractTableModel {
        StatisticsTableModel() {
        }

        public String getColumnName(int n) {
            return DatasetStatisticsTable.this.dataTable.getColumnName(n);
        }

        public int getRowCount() {
            return DatasetStatisticsTable.this.statsData.length;
        }

        public int getColumnCount() {
            return DatasetStatisticsTable.this.dataTable.getColumnCount();
        }

        public Object getValueAt(int n, int n2) {
            int n3 = DatasetStatisticsTable.this.dataTable.convertColumnIndexToModel(n2);
            return DatasetStatisticsTable.this.statsData[n][n3];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

