/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionTool
extends JDialog {
    private static Dimension dim = new Dimension(320, 300);
    private static TextFrame helpFrame;
    private static String helpURL;
    Map panels = new TreeMap();
    JPanel contentPane = new JPanel(new BorderLayout());
    JPanel noData;
    JComboBox dropdown;
    JPanel north = new JPanel(new BorderLayout());
    boolean refreshing;
    DataFunctionPanel selectedPanel;
    JButton helpButton;
    JButton closeButton;
    JPanel buttonbar = new JPanel(new FlowLayout(4));

    public DataFunctionTool(Component component) {
        super(JOptionPane.getFrameForComponent(component), false);
        if (component instanceof PropertyChangeListener) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)((Object)component);
            this.addPropertyChangeListener("variable", propertyChangeListener);
            this.addPropertyChangeListener("function", propertyChangeListener);
            this.addPropertyChangeListener("visible", propertyChangeListener);
        }
        this.setName("DataFunctionTool");
        this.createGUI();
        this.refreshGUI();
    }

    public void addData(String string, DatasetManager datasetManager) {
        DataFunctionPanel dataFunctionPanel = new DataFunctionPanel(datasetManager, this);
        dataFunctionPanel.setPreferredSize(dim);
        this.panels.put(string, dataFunctionPanel);
        this.refreshing = true;
        this.dropdown.addItem(string);
        this.refreshing = false;
        if (this.selectedPanel == null) {
            this.setSelectedData(string);
        }
    }

    public void removeData(String string) {
        DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)this.panels.get(string);
        if (dataFunctionPanel != null) {
            this.panels.remove(string);
            this.refreshing = true;
            this.dropdown.removeItem(string);
            this.refreshing = false;
        }
        if (this.panels.isEmpty()) {
            this.select(null);
        } else {
            this.setSelectedData((String)this.dropdown.getItemAt(0));
        }
    }

    public void setSelectedData(String string) {
        this.dropdown.setSelectedItem(string);
    }

    public String getSelectedDataName() {
        Component component = this.contentPane.getComponent(1);
        if (component instanceof DataFunctionPanel) {
            DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)component;
            Iterator iterator = this.panels.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.panels.get(string) != dataFunctionPanel) continue;
                return string;
            }
        }
        return null;
    }

    public void renameData(String string, String string2) {
        String string3 = this.getSelectedDataName();
        DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)this.panels.get(string);
        if (dataFunctionPanel != null) {
            this.refreshing = true;
            this.panels.remove(string);
            this.panels.put(string2, dataFunctionPanel);
            this.dropdown.removeItem(string);
            this.dropdown.addItem(string2);
            if (string.equals(string3)) {
                this.dropdown.setSelectedItem(string2);
            }
            dataFunctionPanel.refreshGUI();
            this.refreshing = false;
        }
    }

    public void clearData() {
        this.refreshing = true;
        this.panels.clear();
        this.dropdown.removeAllItems();
        this.select(null);
        this.refreshing = false;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.firePropertyChange("visible", null, new Boolean(bl));
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    private void createGUI() {
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataFunctionTool.this.refreshGUI();
            }
        });
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        this.noData = new JPanel();
        JLabel jLabel = new JLabel(ToolsRes.getString("DataFunctionTool.Message.NoData"));
        this.noData.add(jLabel);
        this.dropdown = new JComboBox();
        this.north.add((Component)this.dropdown, "North");
        this.north.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.dropdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataFunctionTool.this.refreshing) {
                    return;
                }
                String string = (String)DataFunctionTool.this.dropdown.getSelectedItem();
                DataFunctionTool.this.select(string);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataFunctionTool.this.setVisible(false);
            }
        });
        this.helpButton = new JButton();
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (helpFrame == null) {
                    Object object;
                    if (ResourceLoader.getResource(helpURL) != null) {
                        helpFrame = new TextFrame(helpURL);
                    } else {
                        object = "/org/opensourcephysics/resources/tools/html/datafunction_tool_help.html";
                        helpFrame = new TextFrame((String)object);
                    }
                    ((Component)helpFrame).setSize(600, 500);
                    object = Toolkit.getDefaultToolkit().getScreenSize();
                    int n = (((Dimension)object).width - helpFrame.getBounds().width) / 2;
                    int n2 = (((Dimension)object).height - helpFrame.getBounds().height) / 2;
                    ((Component)helpFrame).setLocation(n, n2);
                }
                ((Component)helpFrame).setVisible(true);
            }
        });
        this.buttonbar.add(this.helpButton);
        this.buttonbar.add(this.closeButton);
        this.contentPane.setPreferredSize(dim);
        this.contentPane.add((Component)this.noData, "Center");
        this.contentPane.add((Component)this.buttonbar, "South");
        this.setContentPane(this.contentPane);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(n, n2);
    }

    private void refreshGUI() {
        this.setTitle(ToolsRes.getString("DataFunctionTool.Title"));
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.closeButton.setToolTipText(ToolsRes.getString("Tool.Button.Close.ToolTip"));
        this.helpButton.setText(ToolsRes.getString("Tool.Button.Help"));
        this.helpButton.setToolTipText(ToolsRes.getString("Tool.Button.Help.ToolTip"));
        Iterator iterator = this.panels.values().iterator();
        while (iterator.hasNext()) {
            DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)iterator.next();
            dataFunctionPanel.refreshGUI();
        }
    }

    private void select(String string) {
        DataFunctionPanel dataFunctionPanel = (DataFunctionPanel)this.panels.get(string);
        if (this.selectedPanel != null) {
            this.contentPane.remove(this.selectedPanel);
        } else {
            this.contentPane.remove(this.noData);
        }
        if (dataFunctionPanel != null) {
            this.contentPane.add((Component)dataFunctionPanel, "Center");
            this.contentPane.add((Component)this.north, "North");
            dataFunctionPanel.refreshGUI();
        } else {
            this.contentPane.add((Component)this.noData, "Center");
            this.contentPane.remove(this.north);
            this.buttonbar.removeAll();
            this.buttonbar.add(this.helpButton);
            this.buttonbar.add(this.closeButton);
        }
        this.selectedPanel = dataFunctionPanel;
        this.validate();
        this.repaint();
    }

    static {
        helpURL = "http://www.opensourcephysics.org/online_help/tools/datafunction_tool_help.html";
    }
}

