/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.DataFunctionTool;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionPanel
extends JPanel {
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    static final Color LIGHT_RED = new Color(255, 102, 102);
    private DataFunctionTool tool;
    private DatasetManager data;
    private FunctionTableModel model = new FunctionTableModel();
    private FunctionTable table;
    private FunctionCellEditor editor = new FunctionCellEditor();
    private FunctionCellRenderer renderer = new FunctionCellRenderer();
    private JTextArea variables;
    private JScrollPane scroller;
    private ArrayList functions = new ArrayList();
    private JButton newButton;
    private JButton deleteButton;
    private int id = 0;

    public DataFunctionPanel(DatasetManager datasetManager, DataFunctionTool dataFunctionTool) {
        super(new BorderLayout());
        this.tool = dataFunctionTool;
        this.data = datasetManager;
        this.createGUI();
        this.refreshGUI();
        this.refreshTable();
        this.refreshVars(null);
    }

    private void createGUI() {
        Box box = Box.createVerticalBox();
        this.add((Component)box, "Center");
        this.variables = new JTextArea();
        this.variables.setEditable(false);
        this.variables.setLineWrap(true);
        this.variables.setWrapStyleWord(true);
        box.add(this.variables);
        this.table = new FunctionTable(this.model);
        this.scroller = new JScrollPane(this.table);
        box.add(this.scroller);
        this.newButton = new JButton();
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataFunction dataFunction = new DataFunction(DataFunctionPanel.this.data);
                dataFunction.setFunctionName(dataFunction.getFunctionName() + DataFunctionPanel.this.id++);
                DataFunctionPanel.this.data.addDataset(dataFunction);
                DataFunctionPanel.this.refreshTable();
                DataFunctionPanel.this.refreshVars(dataFunction);
                int n = DataFunctionPanel.this.functions.size() - 1;
                DataFunctionPanel.this.table.setColumnSelectionInterval(0, 0);
                DataFunctionPanel.this.table.setRowSelectionInterval(n, n);
                DataFunctionPanel.this.tool.firePropertyChange("variable", null, dataFunction.getFunctionName());
            }
        });
        this.deleteButton = new JButton();
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataFunctionPanel.this.table.getSelectedRow();
                if (n < 0) {
                    return;
                }
                DataFunction dataFunction = (DataFunction)DataFunctionPanel.this.functions.get(n);
                int n2 = DataFunctionPanel.this.data.getDatasetIndex(dataFunction.getFunctionName());
                if (n2 > -1) {
                    DataFunctionPanel.this.data.removeDataset(n2);
                    DataFunctionPanel.this.refreshTable();
                    if (n == DataFunctionPanel.this.functions.size()) {
                        --n;
                    }
                    if (n >= 0) {
                        DataFunctionPanel.this.table.setColumnSelectionInterval(0, 0);
                        DataFunctionPanel.this.table.setRowSelectionInterval(n, n);
                        dataFunction = (DataFunction)DataFunctionPanel.this.functions.get(n);
                        DataFunctionPanel.this.refreshVars(dataFunction);
                    } else {
                        DataFunctionPanel.this.refreshVars(null);
                    }
                    DataFunctionPanel.this.tool.firePropertyChange("variable", dataFunction.getFunctionName(), null);
                }
            }
        });
    }

    protected void refreshGUI() {
        this.newButton.setText(ToolsRes.getString("DataFunctionPanel.Button.NewFunction"));
        this.newButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.NewFunction.Tooltip"));
        this.deleteButton.setText(ToolsRes.getString("DataFunctionPanel.Button.DeleteFunction"));
        this.deleteButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.DeleteFunction.Tooltip"));
        this.variables.setToolTipText(ToolsRes.getString("DataFunctionPanel.TextArea.Variables.Tooltip"));
        this.tool.buttonbar.removeAll();
        this.tool.buttonbar.add(this.newButton);
        this.tool.buttonbar.add(this.deleteButton);
        this.tool.buttonbar.add(this.tool.helpButton);
        this.tool.buttonbar.add(this.tool.closeButton);
        Border border = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(ToolsRes.getString("DataFunctionPanel.TextArea.Variables.Title"));
        this.variables.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        border = BorderFactory.createEmptyBorder(0, 4, 4, 4);
        titledBorder = BorderFactory.createTitledBorder(ToolsRes.getString("DataFunctionPanel.Table.Functions.Title"));
        Border border2 = BorderFactory.createLineBorder(Color.BLACK);
        border = BorderFactory.createCompoundBorder(border, border2);
        this.scroller.setBorder(BorderFactory.createCompoundBorder(titledBorder, border));
        this.model.fireTableStructureChanged();
        this.revalidate();
    }

    private void refreshTable() {
        this.functions.clear();
        Iterator iterator = ((AbstractList)this.data.getDatasets()).iterator();
        while (iterator.hasNext()) {
            Dataset dataset = (Dataset)iterator.next();
            if (!(dataset instanceof DataFunction)) continue;
            this.functions.add(dataset);
        }
        this.model.fireTableStructureChanged();
    }

    private void refreshVars(DataFunction dataFunction) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Object> iterator = ((AbstractList)this.data.getDatasets()).iterator();
        while (iterator.hasNext()) {
            object2 = (Dataset)iterator.next();
            if (object2 instanceof DataFunction) continue;
            object = null;
            if (stringBuffer.length() == 0) {
                object = GUIUtils.removeSubscripting(((Dataset)object2).getXColumnName());
                stringBuffer.append((String)object);
            }
            object = GUIUtils.removeSubscripting(((Dataset)object2).getYColumnName());
            stringBuffer.append(",   " + (String)object);
        }
        object2 = this.data.getProperties();
        iterator = object2.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!(object2.get(object) instanceof Double)) continue;
            object = GUIUtils.removeSubscripting((String)object);
            stringBuffer.append(",   " + (String)object);
        }
        iterator = ((AbstractList)this.functions).iterator();
        while (iterator.hasNext()) {
            object = (DataFunction)iterator.next();
            if (object == dataFunction) continue;
            String string = GUIUtils.removeSubscripting(((DataFunction)object).getFunctionName());
            stringBuffer.append(",   " + string);
        }
        this.variables.setText(stringBuffer.toString());
        this.revalidate();
    }

    class FunctionCellRenderer
    extends DefaultTableCellRenderer {
        Font font = new JTextField().getFont();

        public FunctionCellRenderer() {
            this.setOpaque(true);
            this.setFont(this.font);
            this.setHorizontalAlignment(2);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText(object.toString());
            DataFunction dataFunction = (DataFunction)DataFunctionPanel.this.functions.get(n);
            if (n2 == 1 && !dataFunction.getFunction().equals(dataFunction.getInputString())) {
                this.setForeground(Color.BLACK);
                this.setBackground(LIGHT_RED);
            } else if (bl) {
                this.setForeground(Color.RED);
                this.setBackground(LIGHT_BLUE);
                DataFunctionPanel.this.refreshVars(dataFunction);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }

    class FunctionCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        int keepFocus = -2;

        FunctionCellEditor() {
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 2));
            this.field.setBorder(null);
            this.field.setEditable(true);
            this.field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FunctionCellEditor.this.stopCellEditing();
                    FunctionCellEditor.this.keepFocus = -2;
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        FunctionCellEditor.this.stopCellEditing();
                        FunctionCellEditor.this.keepFocus = -2;
                    } else {
                        FunctionCellEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    int n;
                    if (FunctionCellEditor.this.field.getBackground() != Color.WHITE) {
                        FunctionCellEditor.this.stopCellEditing();
                    }
                    if (FunctionCellEditor.this.keepFocus == (n = DataFunctionPanel.this.table.getSelectedRow())) {
                        FunctionCellEditor.this.keepFocus = -2;
                    } else {
                        DataFunctionPanel.this.table.requestFocusInWindow();
                    }
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.field.setText(object.toString());
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                this.keepFocus = n = DataFunctionPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                return true;
            }
            if (eventObject instanceof ActionEvent) {
                this.keepFocus = -2;
                return true;
            }
            return false;
        }

        public Object getCellEditorValue() {
            this.field.setBackground(Color.WHITE);
            return this.field.getText();
        }
    }

    class FunctionTableModel
    extends AbstractTableModel {
        FunctionTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return DataFunctionPanel.this.functions.size();
        }

        public String getColumnName(int n) {
            return n == 0 ? ToolsRes.getString("DataFunctionPanel.Table.Column.Name") : ToolsRes.getString("DataFunctionPanel.Table.Column.Expression");
        }

        public Object getValueAt(int n, int n2) {
            DataFunction dataFunction = (DataFunction)DataFunctionPanel.this.functions.get(n);
            return n2 == 0 ? dataFunction.getFunctionName() : dataFunction.getInputString();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof String) {
                String string = (String)object;
                DataFunction dataFunction = (DataFunction)DataFunctionPanel.this.functions.get(n);
                if (n2 == 0) {
                    if (string.equals(dataFunction.getFunctionName())) {
                        return;
                    }
                    boolean bl = DataFunctionPanel.this.data.getDataset(0).getXColumnName().equals(string);
                    Iterator iterator = ((AbstractList)DataFunctionPanel.this.data.getDatasets()).iterator();
                    while (iterator.hasNext() && !bl) {
                        Dataset dataset = (Dataset)iterator.next();
                        if (dataset == dataFunction) continue;
                        bl = dataset.getYColumnName().equals(string);
                    }
                    if (bl) {
                        JOptionPane.showMessageDialog(null, ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Message"), ToolsRes.getString("DataFunctionPanel.Dialog.DuplicateName.Title"), 2);
                        return;
                    }
                    dataFunction.setFunctionName(string);
                    DataFunctionPanel.this.refreshVars(dataFunction);
                    DataFunctionPanel.this.tool.firePropertyChange("variable", null, dataFunction.getFunctionName());
                } else {
                    dataFunction.setFunction(string);
                    DataFunctionPanel.this.tool.firePropertyChange("function", null, null);
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    class FunctionTable
    extends JTable {
        FunctionTable(FunctionTableModel functionTableModel) {
            this.setModel(functionTableModel);
            this.setSelectionMode(0);
            this.setColumnSelectionAllowed(true);
            this.getTableHeader().setReorderingAllowed(false);
            this.setGridColor(Color.BLACK);
            InputMap inputMap = this.getInputMap(1);
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanel jPanel;
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n = jTable.getSelectedRow();
                    int n2 = jTable.getSelectedColumn();
                    jTable.editCellAt(n, n2, actionEvent);
                    Component component = jTable.getEditorComponent();
                    if (component instanceof JPanel && (component = (jPanel = (JPanel)component).getComponent(0)) instanceof JTextField) {
                        JTextField jTextField = (JTextField)component;
                        jTextField.requestFocus();
                        jTextField.selectAll();
                    }
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            return DataFunctionPanel.this.editor;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return DataFunctionPanel.this.renderer;
        }
    }
}

