/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;
    private PropertyChangeSupport support;

    public CheckTreeSelectionModel(TreeModel treeModel) {
        this.model = treeModel;
        this.setSelectionMode(4);
        this.support = new SwingPropertyChangeSupport(this);
    }

    public boolean isPathUnselected(TreePath treePath) {
        if (this.isSelectionEmpty()) {
            return true;
        }
        if (this.isPathOrAncestorSelected(treePath)) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            if (!treePath.isDescendant(treePathArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isPathOrAncestorSelected(TreePath treePath) {
        while (treePath != null && !this.isPathSelected(treePath)) {
            treePath = treePath.getParentPath();
        }
        return treePath != null;
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        super.clearSelection();
        this.addSelectionPaths(treePathArray);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        Object object;
        TreePath treePath;
        int n;
        if (treePathArray == null) {
            return;
        }
        TreePath[] treePathArray2 = this.getSelectionPaths();
        for (n = 0; n < treePathArray.length && !this.isSelectionEmpty(); ++n) {
            treePath = treePathArray[n];
            object = this.getSelectionPaths();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < ((TreePath[])object).length; ++i) {
                if (!treePath.isDescendant((TreePath)object[i])) continue;
                arrayList.add(object[i]);
            }
            super.removeSelectionPaths(arrayList.toArray(new TreePath[0]));
        }
        for (n = 0; n < treePathArray.length; ++n) {
            treePath = treePathArray[n];
            object = null;
            while (this.isSiblingsSelected(treePath)) {
                object = treePath;
                if (treePath.getParentPath() == null) break;
                treePath = treePath.getParentPath();
            }
            if (object != null) {
                if (((TreePath)object).getParentPath() != null) {
                    this.addSelectionPath(((TreePath)object).getParentPath());
                    continue;
                }
                if (!this.isSelectionEmpty()) {
                    this.removeSelectionPaths(this.getSelectionPaths());
                }
                super.addSelectionPaths(new TreePath[]{object});
                continue;
            }
            super.addSelectionPaths(new TreePath[]{treePath});
        }
        this.support.firePropertyChange("treepaths", treePathArray2, this.getSelectionPaths());
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (this.isSelectionEmpty()) {
            return;
        }
        TreePath[] treePathArray2 = this.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            if (treePath.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{treePath});
                continue;
            }
            if (this.isPathSelected(treePath)) {
                super.removeSelectionPaths(new TreePath[]{treePath});
                continue;
            }
            this.unselectAncestor(treePath);
        }
        this.support.firePropertyChange("treepaths", treePathArray2, this.getSelectionPaths());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private boolean isSiblingsSelected(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        Object object2 = treePath2.getLastPathComponent();
        int n = this.model.getChildCount(object2);
        for (int i = 0; i < n; ++i) {
            Object object3 = this.model.getChild(object2, i);
            if (object3.equals(object) || this.isPathSelected(treePath2.pathByAddingChild(object3))) continue;
            return false;
        }
        return true;
    }

    private void unselectAncestor(TreePath treePath) {
        TreePath treePath2;
        Stack<TreePath> stack = new Stack<TreePath>();
        stack.push(treePath);
        for (treePath2 = treePath.getParentPath(); treePath2 != null && !this.isPathSelected(treePath2); treePath2 = treePath2.getParentPath()) {
            stack.push(treePath2);
        }
        if (treePath2 == null) {
            return;
        }
        stack.push(treePath2);
        while (!stack.isEmpty()) {
            TreePath treePath3 = (TreePath)stack.pop();
            super.removeSelectionPaths(new TreePath[]{treePath3});
            if (stack.isEmpty()) {
                return;
            }
            Object object = treePath3.getLastPathComponent();
            int n = this.model.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = this.model.getChild(object, i);
                super.addSelectionPaths(new TreePath[]{treePath3.pathByAddingChild(object2)});
            }
        }
    }
}

