/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public final class VectorMath {
    private VectorMath() {
    }

    public static double[] plus(double[] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal length to add.");
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] + d * dArray2[i];
        }
        return dArray;
    }

    public static double[] plus(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal length to add.");
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] + dArray2[i];
        }
        return dArray;
    }

    public static double[] normalize(double[] dArray) {
        double d = VectorMath.magnitude(dArray);
        if (d == 0.0) {
            dArray[0] = 1.0;
            return dArray;
        }
        dArray[0] = dArray[0] / d;
        dArray[1] = dArray[1] / d;
        dArray[2] = dArray[2] / d;
        return dArray;
    }

    public static double dot(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension in dot product.");
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] project(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension to compute projection.");
        }
        double[] dArray3 = (double[])dArray2.clone();
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            d2 += dArray[n] * dArray2[n];
            d += dArray[n] * dArray[n];
        }
        d2 /= d;
        n = 0;
        while (n < n2) {
            int n3 = n++;
            dArray3[n3] = dArray3[n3] / d2;
        }
        return dArray3;
    }

    public static double[] perp(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        if (n2 != dArray2.length) {
            throw new UnsupportedOperationException("ERROR: Vectors must be of equal dimension to find the perpendicular component.");
        }
        double[] dArray3 = (double[])dArray2.clone();
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < n2; ++n) {
            d2 += dArray[n] * dArray2[n];
            d += dArray[n] * dArray[n];
        }
        d2 /= d;
        for (n = 0; n < n2; ++n) {
            dArray3[n] = dArray[n] - dArray2[n] / d2;
        }
        return dArray3;
    }

    public static double magnitudeSquared(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public static double magnitude(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return Math.sqrt(d);
    }

    public static final double[] cross3D(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray2[0] * dArray[2] - dArray2[2] * dArray[0], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    public static double[] cross2D(double[] dArray, double d) {
        if (dArray.length != 2) {
            throw new UnsupportedOperationException("ERROR: Cross2D product requires 2 component array.");
        }
        double d2 = dArray[0];
        dArray[0] = dArray[1] * d;
        dArray[1] = -d2 * d;
        return dArray;
    }

    public static double cross2D(double[] dArray, double[] dArray2) {
        if (dArray.length != 2 || dArray2.length != 2) {
            throw new UnsupportedOperationException("ERROR: Cross2D product requires 2 component arrays.");
        }
        return dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }
}

