/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.Polynomial;

public class PolynomialLeastSquareFit
extends Polynomial {
    double[][] systemMatrix;
    double[] systemConstants;

    public PolynomialLeastSquareFit(double[] dArray, double[] dArray2, int n) {
        super(new double[n + 1]);
        int n2 = n + 1;
        this.systemMatrix = new double[n2][n2];
        this.systemConstants = new double[n2];
        this.fitData(dArray, dArray2);
    }

    public PolynomialLeastSquareFit(double[] dArray) {
        super(dArray);
        int n = dArray.length;
        this.systemMatrix = new double[n][n];
        this.systemConstants = new double[n];
    }

    public void fitData(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of equal length.");
        }
        if (dArray.length < this.degree() + 1) {
            return;
        }
        for (n2 = 0; n2 < this.systemConstants.length; ++n2) {
            this.systemConstants[n2] = 0.0;
            for (n = 0; n < this.systemConstants.length; ++n) {
                this.systemMatrix[n2][n] = 0.0;
            }
        }
        n = dArray.length;
        for (n2 = 0; n2 < n; ++n2) {
            double d = 1.0;
            for (int i = 0; i < this.systemConstants.length; ++i) {
                int n3 = i;
                this.systemConstants[n3] = this.systemConstants[n3] + d * dArray2[n2];
                double d2 = d;
                int n4 = 0;
                while (n4 <= i) {
                    double[] dArray3 = this.systemMatrix[i];
                    int n5 = n4++;
                    dArray3[n5] = dArray3[n5] + d2;
                    d2 *= dArray[n2];
                }
                d *= dArray[n2];
            }
        }
        this.computeCoefficients();
    }

    protected void computeCoefficients() {
        for (int i = 0; i < this.systemConstants.length; ++i) {
            for (int j = i + 1; j < this.systemConstants.length; ++j) {
                this.systemMatrix[i][j] = this.systemMatrix[j][i];
            }
        }
        LUPDecomposition lUPDecomposition = new LUPDecomposition(this.systemMatrix);
        double[][] dArray = lUPDecomposition.inverseMatrixComponents();
        LUPDecomposition.symmetrizeComponents(dArray);
        this.coefficients = lUPDecomposition.solve(this.systemConstants);
    }
}

