/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEMultistepSolver;
import org.opensourcephysics.numerics.RK45MultiStep;
import org.opensourcephysics.numerics.Util;

public final class Integral {
    static final int MAX_ITERATIONS = 15;

    private Integral() {
    }

    public static double trapezoidal(Function function, double d, double d2, int n, double d3) {
        double d4;
        int n2;
        double d5 = d2 - d;
        int n3 = n2 = d5 < 0.0 ? -1 : 1;
        if (n2 < 1) {
            d5 = -d5;
            double d6 = d;
            d = d2;
            d2 = d6;
        }
        int n4 = 0;
        double d7 = (function.evaluate(d2) + function.evaluate(d)) * d5 * 0.5;
        do {
            d4 = d7;
            double d8 = 0.0;
            for (double d9 = d + 0.5 * d5; d9 < d2; d9 += d5) {
                d8 += function.evaluate(d9);
            }
            d7 = (d5 * d8 + d7) * 0.5;
            d5 *= 0.5;
        } while ((n /= 2) > 0 || ++n4 < 15 && Util.relativePrecision(Math.abs(d7 - d4), d7) > d3);
        return (double)n2 * d7;
    }

    public static double simpson(Function function, double d, double d2, int n) throws IllegalArgumentException {
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Number of partitions must be even in Simpson's method.");
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d;
        double d6 = (d2 - d) / (double)(2 * n);
        for (int i = 0; i < n - 1; ++i) {
            d3 += function.evaluate(d5 + d6);
            d4 += function.evaluate(d5 + 2.0 * d6);
            d5 += 2.0 * d6;
        }
        return d6 / 3.0 * (function.evaluate(d) + 4.0 * (d3 += function.evaluate(d5 + d6)) + 2.0 * d4 + function.evaluate(d2));
    }

    public static double simpson(Function function, double d, double d2, int n, double d3) {
        double d4;
        double d5;
        int n2;
        double d6 = d2 - d;
        int n3 = n2 = d6 < 0.0 ? -1 : 1;
        if (n2 < 1) {
            d6 = -d6;
            double d7 = d;
            d = d2;
            d2 = d7;
        }
        int n4 = 0;
        double d8 = d5 = (d4 = (function.evaluate(d2) + function.evaluate(d)) * d6 * 0.5);
        do {
            double d9 = d4;
            double d10 = 0.0;
            for (double d11 = d + 0.5 * d6; d11 < d2; d11 += d6) {
                d10 += function.evaluate(d11);
            }
            d4 = (d6 * d10 + d4) * 0.5;
            d6 *= 0.5;
            d8 = d5;
            d5 = (4.0 * d4 - d9) / 3.0;
        } while ((n /= 2) > 0 || ++n4 < 15 && Util.relativePrecision(Math.abs(d5 - d8), d5) > d3);
        return (double)n2 * d5;
    }

    public static double romberg(Function function, double d, double d2, int n, double d3) {
        int n2;
        if (d == d2) {
            return 0.0;
        }
        if (d3 <= 0.0) {
            return Double.NaN;
        }
        double[] dArray = new double[15];
        double d4 = (d2 - d) / (double)n;
        dArray[0] = 0.5 * (function.evaluate(d) + function.evaluate(d2));
        for (n2 = 1; n2 < n; ++n2) {
            dArray[0] = dArray[0] + function.evaluate(d + (double)n2 * d4);
        }
        dArray[0] = dArray[0] * d4;
        for (n2 = 1; n2 < 15; ++n2) {
            int n3;
            d4 /= 2.0;
            double d5 = dArray[0];
            dArray[n2] = 0.0;
            dArray[0] = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                dArray[0] = dArray[0] + function.evaluate(d + (double)(2 * n3 + 1) * d4);
            }
            dArray[0] = 0.5 * d5 + d4 * dArray[0];
            n3 = 1;
            for (int i = 1; i <= n2; ++i) {
                double d6 = dArray[i];
                dArray[i] = ((double)(n3 *= 4) * dArray[i - 1] - d5) / (double)(n3 - 1);
                d5 = d6;
            }
            if (Util.relativePrecision(Math.abs(dArray[n2] - dArray[n2 - 1]), dArray[n2]) < d3) {
                return dArray[n2];
            }
            n *= 2;
        }
        return Double.NaN;
    }

    public static double simpson(double[] dArray, double d) {
        int n = dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 1; i < n - 1; i += 2) {
            d2 += dArray[i];
            d3 += dArray[i + 1];
        }
        return (4.0 * d2 + 2.0 * d3 + dArray[0] - dArray[n - 1]) * d / 3.0;
    }

    public static double ode(Function function, double d, double d2, double d3) {
        FunctionRate functionRate = new FunctionRate(function, d);
        RK45MultiStep rK45MultiStep = new RK45MultiStep(functionRate);
        rK45MultiStep.setTolerance(d3);
        rK45MultiStep.initialize(d2 - d);
        rK45MultiStep.step();
        return functionRate.getState()[0];
    }

    public static double[][] fillArray(Function function, double d, double d2, double d3, int n) {
        double[][] dArray = new double[2][n];
        return Integral.fillArray(function, d, d2, d3, dArray);
    }

    public static double[][] fillArray(Function function, double d, double d2, double d3, double[][] dArray) {
        FunctionRate functionRate = new FunctionRate(function, d);
        ODEMultistepSolver oDEMultistepSolver = new ODEMultistepSolver(functionRate);
        oDEMultistepSolver.setTolerance(d3);
        double d4 = 1.0;
        int n = dArray[0].length;
        if (n > 1) {
            d4 = (d2 - d) / (double)(n - 1);
        }
        oDEMultistepSolver.setStepSize(d4);
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = functionRate.getState()[1];
            dArray[1][i] = functionRate.getState()[0];
            oDEMultistepSolver.step();
        }
        return dArray;
    }

    private static final class FunctionRate
    implements ODE {
        double[] state = new double[2];
        Function f;

        private FunctionRate(Function function, double d) {
            this.state[0] = 0.0;
            this.state[1] = d;
            this.f = function;
        }

        public double[] getState() {
            return this.state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[0] = this.f.evaluate(dArray[1]);
            dArray2[1] = 1.0;
        }
    }
}

