/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Polynomial;

public class Chebyshev {
    static final ArrayList chebyshevTList = new ArrayList();
    static final ArrayList chebyshevUList = new ArrayList();

    private Chebyshev() {
    }

    public static synchronized Polynomial getPolynomialT(int n) {
        if (n < chebyshevTList.size()) {
            return (Polynomial)chebyshevTList.get(n);
        }
        Polynomial polynomial = new Polynomial(new double[]{0.0, 2.0});
        Polynomial polynomial2 = polynomial.multiply(Chebyshev.getPolynomialT(n - 1)).subtract(Chebyshev.getPolynomialT(n - 2));
        chebyshevTList.add(polynomial2);
        return polynomial2;
    }

    public static synchronized Polynomial getPolynomialU(int n) {
        if (n < chebyshevUList.size()) {
            return (Polynomial)chebyshevUList.get(n);
        }
        Polynomial polynomial = new Polynomial(new double[]{0.0, 2.0});
        Polynomial polynomial2 = polynomial.multiply(Chebyshev.getPolynomialU(n - 1)).subtract(Chebyshev.getPolynomialU(n - 2));
        chebyshevUList.add(polynomial2);
        return polynomial2;
    }

    static {
        Polynomial polynomial = new Polynomial(new double[]{1.0});
        chebyshevTList.add(polynomial);
        chebyshevUList.add(polynomial);
        polynomial = new Polynomial(new double[]{0.0, 1.0});
        chebyshevTList.add(polynomial);
        polynomial = new Polynomial(new double[]{0.0, 2.0});
        chebyshevUList.add(polynomial);
    }
}

