/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.RK4;

public class Adams4
extends RK4 {
    private double[] fn;
    private double[] fn1;
    private double[] fn2;
    private double[] fn3;
    private double[] temp_state;
    private double[] temp_rate;
    private int counter = 0;

    public Adams4(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.fn = new double[this.numEqn];
        this.fn1 = new double[this.numEqn];
        this.fn2 = new double[this.numEqn];
        this.fn3 = new double[this.numEqn];
        this.temp_state = new double[this.numEqn];
        this.temp_rate = new double[this.numEqn];
        this.counter = 0;
    }

    public double step() {
        double[] dArray = this.ode.getState();
        if (dArray == null) {
            return this.stepSize;
        }
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(dArray, this.fn);
        if (this.counter < 3) {
            this.stepSize = super.step();
            ++this.counter;
        } else {
            int n;
            for (n = 0; n < this.numEqn; ++n) {
                this.temp_state[n] = dArray[n] + this.stepSize * (55.0 * this.fn[n] - 59.0 * this.fn1[n] + 37.0 * this.fn2[n] - 9.0 * this.fn3[n]) / 24.0;
            }
            this.ode.getRate(this.temp_state, this.temp_rate);
            for (n = 0; n < this.numEqn; ++n) {
                dArray[n] = dArray[n] + this.stepSize * (9.0 * this.temp_rate[n] + 19.0 * this.fn[n] - 5.0 * this.fn1[n] + this.fn2[n]) / 24.0;
            }
        }
        System.arraycopy(this.fn2, 0, this.fn3, 0, this.numEqn);
        System.arraycopy(this.fn1, 0, this.fn2, 0, this.numEqn);
        System.arraycopy(this.fn, 0, this.fn1, 0, this.numEqn);
        return this.stepSize;
    }
}

