/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.gif.GifDecoder;

public class GifVideo
extends VideoAdapter {
    protected GifDecoder decoder;
    protected int[] startTimes;
    private Timer timer;
    private HashSet panels = new HashSet();

    public GifVideo(String string) throws IOException {
        this.load(string);
        this.createTimer();
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.panels.add(drawingPanel);
        super.draw(drawingPanel, graphics);
    }

    protected void finalize() {
    }

    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        if (!this.timer.isRunning()) {
            if (this.getFrameNumber() >= this.getEndFrameNumber()) {
                this.setFrameNumber(this.getStartFrameNumber());
            }
            this.timer.restart();
            this.support.firePropertyChange("playing", null, new Boolean(true));
        }
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.support.firePropertyChange("playing", null, new Boolean(false));
        }
    }

    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        n = this.getFrameNumber();
        int n2 = Math.min(n, this.decoder.getFrameCount() - 1);
        this.rawImage = this.decoder.getFrame(n2);
        this.isValidImage = false;
        this.isValidFilteredImage = false;
        this.support.firePropertyChange("framenumber", null, new Integer(n));
        Iterator iterator = this.panels.iterator();
        while (iterator.hasNext()) {
            DrawingPanel drawingPanel = (DrawingPanel)iterator.next();
            drawingPanel.repaint();
        }
    }

    public double getFrameTime(int n) {
        if (n >= this.startTimes.length || n < 0) {
            return -1.0;
        }
        return this.startTimes[n];
    }

    public double getTime() {
        return this.getFrameTime(this.getFrameNumber());
    }

    public void setTime(double d) {
        d = Math.abs(d);
        for (int i = 0; i < this.startTimes.length; ++i) {
            int n = this.startTimes[i];
            if (!(d < (double)n)) continue;
            this.setFrameNumber(i - 1);
            break;
        }
    }

    public double getStartTime() {
        return this.getFrameTime(this.getStartFrameNumber());
    }

    public void setStartTime(double d) {
        d = Math.abs(d);
        for (int i = 0; i < this.startTimes.length; ++i) {
            int n = this.startTimes[i];
            if (!(d < (double)n)) continue;
            this.setStartFrameNumber(i - 1);
            break;
        }
    }

    public double getEndTime() {
        int n = this.getEndFrameNumber();
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    public void setEndTime(double d) {
        d = Math.abs(d);
        d = Math.min(this.getDuration(), d);
        for (int i = 0; i < this.startTimes.length; ++i) {
            int n = this.startTimes[i];
            if (!(d < (double)n)) continue;
            this.setEndFrameNumber(i - 1);
            break;
        }
    }

    public double getDuration() {
        int n = this.getFrameCount() - 1;
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    protected void load(String string) throws IOException {
        this.decoder = new GifDecoder();
        int n = this.decoder.read(string);
        if (n == 2) {
            throw new IOException("Gif " + string + " not found");
        }
        if (n == 1) {
            throw new IOException("File format error");
        }
        this.setProperty("name", string);
        if (string.indexOf(":") == -1) {
            this.setProperty("path", XML.forwardSlash(string));
        } else {
            this.setProperty("path", XML.getRelativePath(string));
            this.setProperty("absolutePath", string);
        }
        this.frameCount = this.decoder.getFrameCount();
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.startTimes = new int[this.frameCount];
        this.startTimes[0] = 0;
        for (int i = 1; i < this.startTimes.length; ++i) {
            this.startTimes[i] = this.startTimes[i - 1] + this.decoder.getDelay(i - 1);
        }
        this.setImage(this.decoder.getFrame(0));
    }

    private void setImage(BufferedImage bufferedImage) {
        this.rawImage = bufferedImage;
        this.size = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private void createTimer() {
        int n = this.decoder.getDelay(0);
        this.timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GifVideo.this.getFrameNumber() < GifVideo.this.getEndFrameNumber()) {
                    int n = GifVideo.this.decoder.getDelay(GifVideo.this.getFrameNumber() + 1);
                    GifVideo.this.timer.setDelay((int)((double)n / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getFrameNumber() + 1);
                } else if (GifVideo.this.looping) {
                    int n = GifVideo.this.decoder.getDelay(GifVideo.this.getStartFrameNumber());
                    GifVideo.this.timer.setDelay((int)((double)n / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getStartFrameNumber());
                } else {
                    GifVideo.this.stop();
                }
            }
        });
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            GifVideo gifVideo = (GifVideo)object;
            xMLControl.setValue("path", gifVideo.getProperty("path"));
        }

        public Object createObject(XMLControl xMLControl) {
            try {
                GifVideo gifVideo = new GifVideo(xMLControl.getString("path"));
                return gifVideo;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            return object;
        }
    }
}

