/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.VideoClip;

public class TimerClipControl
extends ClipControl {
    private Timer timer;
    private double frameDuration = 100.0;

    protected TimerClipControl(VideoClip videoClip) {
        super(videoClip);
        videoClip.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("stepsize")) {
                    int n = (int)(TimerClipControl.this.frameDuration * (double)TimerClipControl.this.clip.getStepSize());
                    TimerClipControl.this.timer = new Timer(n, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if ((this).TimerClipControl.this.stepNumber < (this).TimerClipControl.this.clip.getStepCount() - 1) {
                                TimerClipControl.this.setStepNumber((this).TimerClipControl.this.stepNumber + 1);
                            } else if ((this).TimerClipControl.this.looping) {
                                TimerClipControl.this.setStepNumber(0);
                            } else {
                                TimerClipControl.this.stop();
                            }
                        }
                    });
                    TimerClipControl.this.timer.setInitialDelay(n);
                }
            }
        });
        if (this.video != null && this.video.getDuration() > 1.0) {
            double d = this.video.getFrameTime(this.video.getStartFrameNumber());
            double d2 = this.video.getFrameTime(this.video.getEndFrameNumber());
            int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (n != 0) {
                this.frameDuration = (int)(d2 - d) / n;
            }
        }
        int n = (int)(this.frameDuration * (double)this.clip.getStepSize());
        this.timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TimerClipControl.this.stepNumber < TimerClipControl.this.clip.getStepCount() - 1) {
                    TimerClipControl.this.setStepNumber(TimerClipControl.this.stepNumber + 1);
                } else if (TimerClipControl.this.looping) {
                    TimerClipControl.this.setStepNumber(0);
                } else {
                    TimerClipControl.this.stop();
                }
            }
        });
        this.timer.setInitialDelay(n);
    }

    public void play() {
        if (this.clip.getStepCount() == 1) {
            return;
        }
        if (!this.timer.isRunning()) {
            this.timer.restart();
            if (this.stepNumber == this.clip.getStepCount() - 1) {
                this.setStepNumber(0);
            }
            this.support.firePropertyChange("playing", null, new Boolean(true));
        }
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.support.firePropertyChange("playing", null, new Boolean(false));
        }
    }

    public void step() {
        this.stop();
        this.setStepNumber(this.stepNumber + 1);
    }

    public void back() {
        this.stop();
        this.setStepNumber(this.stepNumber - 1);
    }

    public void setStepNumber(int n) {
        if (n == this.stepNumber) {
            return;
        }
        n = Math.max(0, n);
        this.stepNumber = n = Math.min(this.clip.getStepCount() - 1, n);
        if (this.video != null) {
            this.video.setFrameNumber(this.clip.stepToFrame(n));
        }
        this.support.firePropertyChange("stepnumber", null, new Integer(n));
    }

    public void setRate(double d) {
        if (d == 0.0 || d == this.rate) {
            return;
        }
        this.rate = Math.abs(d);
        int n = (int)(this.frameDuration * (double)this.clip.getStepSize() / this.rate);
        this.timer.setDelay(n);
        this.timer.setInitialDelay(n);
        this.support.firePropertyChange("rate", null, new Double(this.rate));
    }

    public double getMeanFrameDuration() {
        return this.frameDuration;
    }

    public void setFrameDuration(double d) {
        if (d == 0.0 || d == this.frameDuration) {
            return;
        }
        this.frameDuration = Math.abs(d);
        int n = (int)(this.frameDuration * (double)this.clip.getStepSize() / this.rate);
        this.timer.setDelay(n);
        this.timer.setInitialDelay(n);
        this.support.firePropertyChange("frameduration", null, new Double(this.frameDuration));
    }

    public void setLooping(boolean bl) {
        if (bl == this.looping) {
            return;
        }
        this.looping = bl;
        this.support.firePropertyChange("looping", null, new Boolean(bl));
    }

    public boolean isPlaying() {
        return this.timer.isRunning();
    }

    public double getTime() {
        return (double)this.stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    public double getStepTime(int n) {
        return (double)n * this.frameDuration * (double)this.clip.getStepSize();
    }
}

