/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;

public class ThresholdFilter
extends Filter {
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixels;
    private int w;
    private int h;
    private Graphics2D gIn;
    private int threshold;
    private int defaultThreshold = 127;
    private Inspector inspector;
    private JLabel levelLabel;
    private IntegerField levelField;
    private JSlider levelSlider;

    public ThresholdFilter() {
        this.setThreshold(this.defaultThreshold);
        this.hasInspector = true;
    }

    public void setThreshold(int n) {
        Integer n2 = new Integer(this.threshold);
        this.threshold = n;
        this.support.firePropertyChange("threshold", n2, new Integer(n));
    }

    public int getThreshold() {
        return this.threshold;
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToThreshold(this.input);
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                ((Component)this.inspector).setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void refresh() {
        super.refresh();
        this.levelLabel.setText(MediaRes.getString("Filter.Threshold.Label.Threshold"));
        this.levelSlider.setToolTipText(MediaRes.getString("Filter.Threshold.ToolTip.Threshold"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Threshold.Title"));
            this.inspector.pack();
        }
        boolean bl = this.isEnabled();
        this.levelLabel.setEnabled(bl);
        this.levelSlider.setEnabled(bl);
        this.levelField.setEnabled(bl);
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.output = new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void setOutputToThreshold(BufferedImage bufferedImage) {
        bufferedImage.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0xFFFFFF;
        for (int i = 0; i < this.pixels.length; ++i) {
            int n2 = this.pixels[i];
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            int n6 = (n3 + n4 + n5) / 3;
            this.pixels[i] = n6 > this.threshold ? n : 0;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            ThresholdFilter thresholdFilter = (ThresholdFilter)object;
            xMLControl.setValue("threshold", thresholdFilter.getThreshold());
            if (thresholdFilter.frame != null && thresholdFilter.inspector != null && thresholdFilter.inspector.isVisible()) {
                int n = ((ThresholdFilter)thresholdFilter).inspector.getLocation().x - thresholdFilter.frame.getLocation().x;
                int n2 = ((ThresholdFilter)thresholdFilter).inspector.getLocation().y - thresholdFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new ThresholdFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ThresholdFilter thresholdFilter = (ThresholdFilter)object;
            if (xMLControl.getPropertyNames().contains("threshold")) {
                thresholdFilter.setThreshold(xMLControl.getInt("threshold"));
            }
            thresholdFilter.inspectorX = xMLControl.getInt("inspector_x");
            thresholdFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }

    private class Inspector
    extends JDialog {
        int prev;

        public Inspector() {
            super(ThresholdFilter.this.frame, !(ThresholdFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.Threshold.Title"));
            this.setResizable(false);
            this.createGUI();
            ThresholdFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            ((Component)this).setLocation(n, n2);
        }

        void createGUI() {
            ThresholdFilter.this.levelLabel = new JLabel();
            ThresholdFilter.this.levelField = new IntegerField(3);
            ThresholdFilter.this.levelField.setMaxValue(255);
            ThresholdFilter.this.levelField.setMinValue(0);
            ThresholdFilter.this.levelField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ThresholdFilter.this.setThreshold(ThresholdFilter.this.levelField.getValue());
                    Inspector.this.updateDisplay();
                    ThresholdFilter.this.levelField.selectAll();
                }
            });
            ThresholdFilter.this.levelField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ThresholdFilter.this.levelField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    ThresholdFilter.this.setThreshold(ThresholdFilter.this.levelField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            ThresholdFilter.this.levelSlider = new JSlider(0, 0, 0);
            ThresholdFilter.this.levelSlider.setMaximum(255);
            ThresholdFilter.this.levelSlider.setMinimum(0);
            ThresholdFilter.this.levelSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            ThresholdFilter.this.levelSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = ThresholdFilter.this.levelSlider.getValue();
                    if (n != ThresholdFilter.this.getThreshold()) {
                        ThresholdFilter.this.setThreshold(n);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            this.setContentPane(jPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(ThresholdFilter.this.levelLabel, gridBagConstraints);
            jPanel.add(ThresholdFilter.this.levelLabel);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(ThresholdFilter.this.levelField, gridBagConstraints);
            jPanel.add(ThresholdFilter.this.levelField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(ThresholdFilter.this.levelSlider, gridBagConstraints);
            jPanel.add(ThresholdFilter.this.levelSlider);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(ThresholdFilter.this.ableButton);
            jPanel2.add(ThresholdFilter.this.closeButton);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
        }

        void initialize() {
            this.prev = ThresholdFilter.this.getThreshold();
            this.updateDisplay();
        }

        void updateDisplay() {
            ThresholdFilter.this.levelField.setValue(ThresholdFilter.this.getThreshold());
            ThresholdFilter.this.levelSlider.setValue(ThresholdFilter.this.getThreshold());
        }

        void revert() {
            ThresholdFilter.this.setThreshold(this.prev);
            this.updateDisplay();
        }

        void reset() {
            ThresholdFilter.this.setThreshold(ThresholdFilter.this.defaultThreshold);
            this.updateDisplay();
        }
    }
}

