/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;

public class TShape
extends TPoint {
    protected static Rectangle hitRect = new Rectangle(0, 0, 8, 8);
    protected Color color = Color.black;
    protected boolean visible = true;
    protected Shape fillShape = hitRect;
    protected BasicStroke stroke = new BasicStroke();

    public TShape() {
    }

    public TShape(double d, double d2) {
        super(d, d2);
    }

    public TShape(Point2D point2D) {
        super(point2D);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStroke(BasicStroke basicStroke) {
        this.stroke = basicStroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public Rectangle getBounds(VideoPanel videoPanel) {
        return this.getShape(videoPanel).getBounds();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!(drawingPanel instanceof VideoPanel) || !this.isVisible()) {
            return;
        }
        VideoPanel videoPanel = (VideoPanel)drawingPanel;
        this.fillShape = this.getShape(videoPanel);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.color);
        graphics2D.fill(this.fillShape);
        graphics2D.setPaint(paint);
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof VideoPanel)) {
            return null;
        }
        VideoPanel videoPanel = (VideoPanel)drawingPanel;
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        this.setHitRectCenter(n, n2);
        if (hitRect.contains(this.getScreenPosition(videoPanel))) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "TShape [" + this.x + ", " + this.y + "]";
    }

    protected Shape getShape(VideoPanel videoPanel) {
        Point point = this.getScreenPosition(videoPanel);
        this.setHitRectCenter(point.x, point.y);
        if (this.stroke == null) {
            return (Rectangle)hitRect.clone();
        }
        return this.stroke.createStrokedShape(hitRect);
    }

    protected void setHitRectCenter(int n, int n2) {
        hitRect.setLocation(n - TShape.hitRect.width / 2, n2 - TShape.hitRect.height / 2);
    }
}

