/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VidCartesianCoordinateStringBuilder;
import org.opensourcephysics.media.core.VideoPanel;

public class TPoint
extends Point2D.Double
implements Interactive,
Trackable {
    public static boolean coordsVisibleInMouseBox = true;
    protected static VidCartesianCoordinateStringBuilder coordinateStrBuilder = new VidCartesianCoordinateStringBuilder();
    protected boolean enabled = true;
    protected boolean trackEditTrigger = false;
    protected boolean coordsEditTrigger = false;
    protected boolean stepEditTrigger = false;
    protected Point screenPt;
    protected Point2D worldPt;
    protected PropertyChangeSupport support;

    public TPoint() {
        this(0.0, 0.0);
    }

    public TPoint(double d, double d2) {
        super(d, d2);
    }

    public TPoint(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return null;
    }

    public void setX(double d) {
        this.setXY(d, this.getY());
    }

    public void setY(double d) {
        this.setXY(this.getX(), d);
    }

    public void setXY(double d, double d2) {
        this.setLocation(d, d2);
    }

    public void setLocation(double d, double d2) {
        if (this.getX() == d && this.getY() == d2) {
            return;
        }
        super.setLocation(d, d2);
        if (this.support != null) {
            this.support.firePropertyChange("location", null, null);
        }
    }

    public int getFrameNumber(VideoPanel videoPanel) {
        return videoPanel.getFrameNumber();
    }

    public Point getScreenPosition(VideoPanel videoPanel) {
        AffineTransform affineTransform = videoPanel.getPixelTransform();
        if (!videoPanel.isDrawingInImageSpace()) {
            int n = this.getFrameNumber(videoPanel);
            affineTransform.concatenate(videoPanel.getCoords().getToWorldTransform(n));
        }
        if (this.screenPt == null) {
            this.screenPt = new Point();
        }
        affineTransform.transform(this, this.screenPt);
        return this.screenPt;
    }

    public void setScreenPosition(int n, int n2, VideoPanel videoPanel) {
        if (this.screenPt == null) {
            this.screenPt = new Point();
        }
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.screenPt.setLocation(n, n2);
        AffineTransform affineTransform = videoPanel.getPixelTransform();
        if (!videoPanel.isDrawingInImageSpace()) {
            int n3 = this.getFrameNumber(videoPanel);
            affineTransform.concatenate(videoPanel.getCoords().getToWorldTransform(n3));
        }
        try {
            affineTransform.inverseTransform(this.screenPt, this.worldPt);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        this.setXY(this.worldPt.getX(), this.worldPt.getY());
    }

    public void setScreenPosition(int n, int n2, VideoPanel videoPanel, InputEvent inputEvent) {
        this.setScreenPosition(n, n2, videoPanel);
    }

    public Point2D getWorldPosition(VideoPanel videoPanel) {
        int n = this.getFrameNumber(videoPanel);
        AffineTransform affineTransform = videoPanel.getCoords().getToWorldTransform(n);
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        return affineTransform.transform(this, this.worldPt);
    }

    public void showCoordinates(VideoPanel videoPanel) {
        if (coordsVisibleInMouseBox) {
            this.getWorldPosition(videoPanel);
            String string = coordinateStrBuilder.getCoordinateString(this.worldPt.getX(), this.worldPt.getY());
            videoPanel.setMessage(string, 0);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setTrackEditTrigger(boolean bl) {
        this.trackEditTrigger = bl;
    }

    public boolean isTrackEditTrigger() {
        return this.trackEditTrigger;
    }

    public void setCoordsEditTrigger(boolean bl) {
        this.coordsEditTrigger = bl;
    }

    public boolean isCoordsEditTrigger() {
        return this.coordsEditTrigger;
    }

    public void setStepEditTrigger(boolean bl) {
        this.stepEditTrigger = bl;
    }

    public boolean isStepEditTrigger() {
        return this.stepEditTrigger;
    }

    public Rectangle getBounds(VideoPanel videoPanel) {
        return null;
    }

    public boolean isMeasured() {
        return false;
    }

    public double getXMin() {
        return this.getX();
    }

    public double getXMax() {
        return this.getX();
    }

    public double getYMin() {
        return this.getY();
    }

    public double getYMax() {
        return this.getY();
    }

    public double angle(double d, double d2) {
        return Math.atan2(d2 - this.getY(), d - this.getX());
    }

    public double angle(Point2D point2D) {
        return Math.atan2(point2D.getY() - this.getY(), point2D.getX() - this.getX());
    }

    public double sin(double d, double d2) {
        return (this.getY() - d2) / this.distance(d, d2);
    }

    public double sin(Point2D point2D) {
        return (this.getY() - point2D.getY()) / this.distance(point2D);
    }

    public double cos(double d, double d2) {
        return (d - this.getX()) / this.distance(d, d2);
    }

    public double cos(Point2D point2D) {
        return (point2D.getX() - this.getX()) / this.distance(point2D);
    }

    public void center(Point2D point2D, Point2D point2D2) {
        double d = (point2D.getX() + point2D2.getX()) / 2.0;
        double d2 = (point2D.getY() + point2D2.getY()) / 2.0;
        this.setLocation(d, d2);
    }

    public void translate(double d, double d2) {
        this.setXY(this.getX() + d, this.getY() + d2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            this.support = new SwingPropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.support == null) {
            this.support = new SwingPropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public String toString() {
        return "TPoint [" + this.x + ", " + this.y + "]";
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public void setPositionOnLine(int n, int n2, VideoPanel videoPanel, TPoint tPoint, TPoint tPoint2) {
        if (this.screenPt == null) {
            this.screenPt = new Point();
        }
        if (this.worldPt == null) {
            this.worldPt = new Point2D.Double();
        }
        this.screenPt.setLocation(n, n2);
        AffineTransform affineTransform = videoPanel.getPixelTransform();
        if (!videoPanel.isDrawingInImageSpace()) {
            int n3 = this.getFrameNumber(videoPanel);
            affineTransform.concatenate(videoPanel.getCoords().getToWorldTransform(n3));
        }
        try {
            affineTransform.inverseTransform(this.screenPt, this.worldPt);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        double d = tPoint2.getX() - tPoint.getX();
        double d2 = tPoint2.getY() - tPoint.getY();
        double d3 = ((this.worldPt.getX() - tPoint.getX()) * d + (this.worldPt.getY() - tPoint.getY()) * d2) / tPoint.distanceSq(tPoint2);
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        double d4 = tPoint.getX() + d3 * d;
        double d5 = tPoint.getY() + d3 * d2;
        this.setLocation(d4, d5);
    }
}

