/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TShape;
import org.opensourcephysics.media.core.VideoPanel;

public class TCoordAxes
extends TShape {
    protected VideoPanel vidPanel;
    protected GeneralPath axes = new GeneralPath();
    protected Origin origin = new Origin();
    protected boolean originEnabled = true;
    protected boolean xaxisEnabled = true;
    protected GeneralPath originShape = new GeneralPath();
    protected GeneralPath xaxis = new GeneralPath();

    public TCoordAxes(VideoPanel videoPanel) {
        this.vidPanel = videoPanel;
        this.setStroke(new BasicStroke(2.0f));
        this.setColor(new Color(153, 0, 0));
    }

    public TPoint getOrigin() {
        return this.origin;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (drawingPanel == this.vidPanel) {
            super.draw(drawingPanel, graphics);
        }
    }

    public void setXY(double d, double d2) {
        super.setXY(d, d2);
        double d3 = this.origin.cos(this);
        double d4 = this.origin.sin(this);
        int n = this.vidPanel.getFrameNumber();
        this.vidPanel.getCoords().setCosineSine(n, d3, d4);
    }

    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke != null) {
            this.stroke = basicStroke;
        }
    }

    public void setOriginEnabled(boolean bl) {
        this.originEnabled = bl;
    }

    public boolean isOriginEnabled() {
        return this.originEnabled;
    }

    public void setXAxisEnabled(boolean bl) {
        this.xaxisEnabled = bl;
    }

    public boolean isXAxisEnabled() {
        return this.xaxisEnabled;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (drawingPanel != this.vidPanel) {
            return null;
        }
        if (!this.isEnabled() || !this.isVisible()) {
            return null;
        }
        this.setHitRectCenter(n, n2);
        if (this.originEnabled && this.originShape.intersects(TShape.hitRect)) {
            return this.origin;
        }
        if (this.xaxisEnabled && this.xaxis.intersects(TShape.hitRect)) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "Coordinate axes";
    }

    protected Shape getShape(VideoPanel videoPanel) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        ImageCoordSystem imageCoordSystem = videoPanel.getCoords();
        int n = this.getFrameNumber(videoPanel);
        int n2 = videoPanel.getWidth();
        int n3 = videoPanel.getHeight();
        double d = Math.max(2 * n2, 2 * n3);
        double d2 = imageCoordSystem.getOriginX(n);
        double d3 = imageCoordSystem.getOriginY(n);
        this.origin.setLocation(d2, d3);
        double d4 = imageCoordSystem.getSine(n);
        double d5 = imageCoordSystem.getCosine(n);
        if (videoPanel.isDrawingInImageSpace()) {
            f6 = videoPanel.xToPix(d2);
            f5 = videoPanel.yToPix(d3);
            f4 = (float)(d * d5);
            f3 = (float)(d * d4);
            f2 = (float)(3.0 * d5);
            f = (float)(3.0 * d4);
        } else {
            f6 = videoPanel.xToPix(imageCoordSystem.imageToWorldX(n, d2, d3));
            f5 = videoPanel.yToPix(imageCoordSystem.imageToWorldY(n, d2, d3));
            f4 = (float)d;
            f3 = 0.0f;
            f2 = 3.0f;
            f = 0.0f;
        }
        this.axes.reset();
        this.axes.moveTo(f6 - f4, f5 + f3);
        this.axes.lineTo(f6 + f4, f5 - f3);
        this.axes.moveTo(f6 - f3, f5 - f4);
        this.axes.lineTo(f6 + f3, f5 + f4);
        this.axes.moveTo(f6 + 5.0f * f2 - f, f5 - 5.0f * f - f2);
        this.axes.lineTo(f6 + 5.0f * f2 + f, f5 - 5.0f * f + f2);
        this.originShape.reset();
        this.originShape.moveTo(f6 - 3.0f * f2, f5 + 3.0f * f);
        this.originShape.lineTo(f6 + 3.0f * f2, f5 - 3.0f * f);
        this.originShape.moveTo(f6 - 3.0f * f, f5 - 3.0f * f2);
        this.originShape.lineTo(f6 + 3.0f * f, f5 + 3.0f * f2);
        this.xaxis.reset();
        this.xaxis.moveTo(f6 + 5.0f * f2, f5 - 5.0f * f);
        this.xaxis.lineTo(f6 + f4, f5 - f3);
        return this.stroke.createStrokedShape(this.axes);
    }

    private class Origin
    extends TPoint {
        private Origin() {
        }

        public void setXY(double d, double d2) {
            super.setXY(d, d2);
            int n = this.getFrameNumber(TCoordAxes.this.vidPanel);
            TCoordAxes.this.vidPanel.getCoords().setOriginXY(n, d, d2);
        }
    }
}

