/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;

public class SumFilter
extends Filter {
    protected int[] pixels;
    protected int[] rsums;
    protected int[] gsums;
    protected int[] bsums;
    private int w;
    private int h;
    private int imageCount = 1;
    private double brightness = 1.0;
    private BufferedImage input;
    private BufferedImage output;
    private BufferedImage source;
    private Graphics2D gIn;
    private boolean mean;
    private boolean skipSum = true;
    private Inspector inspector;
    private JLabel percentLabel;
    private DecimalField percentField;
    private JSlider percentSlider;
    private JCheckBox showMeanCheckBox;
    private JLabel frameCountLabel;
    private IntegerField frameCountField;

    public SumFilter() {
        this.hasInspector = true;
    }

    public void setBrightness(double d) {
        if (d != this.brightness) {
            this.brightness = Math.abs(d);
            this.support.firePropertyChange("brightness", null, null);
        }
    }

    public void setMean(boolean bl) {
        if (this.mean != bl) {
            this.mean = bl;
            this.refresh();
            this.support.firePropertyChange("mean", null, null);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.refresh();
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        if (!this.skipSum) {
            this.addPixels();
            this.skipSum = true;
        }
        this.setOutputPixels();
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                ((Component)this.inspector).setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void clear() {
        if (this.source != null) {
            this.initialize(this.source);
            this.brightness = 1.0;
            this.skipSum = true;
            this.support.firePropertyChange("reset", null, null);
        }
    }

    public void refresh() {
        super.refresh();
        this.percentLabel.setText(MediaRes.getString("Filter.Sum.Label.Percent"));
        this.percentField.setToolTipText(MediaRes.getString("Filter.Sum.ToolTip.Percent"));
        this.percentSlider.setToolTipText(MediaRes.getString("Filter.Sum.ToolTip.Percent"));
        this.showMeanCheckBox.setText(MediaRes.getString("Filter.Sum.CheckBox.ShowMean"));
        this.frameCountLabel.setText(MediaRes.getString("Filter.Sum.Label.FrameCount"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Sum.Title"));
            this.inspector.pack();
        }
        boolean bl = this.isEnabled();
        this.showMeanCheckBox.setEnabled(bl);
        this.frameCountLabel.setEnabled(bl);
        this.frameCountField.setEnabled(bl);
        this.percentLabel.setEnabled(bl && !this.mean);
        this.percentField.setEnabled(bl && !this.mean);
        this.percentSlider.setEnabled(bl && !this.mean);
        this.frameCountField.setValue(this.imageCount);
        if (this.mean) {
            this.percentField.setValue(100.0 / (double)this.imageCount);
            this.percentSlider.setValue(Math.round(100.0f / (float)this.imageCount));
        } else {
            this.percentField.setValue(this.brightness * 100.0);
            this.percentSlider.setValue(Math.round((float)this.brightness * 100.0f));
        }
    }

    public void addNextImage() {
        this.skipSum = false;
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.rsums = new int[this.w * this.h];
        this.gsums = new int[this.w * this.h];
        this.bsums = new int[this.w * this.h];
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
        this.output = new BufferedImage(this.w, this.h, 1);
        this.output.createGraphics().drawImage((Image)this.source, 0, 0, null);
        this.imageCount = 0;
        this.addPixels();
    }

    private void addPixels() {
        ++this.imageCount;
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        int n = 0;
        while (n < this.pixels.length) {
            int n2 = this.pixels[n];
            int n3 = n;
            this.rsums[n3] = this.rsums[n3] + (n2 >> 16 & 0xFF);
            int n4 = n;
            this.gsums[n4] = this.gsums[n4] + (n2 >> 8 & 0xFF);
            int n5 = n++;
            this.bsums[n5] = this.bsums[n5] + (n2 & 0xFF);
        }
        if (this.inspector != null && this.inspector.isVisible()) {
            this.refresh();
        }
    }

    private void setOutputPixels() {
        double d = this.mean ? 1.0 / (double)this.imageCount : this.brightness;
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = (int)Math.min((double)this.rsums[i] * d, 255.0);
            int n2 = (int)Math.min((double)this.gsums[i] * d, 255.0);
            int n3 = (int)Math.min((double)this.bsums[i] * d, 255.0);
            this.pixels[i] = n << 16 | n2 << 8 | n3;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
        if (this.mean && this.inspector != null) {
            this.refresh();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            SumFilter sumFilter = (SumFilter)object;
            if (sumFilter.frame != null && sumFilter.inspector != null && sumFilter.inspector.isVisible()) {
                int n = ((SumFilter)sumFilter).inspector.getLocation().x - sumFilter.frame.getLocation().x;
                int n2 = ((SumFilter)sumFilter).inspector.getLocation().y - sumFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new SumFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            SumFilter sumFilter = (SumFilter)object;
            sumFilter.inspectorX = xMLControl.getInt("inspector_x");
            sumFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(SumFilter.this.frame, !(SumFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.Sum.Title"));
            this.setResizable(false);
            this.createGUI();
            SumFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            ((Component)this).setLocation(n, n2);
        }

        void createGUI() {
            SumFilter.this.percentLabel = new JLabel();
            SumFilter.this.percentLabel.setHorizontalAlignment(11);
            SumFilter.this.percentField = new DecimalField(3, 1);
            SumFilter.this.percentField.setMaxValue(100.0);
            SumFilter.this.percentField.setMinValue(0.0);
            SumFilter.this.percentField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SumFilter.this.setBrightness(SumFilter.this.percentField.getValue() / 100.0);
                    SumFilter.this.refresh();
                    SumFilter.this.percentField.selectAll();
                }
            });
            SumFilter.this.percentField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    SumFilter.this.percentField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    SumFilter.this.setBrightness(SumFilter.this.percentField.getValue() / 100.0);
                    SumFilter.this.refresh();
                }
            });
            SumFilter.this.percentSlider = new JSlider(0, 100, 100);
            SumFilter.this.percentSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (SumFilter.this.percentSlider.isEnabled() && SumFilter.this.percentSlider.getValue() != Math.round((float)SumFilter.this.brightness * 100.0f)) {
                        SumFilter.this.setBrightness((double)SumFilter.this.percentSlider.getValue() / 100.0);
                        SumFilter.this.refresh();
                    }
                }
            });
            SumFilter.this.showMeanCheckBox = new JCheckBox();
            SumFilter.this.showMeanCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SumFilter.this.setMean(SumFilter.this.showMeanCheckBox.isSelected());
                    SumFilter.this.refresh();
                }
            });
            SumFilter.this.frameCountLabel = new JLabel();
            SumFilter.this.frameCountLabel.setHorizontalAlignment(11);
            SumFilter.this.frameCountField = new IntegerField(3);
            SumFilter.this.frameCountField.setEditable(false);
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel2 = new JPanel(gridBagLayout);
            jPanel.add((Component)jPanel2, "Center");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 2);
            gridBagLayout.setConstraints(SumFilter.this.percentLabel, gridBagConstraints);
            jPanel2.add(SumFilter.this.percentLabel);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagLayout.setConstraints(SumFilter.this.percentField, gridBagConstraints);
            jPanel2.add(SumFilter.this.percentField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagLayout.setConstraints(SumFilter.this.percentSlider, gridBagConstraints);
            jPanel2.add(SumFilter.this.percentSlider);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 2);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(SumFilter.this.frameCountLabel, gridBagConstraints);
            jPanel2.add(SumFilter.this.frameCountLabel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(SumFilter.this.frameCountField, gridBagConstraints);
            jPanel2.add(SumFilter.this.frameCountField);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            gridBagLayout.setConstraints(SumFilter.this.showMeanCheckBox, gridBagConstraints);
            jPanel2.add(SumFilter.this.showMeanCheckBox);
            JPanel jPanel3 = new JPanel(new FlowLayout());
            jPanel3.add(SumFilter.this.ableButton);
            jPanel3.add(SumFilter.this.clearButton);
            jPanel3.add(SumFilter.this.closeButton);
            jPanel.add((Component)jPanel3, "South");
        }

        void initialize() {
            SumFilter.this.showMeanCheckBox.setSelected(SumFilter.this.mean);
            SumFilter.this.refresh();
        }
    }
}

