/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Dimension;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;

public abstract class ScratchVideoRecorder
implements VideoRecorder {
    protected static JFileChooser chooser;
    protected VideoType videoType;
    protected Dimension dim;
    protected Image frameImage;
    protected double frameDuration = 100.0;
    protected int frameCount;
    protected String scratchName;
    protected int scratchNumber = 0;
    protected File scratchFile;
    protected boolean canRecord;
    protected boolean hasContent;
    protected boolean isSaved;
    protected File saveFile = null;
    protected boolean saveChanges = false;

    public ScratchVideoRecorder(VideoType videoType) {
        this.videoType = videoType;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("_yyMMdd_HHmmss_");
        String string = simpleDateFormat.format(date);
        this.scratchName = "scratch" + string;
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            this.createScratch();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void createVideo() throws IOException {
        if (this.scratchFile == null) {
            this.createScratch();
            if (this.scratchFile == null) {
                OSPLog.severe("No scratch file");
                return;
            }
        }
        if (this.scratchFile != null && this.hasContent) {
            String string;
            int n;
            if (this.saveChanges && !this.isSaved && (n = JOptionPane.showConfirmDialog(null, string = MediaRes.getString("ScratchVideoRecorder.Dialog.SaveVideo.Message"), MediaRes.getString("ScratchVideoRecorder.Dialog.SaveVideo.Title"), 0)) == 0) {
                this.saveVideo();
            }
            this.createScratch();
            this.saveFile = null;
            this.dim = null;
        }
    }

    public void createVideo(String string) throws IOException {
        this.createVideo();
        File file = new File(string);
        if (file.exists() && !file.canWrite()) {
            this.saveFile = null;
            throw new IOException("Read-only file");
        }
        this.saveFile = file;
    }

    public void createVideo(String string, int n, int n2) throws IOException {
        this.createVideo(string);
        if (n > 0 && n2 > 0) {
            this.dim = new Dimension(n, n2);
        }
    }

    public void setFrameDuration(double d) {
        this.frameDuration = d;
    }

    public void addFrame(Image image) throws IOException {
        if (image == null) {
            return;
        }
        this.frameImage = image;
        if (this.scratchFile == null || this.hasContent && this.isSaved) {
            this.createVideo();
        }
        if (this.scratchFile == null) {
            return;
        }
        if (!this.canRecord) {
            this.canRecord = this.startRecording();
            this.isSaved = false;
            this.hasContent = false;
        }
        if (this.canRecord && this.append(image)) {
            this.hasContent = true;
            ++this.frameCount;
        }
    }

    public Video getVideo() throws IOException {
        this.saveScratch();
        return this.videoType.getVideo(this.scratchFile.getAbsolutePath());
    }

    public String saveVideo() throws IOException {
        if (this.saveFile != null) {
            return this.saveVideo(this.saveFile.getAbsolutePath());
        }
        return this.saveVideoAs();
    }

    public String saveVideo(String string) throws IOException {
        if (this.scratchFile == null) {
            return null;
        }
        if (string == null) {
            return this.saveVideoAs();
        }
        this.setFileName(string);
        if (this.saveFile == null) {
            return null;
        }
        this.saveScratch();
        int n = 2048;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        FileInputStream fileInputStream = new FileInputStream(this.scratchFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(this.saveFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        while ((n2 = ((InputStream)bufferedInputStream).read(byArray, 0, n)) != -1) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
            n3 += n2;
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
        ((InputStream)bufferedInputStream).close();
        this.isSaved = true;
        OSPLog.fine("copied " + n3 + " bytes from " + this.scratchFile.getName() + " to " + this.saveFile.getAbsolutePath());
        this.scratchFile.delete();
        return this.saveFile.getAbsolutePath();
    }

    public String saveVideoAs() throws IOException {
        File file = this.selectFile();
        if (file != null) {
            return this.saveVideo(file.getAbsolutePath());
        }
        return null;
    }

    public String getFileName() {
        return this.saveFile == null ? null : this.saveFile.getAbsolutePath();
    }

    public void setFileName(String string) {
        if (this.saveFile != null && this.saveFile.getAbsolutePath().equals(string)) {
            return;
        }
        File file = new File(string);
        this.saveFile = file.exists() && !file.canWrite() ? null : file;
    }

    protected void createScratch() throws IOException {
        if (this.hasContent || this.scratchFile == null) {
            if (this.scratchFile != null) {
                this.saveScratch();
                this.scratchFile.delete();
            }
            this.scratchFile = new File(this.scratchName + this.scratchNumber + "." + this.videoType.getDefaultExtension());
            ++this.scratchNumber;
            this.hasContent = false;
            this.canRecord = false;
            OSPLog.finest(this.scratchFile.getAbsolutePath());
        }
    }

    protected File selectFile() {
        int n;
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        File file = null;
        chooser.setDialogTitle("VideoIO.Dialog.SaveAs.Title");
        String string = MediaRes.getString("VideoIO.FileName.Untitled");
        string = string + "." + this.videoType.getDefaultExtension();
        chooser.setSelectedFile(new File(string));
        int n2 = chooser.showDialog(null, MediaRes.getString("Dialog.Button.Save"));
        if (n2 == 0 && (file = chooser.getSelectedFile()).exists() && (n = JOptionPane.showConfirmDialog(null, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 1)) == 0) {
            return file;
        }
        return file;
    }

    protected abstract void saveScratch() throws IOException;

    protected abstract boolean startRecording();

    protected abstract boolean append(Image var1);

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            if (ScratchVideoRecorder.this.scratchFile != null) {
                try {
                    ScratchVideoRecorder.this.saveScratch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ScratchVideoRecorder.this.scratchFile.deleteOnExit();
            }
        }
    }
}

