/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.text.DecimalFormat;
import org.opensourcephysics.media.core.NumberField;

public class ScientificField
extends NumberField {
    private String[] patterns = new String[]{"0.0E0", "00.0E0", "000.0E0", "0000.0E0"};
    private double[] ranges = new double[4];
    private boolean fixedPattern = true;
    private int currentPatternIndex = 0;
    private double zeroLimit = 1.0E-10;

    public ScientificField(int n) {
        this(n, 0.1);
    }

    public ScientificField(int n, double d) {
        super(n);
        this.setResolution(d);
    }

    public void setValue(double d) {
        if (Math.abs(d) < this.zeroLimit) {
            d = 0.0;
        }
        super.setValue(d);
    }

    public void setResolution(double d) {
        if (this.format instanceof DecimalFormat) {
            this.fixedPattern = true;
            ((DecimalFormat)this.format).applyPattern("0.000E0");
        }
    }

    public void setFormatFor(double d) {
        if (this.fixedPattern) {
            return;
        }
        d = Math.abs(d);
        for (int i = 0; i < this.ranges.length; ++i) {
            if (!(d < this.ranges[i])) continue;
            if (i != this.currentPatternIndex) {
                this.currentPatternIndex = i;
                if (this.format instanceof DecimalFormat) {
                    ((DecimalFormat)this.format).applyPattern(this.getPattern());
                }
            }
            return;
        }
    }

    protected String getPattern() {
        return this.patterns[this.currentPatternIndex];
    }
}

