/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import org.opensourcephysics.media.core.Filter;

public class NegativeFilter
extends Filter {
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixels;
    private int w;
    private int h;
    private Graphics2D gIn;

    public NegativeFilter() {
        this.refresh();
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToNegative(this.input);
        return this.output;
    }

    public JDialog getInspector() {
        return null;
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.output = new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void setOutputToNegative(BufferedImage bufferedImage) {
        bufferedImage.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = this.pixels[i];
            int n2 = 255 - (n >> 16 & 0xFF);
            int n3 = 255 - (n >> 8 & 0xFF);
            int n4 = 255 - (n & 0xFF);
            this.pixels[i] = n2 << 16 | n3 << 8 | n4;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }
}

