/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ImageVideo
extends VideoAdapter {
    protected Component observer = new JPanel();
    protected Image[] images = new Image[0];
    protected ArrayList paths = new ArrayList();
    protected ArrayList newPaths = new ArrayList();
    protected Dimension dim = new Dimension(0, 0);

    public ImageVideo(String string) throws IOException {
        this.append(string);
    }

    public ImageVideo(String string, boolean bl) throws IOException {
        this.append(string, bl);
    }

    public ImageVideo(Image image) {
        if (image != null) {
            this.insert(new Image[]{image}, 0);
        }
    }

    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        int n2 = Math.min(this.getFrameNumber(), this.images.length - 1);
        this.rawImage = this.images[n2];
        this.isValidImage = false;
        this.isValidFilteredImage = false;
        this.firePropertyChange("framenumber", null, new Integer(this.getFrameNumber()));
    }

    public Image[] getImages() {
        return this.images;
    }

    public void append(String string) throws IOException {
        this.insert(string, this.images.length);
    }

    public void append(String string, boolean bl) throws IOException {
        this.insert(string, this.images.length, bl);
    }

    public void insert(String string, int n) throws IOException {
        Image[] imageArray = this.loadImages(string, true, true);
        if (imageArray.length > 0) {
            this.insert(imageArray, n);
        }
    }

    public void insert(String string, int n, boolean bl) throws IOException {
        Image[] imageArray = this.loadImages(string, false, bl);
        if (imageArray.length > 0) {
            this.insert(imageArray, n);
        }
    }

    public void insert(Image image, int n) {
        if (image == null) {
            return;
        }
        this.insert(new Image[]{image}, n);
    }

    public String remove(int n) {
        int n2 = this.images.length;
        if (n2 == 1 || n2 <= n) {
            return null;
        }
        Image[] imageArray = new Image[n2 - 1];
        System.arraycopy(this.images, 0, imageArray, 0, n);
        System.arraycopy(this.images, n + 1, imageArray, n, n2 - 1 - n);
        this.images = imageArray;
        this.rawImage = n < n2 - 1 ? this.images[n] : this.images[n - 1];
        this.frameCount = this.images.length;
        this.endFrameNumber = this.frameCount - 1;
        Dimension dimension = this.getDimension();
        if (dimension.height != this.dim.height || dimension.width != this.dim.width) {
            this.firePropertyChange("size", this.dim, dimension);
            this.dim = dimension;
        }
        if (this.paths.size() <= n) {
            return null;
        }
        return (String)this.paths.remove(n);
    }

    public Dimension getDimension() {
        int n = this.images[0].getWidth(this.observer);
        int n2 = this.images[0].getHeight(this.observer);
        for (int i = 1; i < this.images.length; ++i) {
            n = Math.max(n, this.images[i].getWidth(this.observer));
            n2 = Math.max(n2, this.images[i].getHeight(this.observer));
        }
        return new Dimension(n, n2);
    }

    protected void finalize() {
    }

    private Image[] loadImages(String string, boolean bl, boolean bl2) throws IOException {
        int n;
        this.newPaths.clear();
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            throw new IOException("Image " + string + " not found");
        }
        Image image = resource.getImage();
        if (image == null) {
            throw new IOException("\"" + string + "\" is not an image");
        }
        if (this.getProperty("name") == null) {
            this.setProperty("name", XML.getRelativePath(string));
            this.setProperty("path", string);
            this.setProperty("absolutepath", resource.getAbsolutePath());
        }
        this.newPaths.add(XML.getRelativePath(string));
        if (!bl && !bl2) {
            return new Image[]{image};
        }
        String string2 = "";
        int n2 = string.lastIndexOf(46);
        if (n2 > 0 && n2 < string.length() - 1) {
            string2 = string.substring(n2).toLowerCase();
            string = string.substring(0, n2);
        }
        int n3 = string.length();
        int n4 = 0;
        for (n = 1; n < n3; ++n) {
            try {
                n4 = Integer.parseInt(string.substring(n3 - n));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
        }
        if (--n == 0) {
            return new Image[]{image};
        }
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(image);
        int n5 = 10;
        n = Math.min(n, 4);
        switch (n) {
            case 1: {
                n5 = 10;
                break;
            }
            case 2: {
                n5 = 100;
                break;
            }
            case 3: {
                n5 = 1000;
                break;
            }
            case 4: {
                n5 = 10000;
            }
        }
        String string3 = string.substring(0, n3 - n);
        try {
            boolean bl3 = false;
            while (n4 < n5 - 1) {
                String string4 = String.valueOf(++n4);
                int n6 = n - string4.length();
                for (int i = 0; i < n6; ++i) {
                    string4 = "0" + string4;
                }
                string = string3 + string4 + string2;
                image = ResourceLoader.getImage(string);
                if (image == null) break;
                if (!bl3 && bl) {
                    bl3 = true;
                    String string5 = (String)this.getProperty("name");
                    string5 = XML.getName(string);
                    int n7 = JOptionPane.showOptionDialog(null, string5 + " " + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Message") + XML.NEW_LINE + MediaRes.getString("ImageVideo.Dialog.LoadSequence.Query"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Title"), 0, 3, null, new String[]{MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.SingleImage"), MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages")}, MediaRes.getString("ImageVideo.Dialog.LoadSequence.Button.AllImages"));
                    if (n7 == 0) break;
                }
                this.newPaths.add(XML.getRelativePath(string));
                arrayList.add(image);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return arrayList.toArray(new Image[0]);
    }

    protected void insert(Image[] imageArray, int n) {
        int n2 = this.images.length;
        n = Math.min(n, n2);
        this.paths.addAll(Math.min(this.paths.size(), n), this.newPaths);
        this.newPaths.clear();
        int n3 = imageArray.length;
        Image[] imageArray2 = new Image[n2 + n3];
        System.arraycopy(this.images, 0, imageArray2, 0, n);
        System.arraycopy(imageArray, 0, imageArray2, n, n3);
        System.arraycopy(this.images, n, imageArray2, n + n3, n2 - n);
        this.images = imageArray2;
        this.rawImage = this.images[n];
        this.frameCount = this.images.length;
        this.endFrameNumber = this.frameCount - 1;
        if (this.coords == null) {
            this.size = new Dimension(this.rawImage.getWidth(this.observer), this.rawImage.getHeight(this.observer));
            this.bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
            this.coords = new ImageCoordSystem(this.frameCount);
            this.coords.addPropertyChangeListener(this);
            this.aspects = new DoubleArray(this.frameCount, 1.0);
        } else {
            this.coords.setLength(this.frameCount);
            this.aspects.setLength(this.frameCount);
        }
        Dimension dimension = this.getDimension();
        if (dimension.height != this.dim.height || dimension.width != this.dim.width) {
            this.firePropertyChange("size", this.dim, dimension);
            this.dim = dimension;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            ImageVideo imageVideo = (ImageVideo)object;
            String[] stringArray = imageVideo.paths.toArray(new String[0]);
            if (stringArray.length > 0) {
                xMLControl.setValue("paths", stringArray);
            }
            if (!imageVideo.getFilterStack().isEmpty()) {
                xMLControl.setValue("filters", imageVideo.getFilterStack().getFilters());
            }
        }

        public Object createObject(XMLControl xMLControl) {
            Object object;
            String[] stringArray = (String[])xMLControl.getObject("paths");
            if (stringArray == null) {
                try {
                    object = xMLControl.getString("path");
                    boolean bl = xMLControl.getBoolean("sequence");
                    if (object != null) {
                        ImageVideo imageVideo = new ImageVideo((String)object, bl);
                        return imageVideo;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            if ((object = (Object)((boolean[])xMLControl.getObject("sequences"))) != null) {
                try {
                    ImageVideo imageVideo = new ImageVideo(stringArray[0], (boolean)object[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        imageVideo.append(stringArray[i], (boolean)object[i]);
                    }
                    return imageVideo;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            try {
                if (stringArray.length == 0) {
                    return null;
                }
                ImageVideo imageVideo = new ImageVideo(stringArray[0], false);
                for (int i = 1; i < stringArray.length; ++i) {
                    imageVideo.append(stringArray[i], false);
                }
                imageVideo.rawImage = imageVideo.images[0];
                Collection collection = (Collection)xMLControl.getObject("filters");
                if (collection != null) {
                    imageVideo.getFilterStack().clear();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Filter filter = (Filter)iterator.next();
                        imageVideo.getFilterStack().addFilter(filter);
                    }
                }
                return imageVideo;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            return object;
        }
    }
}

