/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JDialog;
import org.opensourcephysics.media.core.Filter;

public class FilterStack
extends Filter
implements PropertyChangeListener {
    private ArrayList filters = new ArrayList();
    private Filter postFilter;
    private int indexRemoved = -1;

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, filter);
    }

    public void insertFilter(Filter filter, int n) {
        n = Math.min(n, this.filters.size());
        n = Math.max(n, 0);
        this.filters.add(n, filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, filter);
    }

    public int lastIndexRemoved() {
        return this.indexRemoved;
    }

    public void setPostFilter(Filter filter) {
        if (this.postFilter != null) {
            this.postFilter.removePropertyChangeListener(this);
        }
        this.postFilter = filter;
        if (filter != null) {
            filter.addPropertyChangeListener(this);
            this.support.firePropertyChange("image", null, null);
            this.support.firePropertyChange("filter", null, filter);
        }
    }

    public Filter getPostFilter() {
        return this.postFilter;
    }

    public Filter getFilter(Class clazz) {
        Iterator iterator = ((AbstractList)this.filters).iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (filter.getClass() != clazz) continue;
            return filter;
        }
        return null;
    }

    public void removeFilter(Filter filter) {
        this.indexRemoved = this.filters.indexOf(filter);
        if (this.indexRemoved > -1) {
            ((AbstractCollection)this.filters).remove(filter);
            filter.stack = null;
            filter.removePropertyChangeListener(this);
            this.support.firePropertyChange("image", null, null);
            this.support.firePropertyChange("filter", filter, null);
        }
    }

    public void clear() {
        Iterator iterator = ((AbstractList)this.filters).iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            filter.stack = null;
            filter.removePropertyChangeListener(this);
        }
        this.filters.clear();
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, null);
    }

    public boolean isEmpty() {
        return this.filters.isEmpty() && this.postFilter == null;
    }

    public Collection getFilters() {
        return (Collection)this.filters.clone();
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        Iterator iterator = ((AbstractList)this.filters).iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            bufferedImage = filter.getFilteredImage(bufferedImage);
        }
        if (this.postFilter != null) {
            bufferedImage = this.postFilter.getFilteredImage(bufferedImage);
        }
        return bufferedImage;
    }

    public JDialog getInspector() {
        return null;
    }

    public void setInspectorsVisible(boolean bl) {
        Collection collection = this.getFilters();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            JDialog jDialog = filter.getInspector();
            if (jDialog == null) continue;
            if (!bl) {
                filter.inspectorVisible = jDialog.isVisible();
                ((Component)jDialog).setVisible(false);
                continue;
            }
            if (jDialog.isModal()) continue;
            ((Component)jDialog).setVisible(filter.inspectorVisible);
            filter.inspectorVisible = false;
        }
    }

    public void refresh() {
        Iterator iterator = this.getFilters().iterator();
        while (iterator.hasNext()) {
            ((Filter)iterator.next()).refresh();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.support.firePropertyChange("image", null, null);
    }
}

