/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;

public class BrightnessFilter
extends Filter {
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private int[] pixels;
    private int w;
    private int h;
    private Graphics2D gIn;
    private int defaultBrightness = 0;
    private double defaultContrast = 50.0;
    private int brightness;
    private double contrast;
    private double slope;
    private double offset1;
    private double offset2;
    private Inspector inspector;
    private int prevBrightness;
    private double prevContrast;
    private JLabel brightnessLabel;
    private IntegerField brightnessField;
    private JSlider brightnessSlider;
    private JLabel contrastLabel;
    private NumberField contrastField;
    private JSlider contrastSlider;

    public BrightnessFilter() {
        this.setBrightness(this.defaultBrightness);
        this.setContrast(this.defaultContrast);
        this.hasInspector = true;
    }

    public void setContrast(double d) {
        Double d2 = new Double(this.contrast);
        this.contrast = d;
        this.updateFactors();
        this.support.firePropertyChange("contrast", d2, new Double(d));
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setBrightness(int n) {
        Integer n2 = new Integer(this.brightness);
        this.brightness = n;
        this.updateFactors();
        this.support.firePropertyChange("brightness", n2, new Integer(n));
    }

    public int getBrightness() {
        return this.brightness;
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.setOutputToBright();
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                ((Component)this.inspector).setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void clear() {
        this.setBrightness(this.defaultBrightness);
        this.setContrast(this.defaultContrast);
        if (this.inspector != null) {
            this.inspector.updateDisplay();
        }
    }

    public void refresh() {
        super.refresh();
        this.brightnessLabel.setText(MediaRes.getString("Filter.Brightness.Label.Brightness"));
        this.brightnessSlider.setToolTipText(MediaRes.getString("Filter.Brightness.ToolTip.Brightness"));
        this.contrastLabel.setText(MediaRes.getString("Filter.Brightness.Label.Contrast"));
        this.contrastSlider.setToolTipText(MediaRes.getString("Filter.Brightness.ToolTip.Contrast"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Brightness.Title"));
            this.inspector.pack();
        }
        boolean bl = this.isEnabled();
        this.brightnessLabel.setEnabled(bl);
        this.brightnessSlider.setEnabled(bl);
        this.brightnessField.setEnabled(bl);
        this.contrastLabel.setEnabled(bl);
        this.contrastSlider.setEnabled(bl);
        this.contrastField.setEnabled(bl);
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.output = new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void setOutputToBright() {
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        for (int i = 0; i < this.pixels.length; ++i) {
            int n = this.pixels[i];
            int n2 = n >> 16 & 0xFF;
            n2 = Math.max((int)(this.slope * ((double)n2 + this.offset1) + this.offset2), 0);
            n2 = Math.min(n2, 255);
            int n3 = n >> 8 & 0xFF;
            n3 = Math.max((int)(this.slope * ((double)n3 + this.offset1) + this.offset2), 0);
            n3 = Math.min(n3, 255);
            int n4 = n & 0xFF;
            n4 = Math.max((int)(this.slope * ((double)n4 + this.offset1) + this.offset2), 0);
            n4 = Math.min(n4, 255);
            this.pixels[i] = n2 << 16 | n3 << 8 | n4;
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    private void updateFactors() {
        double d = Math.PI * this.contrast / 200.0;
        double d2 = Math.sin(d);
        this.offset1 = d2 * d2 * (double)this.brightness - 127.0;
        double d3 = Math.cos(d);
        this.offset2 = 127.0 + d3 * d3 * (double)this.brightness;
        this.slope = d2 / d3;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            BrightnessFilter brightnessFilter = (BrightnessFilter)object;
            xMLControl.setValue("brightness", brightnessFilter.getBrightness());
            xMLControl.setValue("contrast", brightnessFilter.getContrast());
            if (brightnessFilter.frame != null && brightnessFilter.inspector != null && brightnessFilter.inspector.isVisible()) {
                int n = ((BrightnessFilter)brightnessFilter).inspector.getLocation().x - brightnessFilter.frame.getLocation().x;
                int n2 = ((BrightnessFilter)brightnessFilter).inspector.getLocation().y - brightnessFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new BrightnessFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            BrightnessFilter brightnessFilter = (BrightnessFilter)object;
            if (xMLControl.getPropertyNames().contains("brightness")) {
                brightnessFilter.setBrightness(xMLControl.getInt("brightness"));
            }
            if (xMLControl.getPropertyNames().contains("contrast")) {
                brightnessFilter.setContrast(xMLControl.getDouble("contrast"));
            }
            brightnessFilter.inspectorX = xMLControl.getInt("inspector_x");
            brightnessFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(BrightnessFilter.this.frame, !(BrightnessFilter.this.frame instanceof OSPFrame));
            this.setResizable(false);
            this.createGUI();
            BrightnessFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            ((Component)this).setLocation(n, n2);
        }

        void createGUI() {
            int n;
            this.setTitle(MediaRes.getString("Filter.Brightness.Title"));
            BrightnessFilter.this.brightnessLabel = new JLabel();
            BrightnessFilter.this.brightnessField = new IntegerField(3);
            BrightnessFilter.this.brightnessField.setMaxValue(128);
            BrightnessFilter.this.brightnessField.setMinValue(-128);
            BrightnessFilter.this.brightnessField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrightnessFilter.this.setBrightness(BrightnessFilter.this.brightnessField.getValue());
                    Inspector.this.updateDisplay();
                    BrightnessFilter.this.brightnessField.selectAll();
                }
            });
            BrightnessFilter.this.brightnessField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    BrightnessFilter.this.brightnessField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    BrightnessFilter.this.setBrightness(BrightnessFilter.this.brightnessField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            BrightnessFilter.this.brightnessSlider = new JSlider(0, 0, 0);
            BrightnessFilter.this.brightnessSlider.setMaximum(128);
            BrightnessFilter.this.brightnessSlider.setMinimum(-128);
            BrightnessFilter.this.brightnessSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            BrightnessFilter.this.brightnessSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = BrightnessFilter.this.brightnessSlider.getValue();
                    if (n != BrightnessFilter.this.getBrightness()) {
                        BrightnessFilter.this.setBrightness(n);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            BrightnessFilter.this.contrastLabel = new JLabel();
            BrightnessFilter.this.contrastField = new DecimalField(4, 1);
            BrightnessFilter.this.contrastField.setMaxValue(100.0);
            BrightnessFilter.this.contrastField.setMinValue(0.0);
            BrightnessFilter.this.contrastField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrightnessFilter.this.setContrast(BrightnessFilter.this.contrastField.getValue());
                    Inspector.this.updateDisplay();
                    BrightnessFilter.this.contrastField.selectAll();
                }
            });
            BrightnessFilter.this.contrastField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    BrightnessFilter.this.contrastField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    BrightnessFilter.this.setContrast(BrightnessFilter.this.contrastField.getValue());
                    Inspector.this.updateDisplay();
                }
            });
            BrightnessFilter.this.contrastSlider = new JSlider(0, 0, 0);
            BrightnessFilter.this.contrastSlider.setMaximum(100);
            BrightnessFilter.this.contrastSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            BrightnessFilter.this.contrastSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = BrightnessFilter.this.contrastSlider.getValue();
                    if (n != (int)BrightnessFilter.this.getContrast()) {
                        BrightnessFilter.this.setContrast(n);
                        Inspector.this.updateDisplay();
                    }
                }
            });
            JLabel[] jLabelArray = new JLabel[]{BrightnessFilter.this.brightnessLabel, BrightnessFilter.this.contrastLabel};
            JTextField[] jTextFieldArray = new JTextField[]{BrightnessFilter.this.brightnessField, BrightnessFilter.this.contrastField};
            JSlider[] jSliderArray = new JSlider[]{BrightnessFilter.this.brightnessSlider, BrightnessFilter.this.contrastSlider};
            GridBagLayout gridBagLayout = new GridBagLayout();
            JPanel jPanel = new JPanel(gridBagLayout);
            this.setContentPane(jPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            for (n = 0; n < jLabelArray.length; ++n) {
                gridBagConstraints.gridy = n;
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.insets = new Insets(5, 5, 0, 0);
                gridBagLayout.setConstraints(jLabelArray[n], gridBagConstraints);
                jPanel.add(jLabelArray[n]);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                gridBagLayout.setConstraints(jTextFieldArray[n], gridBagConstraints);
                jPanel.add(jTextFieldArray[n]);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints(jSliderArray[n], gridBagConstraints);
                jPanel.add(jSliderArray[n]);
            }
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(BrightnessFilter.this.ableButton);
            jPanel2.add(BrightnessFilter.this.clearButton);
            jPanel2.add(BrightnessFilter.this.closeButton);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n + 1;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
        }

        void initialize() {
            BrightnessFilter.this.prevBrightness = BrightnessFilter.this.getBrightness();
            BrightnessFilter.this.prevContrast = BrightnessFilter.this.getContrast();
            this.updateDisplay();
        }

        void updateDisplay() {
            BrightnessFilter.this.brightnessField.setValue(BrightnessFilter.this.getBrightness());
            BrightnessFilter.this.contrastField.setValue(BrightnessFilter.this.getContrast());
            BrightnessFilter.this.brightnessSlider.setValue(BrightnessFilter.this.getBrightness());
            BrightnessFilter.this.contrastSlider.setValue((int)BrightnessFilter.this.getContrast());
        }

        void revert() {
            BrightnessFilter.this.setBrightness(BrightnessFilter.this.prevBrightness);
            BrightnessFilter.this.setContrast(BrightnessFilter.this.prevContrast);
            this.updateDisplay();
        }
    }
}

