/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.tools.ResourceLoader;

public class BaselineFilter
extends Filter {
    private BufferedImage source;
    private BufferedImage input;
    private BufferedImage output;
    private BufferedImage baseline;
    private int[] pixels;
    private int[] baselinePixels;
    private int w;
    private int h;
    private Graphics2D gIn;
    private Inspector inspector;
    private String imagePath;
    private JFileChooser chooser;
    private JButton loadButton;
    private JButton captureButton;

    public BaselineFilter() {
        this.hasInspector = true;
    }

    public void capture() {
        if (this.vidPanel == null || this.vidPanel.getVideo() == null) {
            return;
        }
        this.setBaselineImage(this.vidPanel.getVideo().getImage());
    }

    public void load(String string) {
        BufferedImage bufferedImage = ResourceLoader.getBufferedImage(string);
        if (bufferedImage != null) {
            this.imagePath = string;
            this.setBaselineImage(bufferedImage);
        } else {
            JOptionPane.showMessageDialog(this.vidPanel, "\"" + string + "\" " + MediaRes.getString("Filter.Baseline.Dialog.NotImage.Message"), MediaRes.getString("Filter.Baseline.Dialog.NotImage.Title"), 1);
        }
    }

    public void load() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        this.chooser.setDialogTitle("Open");
        int n = this.chooser.showOpenDialog(null);
        if (n == 0) {
            File file = this.chooser.getSelectedFile();
            this.load(file.getAbsolutePath());
        }
    }

    public void setBaselineImage(BufferedImage bufferedImage) {
        this.baseline = bufferedImage;
        if (bufferedImage != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (n >= this.w && n2 >= this.h) {
                bufferedImage.getRaster().getDataElements(0, 0, this.w, this.h, this.baselinePixels);
            } else {
                JOptionPane.showMessageDialog(this.vidPanel, MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Message1") + " (" + n + "x" + n2 + ") " + MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Message2") + " (" + this.w + "x" + this.h + ").", MediaRes.getString("Filter.Baseline.Dialog.SmallImage.Title"), 1);
            }
        }
        this.support.firePropertyChange("baseline", null, null);
    }

    public BufferedImage getBaselineImage() {
        return this.baseline;
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        if (bufferedImage != this.source) {
            this.initialize(bufferedImage);
        }
        if (bufferedImage != this.input) {
            this.gIn.drawImage((Image)this.source, 0, 0, null);
        }
        this.subtractBaseline();
        return this.output;
    }

    public JDialog getInspector() {
        Frame frame;
        if (this.inspector == null) {
            this.inspector = new Inspector();
        }
        if (this.inspector.isModal() && this.vidPanel != null && this.frame != (frame = JOptionPane.getFrameForComponent(this.vidPanel))) {
            this.frame = frame;
            if (this.inspector != null) {
                ((Component)this.inspector).setVisible(false);
            }
            this.inspector = new Inspector();
        }
        this.inspector.initialize();
        return this.inspector;
    }

    public void clear() {
        this.setBaselineImage(null);
    }

    public void refresh() {
        super.refresh();
        this.loadButton.setText(MediaRes.getString("Filter.Baseline.Button.Load"));
        this.captureButton.setText(MediaRes.getString("Filter.Baseline.Button.Capture"));
        this.captureButton.setText(MediaRes.getString("Filter.Baseline.Button.Capture"));
        if (this.inspector != null) {
            this.inspector.setTitle(MediaRes.getString("Filter.Baseline.Title"));
            this.inspector.pack();
        }
        this.loadButton.setEnabled(this.isEnabled());
        this.captureButton.setEnabled(this.isEnabled());
    }

    private void initialize(BufferedImage bufferedImage) {
        this.source = bufferedImage;
        this.w = this.source.getWidth();
        this.h = this.source.getHeight();
        this.pixels = new int[this.w * this.h];
        this.baselinePixels = new int[this.w * this.h];
        this.output = new BufferedImage(this.w, this.h, 1);
        if (this.source.getType() == 1) {
            this.input = this.source;
        } else {
            this.input = new BufferedImage(this.w, this.h, 1);
            this.gIn = this.input.createGraphics();
        }
    }

    private void subtractBaseline() {
        this.input.getRaster().getDataElements(0, 0, this.w, this.h, this.pixels);
        if (this.baseline != null) {
            for (int i = 0; i < this.pixels.length; ++i) {
                int n = this.pixels[i];
                int n2 = this.baselinePixels[i];
                int n3 = n >> 16 & 0xFF;
                n3 -= n2 >> 16 & 0xFF;
                n3 = Math.max(n3, 0);
                int n4 = n >> 8 & 0xFF;
                n4 -= n2 >> 8 & 0xFF;
                n4 = Math.max(n4, 0);
                int n5 = n & 0xFF;
                n5 -= n2 & 0xFF;
                n5 = Math.max(n5, 0);
                this.pixels[i] = n3 << 16 | n4 << 8 | n5;
            }
        }
        this.output.getRaster().setDataElements(0, 0, this.w, this.h, this.pixels);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            BaselineFilter baselineFilter = (BaselineFilter)object;
            if (baselineFilter.imagePath != null) {
                xMLControl.setValue("imagepath", baselineFilter.imagePath);
            }
            if (baselineFilter.frame != null && baselineFilter.inspector != null && baselineFilter.inspector.isVisible()) {
                int n = ((BaselineFilter)baselineFilter).inspector.getLocation().x - baselineFilter.frame.getLocation().x;
                int n2 = ((BaselineFilter)baselineFilter).inspector.getLocation().y - baselineFilter.frame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new BaselineFilter();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            BaselineFilter baselineFilter = (BaselineFilter)object;
            if (xMLControl.getPropertyNames().contains("imagepath")) {
                baselineFilter.load(xMLControl.getString("imagepath"));
            }
            baselineFilter.inspectorX = xMLControl.getInt("inspector_x");
            baselineFilter.inspectorY = xMLControl.getInt("inspector_y");
            return object;
        }
    }

    private class Inspector
    extends JDialog {
        public Inspector() {
            super(BaselineFilter.this.frame, !(BaselineFilter.this.frame instanceof OSPFrame));
            this.setTitle(MediaRes.getString("Filter.Baseline.Title"));
            this.setResizable(false);
            this.createGUI();
            BaselineFilter.this.refresh();
            this.pack();
            Rectangle rectangle = this.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - rectangle.width) / 2;
            int n2 = (dimension.height - rectangle.height) / 2;
            ((Component)this).setLocation(n, n2);
        }

        void createGUI() {
            BaselineFilter.this.loadButton = new JButton();
            BaselineFilter.this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BaselineFilter.this.load();
                }
            });
            BaselineFilter.this.captureButton = new JButton();
            BaselineFilter.this.captureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BaselineFilter.this.capture();
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout());
            this.setContentPane(jPanel);
            jPanel.add(BaselineFilter.this.ableButton);
            jPanel.add(BaselineFilter.this.loadButton);
            jPanel.add(BaselineFilter.this.captureButton);
            jPanel.add(BaselineFilter.this.clearButton);
            jPanel.add(BaselineFilter.this.closeButton);
        }

        void initialize() {
            BaselineFilter.this.refresh();
        }
    }
}

