/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.VectorPlot;

public class Vector2DFrame
extends DrawingFrame {
    GridData gridData;
    VectorPlot plot = new VectorPlot(null);
    GridTableFrame tableFrame;

    public Vector2DFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(string3);
        this.plot.setShowGridLines(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public Vector2DFrame(String string) {
        super(new InteractivePanel());
        this.setTitle(string);
        this.plot.setShowGridLines(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        JMenuItem jMenuItem = new JMenuItem("Legend");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector2DFrame.this.plot.showLegend();
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector2DFrame.this.showDataTable(true);
            }
        };
        jMenuItem.addActionListener(actionListener2);
        jMenu2.add(jMenuItem);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            jMenuItem2.addActionListener(actionListener2);
            this.drawingPanel.getPopupMenu().add(jMenuItem2);
        }
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.plot);
        return arrayList;
    }

    public double indexToX(int n) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToX(n);
    }

    public double indexToY(int n) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToY(n);
    }

    public int xToIndex(double d) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.xToIndex(d);
    }

    public int yToIndex(double d) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.yToIndex(d);
    }

    public int getNx() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNx();
    }

    public int getNy() {
        if (this.gridData == null) {
            return 0;
        }
        return this.gridData.getNy();
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.plot);
        return arrayList;
    }

    public void clearData() {
        if (this.gridData != null) {
            this.setAll(new double[2][this.gridData.getNx()][this.gridData.getNy()]);
        }
        this.drawingPanel.invalidateImage();
    }

    public void resizeGrid(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl = false;
        if (this.gridData == null) {
            d4 = this.drawingPanel.getPreferredXMin();
            d3 = this.drawingPanel.getPreferredXMax();
            d2 = this.drawingPanel.getPreferredYMin();
            d = this.drawingPanel.getPreferredYMax();
        } else {
            d4 = this.gridData.getLeft();
            d3 = this.gridData.getRight();
            d2 = this.gridData.getBottom();
            d = this.gridData.getTop();
            bl = this.gridData.isCellData();
        }
        this.gridData = new ArrayData(n, n2, 3);
        this.gridData.setComponentName(0, "magnitude");
        this.gridData.setComponentName(1, "x component");
        this.gridData.setComponentName(2, "y component");
        if (bl) {
            this.gridData.setCellScale(d4, d3, d2, d);
        } else {
            this.gridData.setScale(d4, d3, d2, d);
        }
        this.plot.setGridData(this.gridData);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setRow(int n, double[][] dArray) throws IllegalArgumentException {
        if (this.gridData.getNx() != dArray.length) {
            throw new IllegalArgumentException("Row data length does not match grid size.");
        }
        double[] dArray2 = this.gridData.getData()[1][n];
        double[] dArray3 = this.gridData.getData()[2][n];
        double[] dArray4 = this.gridData.getData()[0][n];
        System.arraycopy(dArray[0], 0, dArray2, 0, dArray.length);
        System.arraycopy(dArray[1], 0, dArray3, 0, dArray.length);
        int n2 = dArray4.length;
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = Math.atan2(dArray2[i], dArray3[i]);
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
    }

    public void setAll(double[][][] dArray, double d, double d2, double d3, double d4) {
        this.setAll(dArray);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(d, d2, d3, d4);
        } else {
            this.gridData.setScale(d, d2, d3, d4);
        }
    }

    public void setAll(double[][][] dArray) {
        if (this.gridData == null || this.gridData.getNx() != dArray.length || this.gridData.getNy() != dArray[0].length) {
            this.resizeGrid(dArray[0].length, dArray[0][0].length);
        }
        double[][] dArray2 = this.gridData.getData()[0];
        double[][] dArray3 = this.gridData.getData()[1];
        double[][] dArray4 = this.gridData.getData()[2];
        int n = dArray[0][0].length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = Math.sqrt(dArray[0][i][j] * dArray[0][i][j] + dArray[1][i][j] * dArray[1][i][j]);
                dArray3[i][j] = dArray2[i][j] == 0.0 ? 0.0 : dArray[0][i][j] / dArray2[i][j];
                dArray4[i][j] = dArray2[i][j] == 0.0 ? 0.0 : dArray[1][i][j] / dArray2[i][j];
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setZRange(boolean bl, double d, double d2) {
        this.plot.setAutoscaleZ(bl, d, d2);
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.gridData == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.gridData);
                this.tableFrame.setTitle("Vector Field Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

