/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ByteRaster;

public class RasterFrame
extends DrawingFrame {
    protected ByteRaster raster = new ByteRaster(1, 1);
    MouseInputAdapter mouseAdapter;
    int[] editValues = new int[2];
    int dragV;
    Color[] customColors;

    public RasterFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.setTitle(string3);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.raster);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public RasterFrame(String string) {
        super(new InteractivePanel());
        this.setTitle(string);
        this.addMenuItems();
        this.drawingPanel.addDrawable(this.raster);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        JMenuItem jMenuItem = new JMenuItem("Color");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RasterFrame.this.setColorPalette();
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Black and White");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RasterFrame.this.setBWPalette();
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
    }

    public void setBWPalette() {
        this.raster.setBWPalette();
        this.repaint();
    }

    public void setColorPalette() {
        if (this.customColors == null) {
            this.raster.createDefaultColors();
        } else {
            this.raster.setColorPalette(this.customColors);
        }
        this.repaint();
    }

    public void showLegend() {
        this.raster.showLegend();
    }

    public void setColorPalette(Color[] colorArray) {
        this.customColors = colorArray;
        this.raster.setColorPalette(colorArray);
        this.repaint();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.raster);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.raster);
        return arrayList;
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.raster);
        return arrayList;
    }

    public void clearData() {
        this.raster.setBlock(0, 0, new byte[this.raster.getNx()][this.raster.getNy()]);
        this.drawingPanel.invalidateImage();
    }

    public void randomize() {
        this.raster.randomize();
    }

    private void resizeRaster(int n, int n2) {
        this.drawingPanel.setPreferredSize(new Dimension(Math.max(n + this.drawingPanel.getLeftGutter() + this.drawingPanel.getRightGutter(), 50), Math.max(n2 + this.drawingPanel.getTopGutter() + this.drawingPanel.getBottomGutter(), 50)));
        this.pack();
        this.raster.resizeLattice(n, n2);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setIndexedColor(int n, Color color) {
        this.raster.setIndexedColor(n, color);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.raster.setMinMax(d, d2, d3, d4);
    }

    public void setAll(byte[][] byArray) {
        if (byArray.length != this.raster.getNx() || byArray[0].length != this.raster.getNy()) {
            this.resizeRaster(byArray.length, byArray[0].length);
        }
        this.raster.setBlock(0, 0, byArray);
    }

    public void setAll(int[][] nArray) {
        if (nArray.length != this.raster.getNx() || nArray[0].length != this.raster.getNy()) {
            this.resizeRaster(nArray.length, nArray[0].length);
        }
        this.raster.setBlock(0, 0, nArray);
    }

    public void setAll(int[][] nArray, double d, double d2, double d3, double d4) {
        this.setAll(nArray);
        this.raster.setMinMax(d, d2, d3, d4);
    }

    public void setAll(int[] nArray, int n, double d, double d2, double d3, double d4) {
        if (nArray.length % n != 0) {
            throw new IllegalArgumentException("Raster dimension must match number of values.");
        }
        this.resizeRaster(n, nArray.length / n);
        this.setAll(nArray);
        this.raster.setMinMax(d, d2, d3, d4);
    }

    public void setAll(int[] nArray) {
        if (nArray.length != this.raster.getNx() * this.raster.getNy()) {
            throw new IllegalArgumentException("Raster size must be set before using row-major format.");
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.setAtIndex(i, nArray[i]);
        }
    }

    public void setAtIndex(int n, int n2) {
        int n3 = this.raster.getNx();
        this.setValue(n % n3, n / n3, n2);
    }

    public void setValue(int n, int n2, int n3) {
        this.raster.setValue(n, n2, (byte)n3);
    }

    public int getAtIndex(int n) {
        int n2 = this.raster.getNx();
        return this.get(n % n2, n / n2);
    }

    public int get(int n, int n2) {
        return this.raster.getValue(n, n2) + 128;
    }

    public int[] getAll() {
        int n = this.raster.getNx() * this.raster.getNy();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getAtIndex(i);
        }
        return nArray;
    }

    public void setToggleOnClick(boolean bl, int n, int n2) {
        this.editValues = new int[]{n, n2};
        if (bl) {
            this.drawingPanel.addMouseListener(this.getMouseAdapter());
            this.drawingPanel.addMouseMotionListener(this.getMouseAdapter());
        } else {
            this.drawingPanel.removeMouseListener(this.getMouseAdapter());
            this.drawingPanel.removeMouseMotionListener(this.getMouseAdapter());
        }
    }

    void mouse(MouseEvent mouseEvent, boolean bl) {
        double d;
        if (mouseEvent.getButton() == 3) {
            return;
        }
        double d2 = this.drawingPanel.pixToX(mouseEvent.getX());
        int n = this.indexFromPoint(d2, d = this.drawingPanel.pixToY(mouseEvent.getY()));
        if (n == -1) {
            return;
        }
        if (bl) {
            this.dragV = this.editValues[0];
            int n2 = this.editValues.length;
            for (int i = 0; i < n2; ++i) {
                if (this.getAtIndex(n) != this.editValues[i]) continue;
                this.dragV = this.editValues[(i + 1) % n2];
            }
        }
        if (this.getAtIndex(n) != this.dragV) {
            this.setAtIndex(n, this.dragV);
            this.drawingPanel.render();
        }
    }

    public double indexToX(int n) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.indexToX(n);
    }

    public int xToIndex(double d) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.xToIndex(d);
    }

    public int yToIndex(double d) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.yToIndex(d);
    }

    public double indexToY(int n) {
        if (this.raster == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.raster.indexToY(n);
    }

    public int indexFromPoint(double d, double d2) {
        return this.raster.indexFromPoint(d, d2);
    }

    synchronized MouseInputAdapter getMouseAdapter() {
        if (this.mouseAdapter == null) {
            return new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    RasterFrame.this.mouse(mouseEvent, true);
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    RasterFrame.this.mouse(mouseEvent, false);
                }
            };
        }
        return this.mouseAdapter;
    }
}

