/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveCircle;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.PlottingPanel;

public class ParticleFrame
extends DrawingFrame {
    ArrayList partlist = new ArrayList();

    public ParticleFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.setTitle(string3);
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected Particles checkIndex(int n) {
        while (n >= this.partlist.size()) {
            Particles particles = new Particles();
            this.partlist.add(particles);
            ((InteractiveCircle)particles.shape).color = DisplayColors.getLineColor(this.partlist.indexOf(particles));
            this.addDrawable(particles);
        }
        return (Particles)this.partlist.get(n);
    }

    public void addParticle(int n, Point2D point2D) {
        this.checkIndex(n).addParticle(point2D);
    }

    public void addParicle(int n, Point2D[] point2DArray) {
        this.checkIndex(n).addParticles(point2DArray);
    }

    public void setDrawingShape(int n, Interactive interactive) {
        this.checkIndex((int)n).shape = interactive;
    }

    public void clearDrawables() {
        this.clearData();
        this.drawingPanel.clear();
    }

    public void clearData() {
        Iterator iterator = ((AbstractList)this.partlist).iterator();
        while (iterator.hasNext()) {
            Particles particles = (Particles)iterator.next();
            particles.clear();
            this.drawingPanel.removeDrawable(particles);
        }
        this.partlist.clear();
        this.drawingPanel.invalidateImage();
    }

    class Particles
    implements Drawable,
    Measurable {
        Interactive shape = new InteractiveCircle();
        private ArrayList pointList = new ArrayList();
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;

        Particles() {
            this.shape.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addParticle(Point2D point2D) {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                this.xmax = Math.max(this.xmax, point2D.getX());
                this.xmin = Math.min(this.xmin, point2D.getX());
                this.ymax = Math.max(this.ymax, point2D.getY());
                this.ymin = Math.min(this.ymin, point2D.getY());
                this.pointList.add(point2D);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addParticles(Point2D[] point2DArray) {
            int n = point2DArray.length;
            for (int i = 0; i < n; ++i) {
                this.xmax = Math.max(this.xmax, point2DArray[i].getX());
                this.xmin = Math.min(this.xmin, point2DArray[i].getX());
                this.ymax = Math.max(this.ymax, point2DArray[i].getY());
                this.ymin = Math.min(this.ymin, point2DArray[i].getY());
            }
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                this.pointList.add(point2DArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                this.pointList.clear();
                this.xmin = Double.MAX_VALUE;
                this.xmax = -1.7976931348623157E308;
                this.ymin = Double.MAX_VALUE;
                this.ymax = -1.7976931348623157E308;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                Iterator iterator = ((AbstractList)this.pointList).iterator();
                while (iterator.hasNext()) {
                    Point2D point2D = (Point2D)iterator.next();
                    this.shape.setXY(point2D.getX(), point2D.getY());
                    this.shape.draw(drawingPanel, graphics);
                }
            }
        }

        public double getXMax() {
            return this.xmax;
        }

        public double getXMin() {
            return this.xmin;
        }

        public double getYMax() {
            return this.ymax;
        }

        public double getYMin() {
            return this.ymin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMeasured() {
            ArrayList arrayList = this.pointList;
            synchronized (arrayList) {
                return this.pointList.size() > 0;
            }
        }
    }
}

