/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.Histogram;
import org.opensourcephysics.display.HistogramDataset;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.tools.DatasetTool;

public class HistogramFrame
extends DrawingFrame {
    protected Histogram histogram = new Histogram();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;
    DatasetTool tool;
    HistogramDataset dataset;
    JCheckBoxMenuItem logItem;
    static /* synthetic */ Class class$org$opensourcephysics$display$Histogram;

    public HistogramFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.drawingPanel.addDrawable(this.histogram);
        this.setTitle(string3);
        this.dataTable.add(this.histogram);
        this.setAnimated(true);
        this.setAutoclear(true);
        this.addMenuItems();
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistogramFrame.this.showDataTable(true);
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        this.logItem = new JCheckBoxMenuItem("Log Scale", false);
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistogramFrame.this.histogram.logScale = HistogramFrame.this.logItem.isSelected();
                HistogramFrame.this.drawingPanel.repaint();
            }
        });
        jMenu2.add(this.logItem);
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem2.addActionListener(actionListener);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            this.drawingPanel.getPopupMenu().add(jMenuItem2);
        }
    }

    protected JMenu loadToolsMenu() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        JMenu jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Dataset Tool");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double[][] dArray = HistogramFrame.this.histogram.logScale ? HistogramFrame.this.getLogPoints() : HistogramFrame.this.getPoints();
                double[] dArray2 = dArray[0];
                double[] dArray3 = dArray[1];
                double d = dArray2[0] - HistogramFrame.this.histogram.getBinWidth() / 2.0;
                double d2 = dArray2[dArray2.length - 1] + HistogramFrame.this.histogram.getBinWidth() / 2.0;
                if (HistogramFrame.this.tool == null || !HistogramFrame.this.tool.isDisplayable()) {
                    HistogramFrame.this.dataset = new HistogramDataset(d, d2, HistogramFrame.this.histogram.getBinWidth());
                    HistogramFrame.this.dataset.append(dArray2, dArray3);
                    HistogramFrame.this.tool = new DatasetTool(HistogramFrame.this.dataset);
                } else {
                    HistogramFrame.this.dataset.clear();
                    HistogramFrame.this.dataset.setBinWidth(d, d2, HistogramFrame.this.histogram.getBinWidth());
                    HistogramFrame.this.dataset.append(dArray2, dArray3);
                    HistogramFrame.this.tool.updateData(HistogramFrame.this.dataset);
                }
                HistogramFrame.this.tool.setVisible(true);
            }
        });
        return jMenu;
    }

    public double[] getXPoints() {
        return this.histogram.getXPoints();
    }

    public double[] getYPoints() {
        return this.histogram.getYPoints();
    }

    public double[][] getLogPoints() {
        return this.histogram.getLogPoints();
    }

    public double[][] getPoints() {
        return this.histogram.getPoints();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.histogram);
        this.showDataTable(false);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.histogram);
        return arrayList;
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.histogram);
        return arrayList;
    }

    public void clearData() {
        this.histogram.clear();
        this.dataTable.refreshTable();
        this.drawingPanel.invalidateImage();
    }

    public void append(double d) {
        this.histogram.append(d);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double d, double d2) {
        this.histogram.append(d, d2);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] dArray) {
        this.histogram.append(dArray);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setDiscrete(boolean bl) {
        this.histogram.setDiscrete(bl);
    }

    public void setLogScale(boolean bl) {
        this.histogram.logScale = bl;
        this.logItem.setSelected(bl);
    }

    public boolean isLogScale() {
        return this.histogram.logScale;
    }

    public void setBinWidth(double d) {
        this.histogram.setBinWidth(d);
    }

    public double getBinWidth() {
        return this.histogram.getBinWidth();
    }

    public void setBinColor(Color color, Color color2) {
        this.histogram.setBinColor(color, color2);
    }

    public void setBinStyle(short s) {
        this.histogram.setBinStyle(s);
    }

    public void setBinOffset(double d) {
        this.histogram.setBinOffset(d);
    }

    public void setNormalizedToOne(boolean bl) {
        this.histogram.setNormalizedToOne(bl);
        this.histogram.adjustForWidth = bl;
    }

    public void positiveX() {
        boolean bl = this.drawingPanel.isAutoscaleX();
        this.drawingPanel.setPreferredMinMaxX(0.0, this.drawingPanel.getPreferredXMax());
        this.drawingPanel.setAutoscaleX(bl);
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.dataTable.sort(0);
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new HistogramFrameLoader();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class HistogramFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected HistogramFrameLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            HistogramFrame histogramFrame = new HistogramFrame("x", "y", "Histogram Frame");
            return histogramFrame;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            HistogramFrame histogramFrame = (HistogramFrame)object;
            ArrayList arrayList = histogramFrame.getObjectOfClass(class$org$opensourcephysics$display$Histogram == null ? (class$org$opensourcephysics$display$Histogram = HistogramFrame.class$("org.opensourcephysics.display.Histogram")) : class$org$opensourcephysics$display$Histogram);
            if (arrayList.size() > 0) {
                histogramFrame.histogram = (Histogram)arrayList.get(0);
                histogramFrame.histogram.clear();
                histogramFrame.dataTable.add(histogramFrame.histogram);
            }
            return object;
        }
    }
}

