/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.EtchedBorder;
import org.opensourcephysics.analysis.FourierSinCosAnalysis;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.frames.PlotFrame;

public class FFTRealFrame
extends PlotFrame {
    public static final int FREQ = 1;
    public static final int OMEGA = 2;
    protected int domainType = 1;
    protected int gutter = 0;
    private FourierSinCosAnalysis fft = new FourierSinCosAnalysis();
    JMenuItem connectedItem;
    JMenuItem postItem;
    GroupControl gui;
    double[] x;
    double[] data;

    public FFTRealFrame(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setConnected(false);
        this.setMarkerShape(0, 8);
        this.setMarkerColor(0, Color.DARK_GRAY);
        this.limitAutoscaleY(-1.0E-5, 1.0E-5);
        this.setXYColumnNames(0, "frequency", "power", "Power Spectrun");
        this.setMarkerShape(1, 8);
        this.setMarkerColor(1, Color.RED);
        this.setXYColumnNames(1, "frequency", "re", "Real Coefficients");
        this.setMarkerShape(2, 8);
        this.setMarkerColor(2, Color.BLUE);
        this.setXYColumnNames(2, "frequency", "im", "Real Coefficients");
        this.dataTable.setRowNumberVisible(true);
        this.buildUserInterface();
        this.showPower();
    }

    void buildUserInterface() {
        this.setSize(350, 300);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EtchedBorder());
        this.gui = new GroupControl(this);
        this.gui.addObject(jPanel, "Panel", "name=inputPanel;layout=flow");
        this.gui.add("Panel", "name=radioPanel;parent=inputPanel");
        this.gui.add("RadioButton", "parent=radioPanel;text= sin;action=showSin()");
        this.gui.add("RadioButton", "parent=radioPanel;text= cos;action=showCos()");
        this.gui.add("RadioButton", "parent=radioPanel;text= power;action=showPower();selected=true");
        this.gui.add("Panel", "name=numberPanel; parent= inputPanel; layout=flow");
        this.gui.add("Label", "parent=numberPanel; text=added points=");
        this.gui.add("NumberField", "parent=numberPanel; variable=gutter; format=000; action=setGutter();size=40,16");
        this.getContentPane().add((Component)jPanel, "South");
    }

    public void showSin() {
        this.getDataset(0).setVisible(false);
        this.getDataset(1).setVisible(false);
        this.getDataset(2).setVisible(true);
        this.invalidateImage();
        this.repaint();
    }

    public void showCos() {
        this.getDataset(0).setVisible(false);
        this.getDataset(1).setVisible(true);
        this.getDataset(2).setVisible(false);
        this.invalidateImage();
        this.repaint();
    }

    public void showPower() {
        this.getDataset(0).setVisible(true);
        this.getDataset(1).setVisible(false);
        this.getDataset(2).setVisible(false);
        this.invalidateImage();
        this.repaint();
    }

    public void setGutter() {
        this.gutter = this.gui.getInt("gutter");
        this.doFFT();
    }

    public void setGutter(int n) {
        this.gutter = n;
        this.gui.setValue("gutter", n);
        this.doFFT();
    }

    public void setXLabel(String string) {
        this.setXYColumnNames(0, string, "power", "Power Spectrun");
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setXLabel(string);
        }
    }

    protected void addMenuItems() {
        super.addMenuItems();
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu == null) {
            jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu);
            jMenuBar.validate();
        } else {
            jMenu.addSeparator();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.postItem = new JRadioButtonMenuItem("Post View");
        buttonGroup.add(this.postItem);
        this.postItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTRealFrame.this.convertToPostView();
            }
        };
        this.postItem.addActionListener(actionListener);
        jMenu.add(this.postItem);
        this.connectedItem = new JRadioButtonMenuItem("Connected View");
        buttonGroup.add(this.connectedItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTRealFrame.this.convertToConnectedView();
            }
        };
        this.connectedItem.addActionListener(actionListener);
        jMenu.add(this.connectedItem);
    }

    public void setDomainType(int n) {
        this.domainType = n;
        switch (this.domainType) {
            case 1: {
                this.fft.useRadians(false);
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("frequency");
                break;
            }
            case 2: {
                this.fft.useRadians(true);
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("$\\omega$");
            }
        }
    }

    public void convertToPostView() {
        this.setConnected(false);
        this.setMarkerShape(0, 8);
        this.setMarkerShape(1, 8);
        this.setMarkerShape(2, 8);
        this.drawingPanel.invalidateImage();
        this.postItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    public void convertToConnectedView() {
        this.setConnected(true);
        this.setMarkerShape(0, 0);
        this.setMarkerShape(1, 0);
        this.setMarkerShape(2, 0);
        this.connectedItem.setSelected(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void doFFT(double[] dArray, double[] dArray2, int n) {
        this.x = new double[2 * (dArray.length / 2)];
        System.arraycopy(dArray, 0, this.x, 0, this.x.length);
        this.data = new double[2 * (dArray2.length / 2)];
        System.arraycopy(dArray2, 0, this.data, 0, this.data.length);
        this.gutter = n;
        this.gui.setValue("gutter", n);
        this.doFFT();
    }

    void doFFT() {
        if (this.x == null) {
            return;
        }
        this.fft.doAnalysis(this.x, this.data, this.gutter);
        this.clearData();
        double[][] dArray = this.fft.getData();
        this.append(0, dArray[0], dArray[1]);
        this.append(1, dArray[0], dArray[2]);
        this.append(2, dArray[0], dArray[3]);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
        this.invalidateImage();
        this.repaint();
    }

    public void setLogScale(boolean bl, boolean bl2) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScale(bl, bl2);
        }
    }
}

