/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.numerics.FFT;
import org.opensourcephysics.numerics.Function;

public class FFTFrame
extends DrawingFrame {
    public static final int MODE = 0;
    public static final int FREQ = 1;
    public static final int OMEGA = 2;
    public static final int WAVENUMBER = 3;
    public static final int MOMENTUM = 4;
    protected int domainType = 1;
    protected ComplexDataset complexDataset = new ComplexDataset();
    protected DataTable dataTable = new DataTable();
    protected DataTableFrame tableFrame;
    private double[] fftData = new double[1];
    private FFT fft = new FFT(1);
    JMenuItem ampPhaseItem;
    JMenuItem postItem;
    JMenuItem barItem;

    public FFTFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.complexDataset.setMarkerShape(4);
        this.complexDataset.setXYColumnNames(string, "re", "im");
        this.drawingPanel.addDrawable(this.complexDataset);
        this.setTitle(string3);
        this.dataTable.add(this.complexDataset);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.postItem = new JRadioButtonMenuItem("Post View");
        buttonGroup.add(this.postItem);
        this.postItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTFrame.this.convertToPostView();
            }
        };
        this.postItem.addActionListener(actionListener);
        jMenu2.add(this.postItem);
        this.barItem = new JRadioButtonMenuItem("Bar View");
        buttonGroup.add(this.barItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTFrame.this.convertToPhaseBarView();
            }
        };
        this.barItem.addActionListener(actionListener);
        jMenu2.add(this.barItem);
        this.ampPhaseItem = new JRadioButtonMenuItem("Amp & Phase");
        buttonGroup.add(this.ampPhaseItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTFrame.this.convertToAmpAndPhaseView();
            }
        };
        this.ampPhaseItem.addActionListener(actionListener);
        jMenu2.add(this.ampPhaseItem);
        jMenu2.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTFrame.this.showDataTable(true);
            }
        };
        jMenuItem.addActionListener(actionListener2);
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem2.addActionListener(actionListener2);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            this.drawingPanel.getPopupMenu().add(jMenuItem2);
        }
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem("Phase Legend");
        actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTFrame.this.complexDataset.showLegend();
            }
        };
        jMenuItem.addActionListener(actionListener2);
        jMenu2.add(jMenuItem);
    }

    public void setXYColumnNames(String string, String string2, String string3) {
        this.complexDataset.setXYColumnNames(string, string2, string3);
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setXLabel(string);
        }
    }

    public void setDomainType(int n) {
        this.domainType = n;
        switch (this.domainType) {
            case 0: {
                this.complexDataset.setXYColumnNames("mode", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("mode");
                break;
            }
            case 1: {
                this.complexDataset.setXYColumnNames("f", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("frequency");
                break;
            }
            case 2: {
                this.complexDataset.setXYColumnNames("omega", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("omega");
                break;
            }
            case 3: {
                this.complexDataset.setXYColumnNames("k", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("wavenumber");
                break;
            }
            case 4: {
                this.complexDataset.setXYColumnNames("p", "re", "im");
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setXLabel("momentum");
            }
        }
    }

    public void convertToPostView() {
        this.complexDataset.setMarkerShape(4);
        this.drawingPanel.invalidateImage();
        this.postItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    public void convertToAmpAndPhaseView() {
        this.complexDataset.setMarkerShape(2);
        this.ampPhaseItem.setSelected(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void convertToPhaseBarView() {
        this.complexDataset.setMarkerShape(3);
        this.barItem.setSelected(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void doFFT(Function function, Function function2, double d, double d2, int n) {
        if (2 * n != this.fftData.length) {
            this.fftData = new double[2 * n];
            this.fft = new FFT(n);
        }
        int n2 = (int)((double)n * d / (d2 - d));
        n2 = Math.abs(n2);
        double d3 = d;
        double d4 = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            int n3 = (n2 + i) % n;
            this.fftData[2 * n3] = function == null ? 0.0 : function.evaluate(d3);
            this.fftData[2 * n3 + 1] = function2 == null ? 0.0 : function2.evaluate(d3);
            d3 += d4;
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double[] dArray = null;
        switch (this.domainType) {
            case 0: {
                dArray = this.fft.getNaturalModes();
                break;
            }
            case 1: {
                dArray = this.fft.getNaturalFreq(d, d2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                dArray = this.fft.getNaturalOmega(d, d2);
            }
        }
        this.complexDataset.clear();
        this.complexDataset.append(dArray, this.fftData);
    }

    public void doRealFFT(double[] dArray, double d, double d2) {
        int n = this.fft.getN();
        if (2 * dArray.length != this.fftData.length) {
            n = dArray.length;
            this.fftData = new double[2 * n];
            this.fft = new FFT(n);
        }
        int n2 = (int)((double)n * d / (d2 - d));
        n2 = Math.abs(n2);
        for (int i = 0; i < n; ++i) {
            int n3 = (n2 + i) % n;
            this.fftData[2 * n3] = dArray[i];
            this.fftData[2 * n3 + 1] = 0.0;
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double[] dArray2 = null;
        switch (this.domainType) {
            case 0: {
                dArray2 = this.fft.getNaturalModes();
                break;
            }
            case 1: {
                dArray2 = this.fft.getNaturalFreq(d, d2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                dArray2 = this.fft.getNaturalOmega(d, d2);
            }
        }
        this.complexDataset.clear();
        this.complexDataset.append(dArray2, this.fftData);
    }

    public void doFFT(double[] dArray, double d, double d2) {
        int n = this.fft.getN();
        if (dArray.length != this.fftData.length) {
            this.fftData = new double[dArray.length];
            n = dArray.length / 2;
            this.fft = new FFT(n);
        }
        int n2 = (int)((double)n * d / (d2 - d));
        n2 = Math.abs(n2);
        for (int i = 0; i < n; ++i) {
            int n3 = (n2 + i) % n;
            this.fftData[2 * n3] = dArray[2 * i];
            this.fftData[2 * n3 + 1] = dArray[2 * i + 1];
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double[] dArray2 = null;
        switch (this.domainType) {
            case 0: {
                dArray2 = this.fft.getNaturalModes();
                break;
            }
            case 1: {
                dArray2 = this.fft.getNaturalFreq(d, d2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                dArray2 = this.fft.getNaturalOmega(d, d2);
            }
        }
        this.complexDataset.clear();
        this.complexDataset.append(dArray2, this.fftData);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.complexDataset);
        return arrayList;
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.complexDataset);
        this.showDataTable(false);
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.complexDataset);
        return arrayList;
    }

    public void clearData() {
        this.complexDataset.clear();
        this.dataTable.refreshTable();
        this.drawingPanel.invalidateImage();
    }

    public void setLogScale(boolean bl, boolean bl2) {
        if (this.drawingPanel instanceof PlottingPanel) {
            ((PlottingPanel)this.drawingPanel).setLogScale(bl, bl2);
        }
    }

    public void showLegend() {
        this.complexDataset.showLegend();
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.dataTable.sort(0);
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }
}

