/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.ComplexGridPlot;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.ComplexSurfacePlot;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlotMouseController;
import org.opensourcephysics.numerics.FFT2D;

public class FFT2DFrame
extends DrawingFrame {
    static final double PI2 = Math.PI * 2;
    public static final int MODE = 0;
    public static final int FREQ = 1;
    public static final int OMEGA = 2;
    public static final int WAVENUMBER = 3;
    public static final int MOMENTUM = 4;
    protected int domainType = 3;
    GridData gridData;
    FFT2D fft;
    double[] fftData;
    Plot2D plot = new ComplexGridPlot(null);
    SurfacePlotMouseController surfacePlotMC;
    JMenuItem gridItem;
    JMenuItem interpolatedItem;
    JMenuItem surfaceItem;

    public FFT2DFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(string3);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    public FFT2DFrame(String string) {
        super(new InteractivePanel());
        this.setTitle(string);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.gridItem = new JRadioButtonMenuItem("Grid Plot");
        buttonGroup.add(this.gridItem);
        this.gridItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFT2DFrame.this.convertToGridPlot();
            }
        };
        this.gridItem.addActionListener(actionListener);
        jMenu2.add(this.gridItem);
        this.surfaceItem = new JRadioButtonMenuItem("Surface Plot");
        buttonGroup.add(this.surfaceItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFT2DFrame.this.convertToSurfacePlot();
            }
        };
        this.surfaceItem.addActionListener(actionListener);
        jMenu2.add(this.surfaceItem);
        this.interpolatedItem = new JRadioButtonMenuItem("Interpolated Plot");
        buttonGroup.add(this.interpolatedItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFT2DFrame.this.convertToInterpolatedPlot();
            }
        };
        this.interpolatedItem.addActionListener(actionListener);
        jMenu2.add(this.interpolatedItem);
        jMenu2.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Phase Legend");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexColorMapper.showPhaseLegend();
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
    }

    public void convertToInterpolatedPlot() {
        if (!(this.plot instanceof ComplexInterpolatedPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexInterpolatedPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.repaint();
            this.interpolatedItem.setSelected(true);
        }
    }

    public void convertToGridPlot() {
        if (!(this.plot instanceof ComplexGridPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexGridPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            this.gridItem.setSelected(true);
        }
    }

    public void convertToSurfacePlot() {
        if (!(this.plot instanceof ComplexSurfacePlot)) {
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexSurfacePlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
        }
    }

    private void resizeGrid(int n, int n2) {
        this.fftData = new double[2 * n * n2];
        this.fft = new FFT2D(n, n2);
        this.gridData = new ArrayData(n, n2, 3);
        this.plot.setGridData(this.gridData);
        this.plot.update();
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setDomainType(int n) {
        this.domainType = n;
        switch (this.domainType) {
            case 0: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("x mode");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("y mode");
                break;
            }
            case 1: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("x frequency");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("y frequency");
                break;
            }
            case 2: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("x omega");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("y omega");
                break;
            }
            case 3: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("k_x");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("k_y");
                break;
            }
            case 4: {
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).setXLabel("p_x");
                }
                if (!(this.drawingPanel instanceof PlottingPanel)) break;
                ((PlottingPanel)this.drawingPanel).setYLabel("p_y");
            }
        }
    }

    public void doFFT(double[][][] dArray, double d, double d2, double d3, double d4) {
        if (this.gridData == null) {
            throw new IllegalStateException("Grid must be set before using row-major format.");
        }
        int n = this.gridData.getNx();
        int n2 = this.gridData.getNy();
        if (dArray[0].length != n || dArray[0][0].length != n2) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        double[][] dArray2 = dArray[0];
        double[][] dArray3 = dArray[1];
        int n3 = (int)((double)n * d / (d2 - d));
        n3 = Math.abs(n3);
        int n4 = (int)((double)n2 * d3 / (d4 - d3));
        n4 = Math.abs(n4);
        for (int i = 0; i < n; ++i) {
            int n5 = (n3 + i) % n;
            int n6 = 2 * n5 * n;
            for (int j = 0; j < n2; ++j) {
                int n7 = (n3 + j) % n2;
                this.fftData[n6 + 2 * n7] = dArray2[i][j];
                this.fftData[n6 + 2 * n7 + 1] = dArray3[i][j];
            }
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double d5 = -n / 2;
        double d6 = (n + 1) / 2 - 1;
        double d7 = -n2 / 2;
        double d8 = (n2 + 1) / 2 - 1;
        switch (this.domainType) {
            case 0: {
                break;
            }
            case 1: {
                d6 = this.fft.getFreqMax(d, d2, n);
                d5 = this.fft.getFreqMin(d, d2, n);
                d8 = this.fft.getFreqMax(d3, d4, n2);
                d7 = this.fft.getFreqMin(d3, d4, n2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                d6 = Math.PI * 2 * this.fft.getFreqMax(d, d2, n);
                d5 = Math.PI * 2 * this.fft.getFreqMin(d, d2, n);
                d8 = Math.PI * 2 * this.fft.getFreqMax(d3, d4, n2);
                d7 = Math.PI * 2 * this.fft.getFreqMin(d3, d4, n2);
            }
        }
        this.gridData.setCenteredCellScale(d5, d6, d8, d7);
        this.fillGrid(n, n2, this.fftData);
        this.plot.update();
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void doFFT(double[] dArray, int n, double d, double d2, double d3, double d4) throws IllegalArgumentException {
        if (dArray.length / 2 % n != 0) {
            throw new IllegalArgumentException("Number of values in grid (nx*ny) must match number of values.");
        }
        int n2 = dArray.length / n / 2;
        this.resizeGrid(n, n2);
        if (dArray.length != 2 * n * n2) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        int n3 = (int)((double)n * d / (d2 - d));
        n3 = Math.abs(n3);
        int n4 = (int)((double)n2 * d3 / (d4 - d3));
        n4 = Math.abs(n4);
        for (int i = 0; i < n2; ++i) {
            int n5 = (n4 + i) % n2;
            int n6 = 2 * i * n;
            int n7 = 2 * n5 * n;
            for (int j = 0; j < n; ++j) {
                int n8 = (n3 + j) % n;
                this.fftData[n6 + 2 * n8] = dArray[n7 + 2 * j];
                this.fftData[n6 + 2 * n8 + 1] = dArray[n7 + 2 * j + 1];
            }
        }
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double d5 = -n / 2;
        double d6 = (n + 1) / 2 - 1;
        double d7 = -n2 / 2;
        double d8 = (n2 + 1) / 2 - 1;
        switch (this.domainType) {
            case 0: {
                break;
            }
            case 1: {
                d6 = this.fft.getFreqMax(d, d2, n);
                d5 = this.fft.getFreqMin(d, d2, n);
                d8 = this.fft.getFreqMax(d3, d4, n2);
                d7 = this.fft.getFreqMin(d3, d4, n2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                d6 = Math.PI * 2 * this.fft.getFreqMax(d, d2, n);
                d5 = Math.PI * 2 * this.fft.getFreqMin(d, d2, n);
                d8 = Math.PI * 2 * this.fft.getFreqMax(d3, d4, n2);
                d7 = Math.PI * 2 * this.fft.getFreqMin(d3, d4, n2);
            }
        }
        this.gridData.setCenteredCellScale(d5, d6, d8, d7);
        this.fillGrid(n, n2, this.fftData);
        this.plot.update();
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.plot);
        return arrayList;
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.plot);
        return arrayList;
    }

    private void fillGrid(int n, int n2, double[] dArray) {
        double[][] dArray2 = this.gridData.getData()[0];
        double[][] dArray3 = this.gridData.getData()[1];
        double[][] dArray4 = this.gridData.getData()[2];
        for (int i = 0; i < n2; ++i) {
            int n3 = 2 * i * n;
            for (int j = 0; j < n; ++j) {
                double d = dArray[n3 + 2 * j];
                double d2 = dArray[n3 + 2 * j + 1];
                dArray2[j][i] = Math.sqrt(d * d + d2 * d2);
                dArray3[j][i] = d;
                dArray4[j][i] = d2;
            }
        }
    }
}

