/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.PlottingPanel;

public class ComplexPlotFrame
extends DrawingFrame {
    protected ComplexDataset complexDataset = new ComplexDataset();
    protected DataTable dataTable = new DataTable();
    JMenuItem ampPhaseItem;
    JMenuItem reImItem;
    JMenuItem postItem;
    JMenuItem barItem;
    protected DataTableFrame tableFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$ComplexDataset;

    public ComplexPlotFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, string3));
        this.setTitle(string3);
        this.drawingPanel.addDrawable(this.complexDataset);
        this.dataTable.add(this.complexDataset);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.ampPhaseItem = new JRadioButtonMenuItem("Amp & Phase");
        buttonGroup.add(this.ampPhaseItem);
        this.ampPhaseItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexPlotFrame.this.convertToAmpAndPhaseView();
            }
        };
        this.ampPhaseItem.addActionListener(actionListener);
        jMenu2.add(this.ampPhaseItem);
        this.postItem = new JRadioButtonMenuItem("Post View");
        buttonGroup.add(this.postItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexPlotFrame.this.convertToPostView();
            }
        };
        this.postItem.addActionListener(actionListener);
        jMenu2.add(this.postItem);
        this.barItem = new JRadioButtonMenuItem("Bar View");
        buttonGroup.add(this.barItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexPlotFrame.this.convertToPhaseBarView();
            }
        };
        this.barItem.addActionListener(actionListener);
        jMenu2.add(this.barItem);
        this.reImItem = new JRadioButtonMenuItem("Re Im Components");
        buttonGroup.add(this.reImItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexPlotFrame.this.convertToReImView();
            }
        };
        this.reImItem.addActionListener(actionListener);
        jMenu2.add(this.reImItem);
        jMenu2.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexPlotFrame.this.showDataTable(true);
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Phase Legend");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexPlotFrame.this.complexDataset.showLegend();
            }
        };
        jMenuItem2.addActionListener(actionListener);
        jMenu2.add(jMenuItem2);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem jMenuItem3 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            jMenuItem3.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(jMenuItem3);
        }
    }

    protected void convertToPostView() {
        this.complexDataset.setMarkerShape(4);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
        this.postItem.setSelected(true);
    }

    protected void convertToAmpAndPhaseView() {
        this.complexDataset.setMarkerShape(2);
        this.complexDataset.setCentered(true);
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
        this.ampPhaseItem.setSelected(true);
    }

    protected void convertToPhaseBarView() {
        this.complexDataset.setMarkerShape(3);
        this.complexDataset.setCentered(false);
        this.drawingPanel.invalidateImage();
        this.barItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    protected void convertToReImView() {
        this.complexDataset.setMarkerShape(1);
        this.drawingPanel.invalidateImage();
        this.reImItem.setSelected(true);
        this.drawingPanel.repaint();
    }

    public void append(double d, double d2, double d3) {
        this.complexDataset.append(d, d2, d3);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] dArray, double[] dArray2) {
        this.complexDataset.append(dArray, dArray2);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void append(double[] dArray, double[] dArray2, double[] dArray3) {
        this.complexDataset.append(dArray, dArray2, dArray3);
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.dataTable.refreshTable();
        }
    }

    public void setConnected(boolean bl) {
        this.complexDataset.setConnected(bl);
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.complexDataset);
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.complexDataset);
        return arrayList;
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.complexDataset);
        return arrayList;
    }

    public void clearData() {
        this.complexDataset.clear();
        this.dataTable.refreshTable();
        this.drawingPanel.invalidateImage();
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                this.tableFrame = new DataTableFrame(this.getTitle() + " Data", this.dataTable);
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.dataTable.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new ComplexPlotFrameLoader();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ComplexPlotFrameLoader
    extends DrawingFrame.DrawingFrameLoader {
        protected ComplexPlotFrameLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            ComplexPlotFrame complexPlotFrame = new ComplexPlotFrame("x", "y", "Complex Plot Frame");
            return complexPlotFrame;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            ComplexPlotFrame complexPlotFrame = (ComplexPlotFrame)object;
            ArrayList arrayList = complexPlotFrame.getObjectOfClass(class$org$opensourcephysics$display$ComplexDataset == null ? (class$org$opensourcephysics$display$ComplexDataset = ComplexPlotFrame.class$("org.opensourcephysics.display.ComplexDataset")) : class$org$opensourcephysics$display$ComplexDataset);
            if (arrayList.size() > 0) {
                complexPlotFrame.complexDataset = (ComplexDataset)arrayList.get(0);
                complexPlotFrame.dataTable.clear();
                complexPlotFrame.dataTable.add(complexPlotFrame.complexDataset);
            }
            return object;
        }
    }
}

