/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.frames;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ComplexColorMapper;
import org.opensourcephysics.display2d.ComplexGridPlot;
import org.opensourcephysics.display2d.ComplexInterpolatedPlot;
import org.opensourcephysics.display2d.ComplexSurfacePlot;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridTableFrame;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.SurfacePlotMouseController;

public class Complex2DFrame
extends DrawingFrame {
    GridData gridData;
    boolean showGrid = true;
    Plot2D plot = new ComplexGridPlot(null);
    SurfacePlotMouseController surfacePlotMC;
    JMenuItem surfaceItem;
    JMenuItem gridItem;
    JMenuItem interpolatedItem;
    GridTableFrame tableFrame;
    int[] gutters;

    public Complex2DFrame(String string, String string2, String string3) {
        super(new PlottingPanel(string, string2, null));
        this.drawingPanel.setPreferredSize(new Dimension(350, 350));
        this.setTitle(string3);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorXGrid(false);
        ((PlottingPanel)this.drawingPanel).getAxes().setShowMajorYGrid(false);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
        this.gutters = this.drawingPanel.getGutters();
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.plot.setAutoscaleZ(bl, d, d2);
    }

    public void setBuffered(boolean bl) {
        this.drawingPanel.setBuffered(bl);
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
        this.plot.setShowGridLines(bl);
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public Complex2DFrame(String string) {
        super(new InteractivePanel());
        this.setTitle(string);
        this.drawingPanel.addDrawable(this.plot);
        this.addMenuItems();
        this.setAnimated(true);
        this.setAutoclear(true);
        this.gutters = this.drawingPanel.getGutters();
    }

    protected void addMenuItems() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        JMenu jMenu = this.removeMenu(DisplayRes.getString("DrawingFrame.Help_menu_item"));
        JMenu jMenu2 = this.getMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
        if (jMenu2 == null) {
            jMenu2 = new JMenu(DisplayRes.getString("DrawingFrame.Views_menu"));
            jMenuBar.add(jMenu2);
            jMenuBar.validate();
        } else {
            jMenu2.addSeparator();
        }
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.gridItem = new JRadioButtonMenuItem("Grid Plot");
        buttonGroup.add(this.gridItem);
        this.gridItem.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Complex2DFrame.this.convertToGridPlot();
            }
        };
        this.gridItem.addActionListener(actionListener);
        jMenu2.add(this.gridItem);
        this.surfaceItem = new JRadioButtonMenuItem("Surface Plot");
        buttonGroup.add(this.surfaceItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Complex2DFrame.this.convertToSurfacePlot();
            }
        };
        this.surfaceItem.addActionListener(actionListener);
        jMenu2.add(this.surfaceItem);
        this.interpolatedItem = new JRadioButtonMenuItem("Interpolated Plot");
        buttonGroup.add(this.interpolatedItem);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Complex2DFrame.this.convertToInterpolatedPlot();
            }
        };
        this.interpolatedItem.addActionListener(actionListener);
        jMenu2.add(this.interpolatedItem);
        jMenu2.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Phase Legend");
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplexColorMapper.showPhaseLegend();
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(84, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Complex2DFrame.this.showDataTable(true);
            }
        };
        jMenuItem2.addActionListener(actionListener);
        jMenu2.add(jMenuItem2);
        if (this.drawingPanel != null && this.drawingPanel.getPopupMenu() != null) {
            JMenuItem jMenuItem3 = new JMenuItem(DisplayRes.getString("DrawingFrame.DataTable_menu_item"));
            jMenuItem3.addActionListener(actionListener);
            this.drawingPanel.getPopupMenu().add(jMenuItem3);
        }
    }

    public synchronized ArrayList getDrawables() {
        ArrayList arrayList = super.getDrawables();
        ((AbstractCollection)arrayList).remove(this.plot);
        return arrayList;
    }

    public synchronized ArrayList getDrawables(Class clazz) {
        ArrayList arrayList = super.getDrawables(clazz);
        ((AbstractCollection)arrayList).remove(this.plot);
        return arrayList;
    }

    public void clearDrawables() {
        this.drawingPanel.clear();
        this.drawingPanel.addDrawable(this.plot);
    }

    public void clearData() {
        if (this.gridData != null) {
            this.setAll(new double[2][this.gridData.getNx()][this.gridData.getNy()]);
        }
        this.drawingPanel.invalidateImage();
    }

    public void convertToInterpolatedPlot() {
        if (!(this.plot instanceof ComplexInterpolatedPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexInterpolatedPlot(this.gridData);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            this.interpolatedItem.setSelected(true);
        }
    }

    public void convertToGridPlot() {
        if (!(this.plot instanceof ComplexGridPlot)) {
            if (this.surfacePlotMC != null) {
                this.drawingPanel.removeMouseListener(this.surfacePlotMC);
                this.drawingPanel.removeMouseMotionListener(this.surfacePlotMC);
                this.surfacePlotMC = null;
                this.drawingPanel.setGutters(this.gutters);
                if (this.drawingPanel instanceof PlottingPanel) {
                    ((PlottingPanel)this.drawingPanel).getAxes().setVisible(true);
                }
                this.drawingPanel.setShowCoordinates(true);
            }
            this.drawingPanel.removeDrawable(this.plot);
            this.plot = new ComplexGridPlot(this.gridData);
            this.plot.setShowGridLines(this.showGrid);
            this.drawingPanel.addDrawable(this.plot);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
            this.gridItem.setSelected(true);
        }
    }

    public void convertToSurfacePlot() {
        if (!(this.plot instanceof ComplexSurfacePlot)) {
            Plot2D plot2D = this.plot;
            try {
                ComplexSurfacePlot complexSurfacePlot = new ComplexSurfacePlot(this.gridData);
                this.plot = complexSurfacePlot;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.surfaceItem.setEnabled(false);
                this.gridItem.setSelected(true);
                this.convertToGridPlot();
                return;
            }
            this.gutters = this.drawingPanel.getGutters();
            if (this.drawingPanel instanceof PlottingPanel) {
                ((PlottingPanel)this.drawingPanel).getAxes().setVisible(false);
            }
            this.drawingPanel.setShowCoordinates(false);
            this.drawingPanel.setGutters(0, 0, 0, 0);
            boolean bl = plot2D.isAutoscaleZ();
            double d = plot2D.getFloor();
            double d2 = plot2D.getCeiling();
            this.plot.setAutoscaleZ(bl, d, d2);
            this.drawingPanel.replaceDrawable(plot2D, this.plot);
            this.plot.update();
            if (this.tableFrame != null && this.tableFrame.isShowing()) {
                this.tableFrame.refreshTable();
            }
            this.drawingPanel.repaint();
            if (this.surfacePlotMC == null) {
                this.surfacePlotMC = new SurfacePlotMouseController(this.drawingPanel, this.plot);
            }
            this.drawingPanel.addMouseListener(this.surfacePlotMC);
            this.drawingPanel.addMouseMotionListener(this.surfacePlotMC);
            this.surfaceItem.setSelected(true);
            this.drawingPanel.invalidateImage();
            this.drawingPanel.repaint();
        }
    }

    public void resizeGrid(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl = false;
        if (this.gridData == null) {
            d4 = this.drawingPanel.getPreferredXMin();
            d3 = this.drawingPanel.getPreferredXMax();
            d2 = this.drawingPanel.getPreferredYMin();
            d = this.drawingPanel.getPreferredYMax();
        } else {
            d4 = this.gridData.getLeft();
            d3 = this.gridData.getRight();
            d2 = this.gridData.getBottom();
            d = this.gridData.getTop();
            bl = this.gridData.isCellData();
        }
        this.gridData = new ArrayData(n, n2, 3);
        this.gridData.setComponentName(0, "magnitude");
        this.gridData.setComponentName(1, "real");
        this.gridData.setComponentName(2, "imaginary");
        if (bl) {
            this.gridData.setCellScale(d4, d3, d2, d);
        } else {
            this.gridData.setScale(d4, d3, d2, d);
        }
        if (n != n2) {
            this.surfaceItem.setEnabled(false);
            if (this.plot instanceof ComplexSurfacePlot) {
                this.convertToGridPlot();
            }
        } else {
            this.surfaceItem.setEnabled(true);
        }
        this.plot.setGridData(this.gridData);
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
        this.drawingPanel.repaint();
    }

    public void setRow(int n, double[][] dArray) throws IllegalArgumentException {
        if (this.gridData.getNx() != dArray.length) {
            throw new IllegalArgumentException("Row data length does not match grid size.");
        }
        double[] dArray2 = this.gridData.getData()[1][n];
        double[] dArray3 = this.gridData.getData()[2][n];
        double[] dArray4 = this.gridData.getData()[0][n];
        System.arraycopy(dArray[0], 0, dArray2, 0, dArray.length);
        System.arraycopy(dArray[1], 0, dArray3, 0, dArray.length);
        int n2 = dArray4.length;
        for (int i = 0; i < n2; ++i) {
            dArray4[i] = Math.atan2(dArray2[i], dArray3[i]);
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[][][] dArray, double d, double d2, double d3, double d4) {
        this.setAll(dArray);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(d, d2, d3, d4);
        } else {
            this.gridData.setScale(d, d2, d3, d4);
        }
    }

    public void setAll(double[][][] dArray) {
        this.resizeGrid(dArray[0].length, dArray[0][0].length);
        double[][] dArray2 = this.gridData.getData()[0];
        double[][] dArray3 = this.gridData.getData()[1];
        double[][] dArray4 = this.gridData.getData()[2];
        int n = dArray[0][0].length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(dArray[0][i], 0, dArray3[i], 0, n);
            System.arraycopy(dArray[1][i], 0, dArray4[i], 0, n);
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = Math.sqrt(dArray[0][i][j] * dArray[0][i][j] + dArray[1][i][j] * dArray[1][i][j]);
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public void setAll(double[] dArray, int n, double d, double d2, double d3, double d4) {
        if (dArray.length / 2 % n != 0) {
            throw new IllegalArgumentException("Number of values in grid (nx*ny) must match number of values.");
        }
        this.resizeGrid(n, dArray.length / n);
        this.setAll(dArray);
        if (this.gridData.isCellData()) {
            this.gridData.setCellScale(d, d2, d3, d4);
        } else {
            this.gridData.setScale(d, d2, d3, d4);
        }
    }

    public void setAll(double[] dArray) {
        int n;
        if (this.gridData == null) {
            throw new IllegalArgumentException("Grid size must be set before using row-major format.");
        }
        int n2 = this.gridData.getNx();
        if (dArray.length != 2 * n2 * (n = this.gridData.getNy())) {
            throw new IllegalArgumentException("Grid does not have the correct size.");
        }
        double[][] dArray2 = this.gridData.getData()[0];
        double[][] dArray3 = this.gridData.getData()[1];
        double[][] dArray4 = this.gridData.getData()[2];
        for (int i = 0; i < n; ++i) {
            int n3 = 2 * i * n2;
            for (int j = 0; j < n2; ++j) {
                double d = dArray[n3 + 2 * j];
                double d2 = dArray[n3 + 2 * j + 1];
                dArray2[j][i] = Math.sqrt(d * d + d2 * d2);
                dArray3[j][i] = d;
                dArray4[j][i] = d2;
            }
        }
        this.plot.update();
        if (this.tableFrame != null && this.tableFrame.isShowing()) {
            this.tableFrame.refreshTable();
        }
        this.drawingPanel.invalidateImage();
    }

    public synchronized void showDataTable(boolean bl) {
        if (bl) {
            if (this.tableFrame == null || !this.tableFrame.isDisplayable()) {
                if (this.gridData == null) {
                    return;
                }
                this.tableFrame = new GridTableFrame(this.gridData);
                this.tableFrame.setTitle("Complex Field Data");
                this.tableFrame.setDefaultCloseOperation(2);
            }
            this.tableFrame.refreshTable();
            this.tableFrame.setVisible(true);
        } else {
            this.tableFrame.setVisible(false);
            this.tableFrame.dispose();
            this.tableFrame = null;
        }
    }

    public double indexToX(int n) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToX(n);
    }

    public int xToIndex(double d) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.xToIndex(d);
    }

    public int yToIndex(double d) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.yToIndex(d);
    }

    public double indexToY(int n) {
        if (this.gridData == null) {
            throw new IllegalStateException("Data has not been set.  Invoke setAll before invoking this method.");
        }
        return this.gridData.indexToY(n);
    }
}

