/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlTextArea
extends ControlSwingElement {
    static String _RETURN_ = System.getProperty("line.separator");
    protected JTextArea textarea;
    private JScrollPane panel;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private static ArrayList infoList = null;

    public ControlTextArea(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof JTextArea) {
            this.textarea = (JTextArea)object;
        } else {
            this.textarea = new JTextArea(5, 5);
            this.textarea.setEditable(false);
        }
        this.panel = new JScrollPane(this.textarea);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.panel.setBorder(this.etchedBorder);
        return this.textarea;
    }

    public Component getComponent() {
        return this.panel;
    }

    public void reset() {
        this.textarea.setText("");
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getString().equals(this.titledBorder.getTitle())) break;
                this.titledBorder.setTitle(value.getString());
                this.panel.setBorder(this.titledBorder);
                this.panel.repaint();
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.panel.setBorder(this.etchedBorder);
                this.panel.repaint();
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }

    public void clear() {
        this.textarea.setText("");
        this.textarea.setCaretPosition(this.textarea.getText().length());
    }

    public void println(String string) {
        this.print(string + _RETURN_);
    }

    public void print(String string) {
        this.textarea.append(string);
        this.textarea.setCaretPosition(this.textarea.getText().length());
    }
}

