/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParsePosition;
import javax.swing.JTextField;
import org.opensourcephysics.ejs.control.swing.ControlNumberField;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.numerics.SuryonoParser;

public class ControlParsedNumberField
extends ControlNumberField {
    protected SuryonoParser parser = new SuryonoParser(0);

    public ControlParsedNumberField(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.textfield = object instanceof JTextField ? (JTextField)object : new JTextField();
        this.format = ControlNumberField.defaultFormat;
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.internalValue = new DoubleValue(this.defaultValue);
        this.textfield.setText(this.format.format(this.internalValue.value));
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new ControlNumberField.MyKeyListener());
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlParsedNumberField.this.setColor(ControlParsedNumberField.this.defaultColor);
            String string = ControlParsedNumberField.this.textfield.getText().trim();
            try {
                ParsePosition parsePosition = new ParsePosition(0);
                ControlParsedNumberField.this.setInternalValue(ControlParsedNumberField.this.format.parse(string, parsePosition).doubleValue());
                if (string.length() == parsePosition.getIndex()) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ControlParsedNumberField.this.parser.parse(string);
                ControlParsedNumberField.this.setInternalValue(ControlParsedNumberField.this.parser.evaluate());
                return;
            }
            catch (ParserException parserException) {
                ControlParsedNumberField.this.setColor(ControlParsedNumberField.this.errorColor);
                return;
            }
        }
    }
}

