/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPanel
extends ControlContainer {
    protected JPanel panel;
    private LayoutManager myLayout = null;
    private Rectangle myBorder = null;
    private static ArrayList infoList = null;

    public ControlPanel(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.panel = object instanceof JPanel ? (JPanel)object : new JPanel();
        return this.panel;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.add("border");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("layout")) {
            return "Layout|Object";
        }
        if (string.equals("border")) {
            return "Margins|Object";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                LayoutManager layoutManager;
                if (!(value.getObject() instanceof LayoutManager) || (layoutManager = (LayoutManager)value.getObject()) == this.myLayout) break;
                this.myLayout = layoutManager;
                this.getContainer().setLayout(this.myLayout);
                this.panel.validate();
                break;
            }
            case 1: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myBorder) break;
                this.panel.setBorder(new EmptyBorder(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                this.myBorder = rectangle;
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.panel.validate();
                break;
            }
            case 1: {
                this.panel.setBorder(null);
                this.myBorder = null;
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }
}

