/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.controls.ParsableTextArea;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlInputArea
extends ControlSwingElement {
    protected ParsableTextArea inputarea;
    private JScrollPane pane;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private static ArrayList infoList = null;

    public ControlInputArea(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof ParsableTextArea) {
            this.inputarea = (ParsableTextArea)object;
        } else {
            this.inputarea = new ParsableTextArea();
            this.inputarea.setEditable(true);
        }
        this.pane = new JScrollPane(this.inputarea);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.pane.setBorder(this.etchedBorder);
        return this.inputarea;
    }

    public Component getComponent() {
        return this.pane;
    }

    public void reset() {
        this.inputarea.setText("");
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("title");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("title")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.titledBorder.getTitle() == value.getString()) {
                    return;
                }
                this.titledBorder.setTitle(value.getString());
                this.pane.setBorder(this.titledBorder);
                this.pane.repaint();
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.pane.setBorder(this.etchedBorder);
                this.pane.repaint();
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }
}

